/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.datasketches.theta;

import com.google.common.base.Supplier;
import com.yahoo.sketches.memory.Memory;
import com.yahoo.sketches.theta.Sketch;
import io.druid.data.input.InputRow;
import io.druid.query.aggregation.datasketches.theta.SketchObjectStrategy;
import io.druid.query.aggregation.datasketches.theta.SketchOperations;
import io.druid.segment.column.ColumnBuilder;
import io.druid.segment.data.GenericIndexed;
import io.druid.segment.data.ObjectStrategy;
import io.druid.segment.serde.ComplexColumnPartSupplier;
import io.druid.segment.serde.ComplexMetricExtractor;
import io.druid.segment.serde.ComplexMetricSerde;
import java.nio.ByteBuffer;

public class SketchMergeComplexMetricSerde
extends ComplexMetricSerde {
    private SketchObjectStrategy strategy = new SketchObjectStrategy();

    public String getTypeName() {
        return "thetaSketch";
    }

    public ComplexMetricExtractor getExtractor() {
        return new ComplexMetricExtractor(){

            public Class<?> extractedClass() {
                return Sketch.class;
            }

            public Object extractValue(InputRow inputRow, String metricName) {
                Object object = inputRow.getRaw(metricName);
                if (object == null || object instanceof Sketch || object instanceof Memory) {
                    return object;
                }
                return SketchOperations.deserialize(object);
            }
        };
    }

    public void deserializeColumn(ByteBuffer buffer, ColumnBuilder builder) {
        GenericIndexed ge = GenericIndexed.read((ByteBuffer)buffer, (ObjectStrategy)this.strategy);
        builder.setComplexColumn((Supplier)new ComplexColumnPartSupplier(this.getTypeName(), ge));
    }

    public ObjectStrategy<Sketch> getObjectStrategy() {
        return this.strategy;
    }
}

