/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.druid.granularity.QueryGranularities;
import io.druid.granularity.QueryGranularity;
import io.druid.query.DataSource;
import io.druid.query.Result;
import io.druid.query.TableDataSource;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.datasourcemetadata.DataSourceMetadataQuery;
import io.druid.query.dimension.DefaultDimensionSpec;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.filter.AndDimFilter;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.InDimFilter;
import io.druid.query.filter.NoopDimFilter;
import io.druid.query.filter.NotDimFilter;
import io.druid.query.filter.OrDimFilter;
import io.druid.query.filter.SelectorDimFilter;
import io.druid.query.metadata.metadata.ColumnIncluderator;
import io.druid.query.metadata.metadata.SegmentMetadataQuery;
import io.druid.query.search.SearchResultValue;
import io.druid.query.search.search.ContainsSearchQuerySpec;
import io.druid.query.search.search.FragmentSearchQuerySpec;
import io.druid.query.search.search.InsensitiveContainsSearchQuerySpec;
import io.druid.query.search.search.SearchQuery;
import io.druid.query.search.search.SearchQuerySpec;
import io.druid.query.search.search.SearchSortSpec;
import io.druid.query.select.PagingSpec;
import io.druid.query.select.SelectQuery;
import io.druid.query.spec.LegacySegmentSpec;
import io.druid.query.spec.QuerySegmentSpec;
import io.druid.query.timeboundary.TimeBoundaryQuery;
import io.druid.query.timeboundary.TimeBoundaryResultValue;
import io.druid.query.timeseries.TimeseriesQuery;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class Druids {
    public static final Function<String, DimensionSpec> DIMENSION_IDENTITY = new Function<String, DimensionSpec>(){

        @Nullable
        public DimensionSpec apply(String input) {
            return new DefaultDimensionSpec(input, input);
        }
    };

    private Druids() {
        throw new AssertionError();
    }

    public static AndDimFilterBuilder newAndDimFilterBuilder() {
        return new AndDimFilterBuilder();
    }

    public static OrDimFilterBuilder newOrDimFilterBuilder() {
        return new OrDimFilterBuilder();
    }

    public static NotDimFilterBuilder newNotDimFilterBuilder() {
        return new NotDimFilterBuilder();
    }

    public static SelectorDimFilterBuilder newSelectorDimFilterBuilder() {
        return new SelectorDimFilterBuilder();
    }

    public static NoopDimFilterBuilder newNoopDimFilterBuilder() {
        return new NoopDimFilterBuilder();
    }

    public static TimeseriesQueryBuilder newTimeseriesQueryBuilder() {
        return new TimeseriesQueryBuilder();
    }

    public static SearchQueryBuilder newSearchQueryBuilder() {
        return new SearchQueryBuilder();
    }

    public static TimeBoundaryQueryBuilder newTimeBoundaryQueryBuilder() {
        return new TimeBoundaryQueryBuilder();
    }

    public static ResultBuilder newResultBuilder() {
        return new ResultBuilder();
    }

    public static ResultBuilder<SearchResultValue> newSearchResultBuilder() {
        return new ResultBuilder<SearchResultValue>();
    }

    public static ResultBuilder<TimeBoundaryResultValue> newTimeBoundaryResultBuilder() {
        return new ResultBuilder<TimeBoundaryResultValue>();
    }

    public static SegmentMetadataQueryBuilder newSegmentMetadataQueryBuilder() {
        return new SegmentMetadataQueryBuilder();
    }

    public static SelectQueryBuilder newSelectQueryBuilder() {
        return new SelectQueryBuilder();
    }

    public static DataSourceMetadataQueryBuilder newDataSourceMetadataQueryBuilder() {
        return new DataSourceMetadataQueryBuilder();
    }

    public static class DataSourceMetadataQueryBuilder {
        private DataSource dataSource = null;
        private QuerySegmentSpec querySegmentSpec = null;
        private Map<String, Object> context = null;

        public DataSourceMetadataQuery build() {
            return new DataSourceMetadataQuery(this.dataSource, this.querySegmentSpec, this.context);
        }

        public DataSourceMetadataQueryBuilder copy(DataSourceMetadataQueryBuilder builder) {
            return new DataSourceMetadataQueryBuilder().dataSource(builder.dataSource).intervals(builder.querySegmentSpec).context(builder.context);
        }

        public DataSourceMetadataQueryBuilder dataSource(String ds) {
            this.dataSource = new TableDataSource(ds);
            return this;
        }

        public DataSourceMetadataQueryBuilder dataSource(DataSource ds) {
            this.dataSource = ds;
            return this;
        }

        public DataSourceMetadataQueryBuilder intervals(QuerySegmentSpec q) {
            this.querySegmentSpec = q;
            return this;
        }

        public DataSourceMetadataQueryBuilder intervals(String s) {
            this.querySegmentSpec = new LegacySegmentSpec(s);
            return this;
        }

        public DataSourceMetadataQueryBuilder intervals(List<Interval> l) {
            this.querySegmentSpec = new LegacySegmentSpec((Object)l);
            return this;
        }

        public DataSourceMetadataQueryBuilder context(Map<String, Object> c) {
            this.context = c;
            return this;
        }
    }

    public static class SelectQueryBuilder {
        private DataSource dataSource = null;
        private QuerySegmentSpec querySegmentSpec = null;
        private boolean descending;
        private Map<String, Object> context = null;
        private DimFilter dimFilter = null;
        private QueryGranularity granularity = QueryGranularities.ALL;
        private List<DimensionSpec> dimensions = Lists.newArrayList();
        private List<String> metrics = Lists.newArrayList();
        private PagingSpec pagingSpec = null;

        public SelectQuery build() {
            return new SelectQuery(this.dataSource, this.querySegmentSpec, this.descending, this.dimFilter, this.granularity, this.dimensions, this.metrics, this.pagingSpec, this.context);
        }

        public SelectQueryBuilder copy(SelectQueryBuilder builder) {
            return new SelectQueryBuilder().dataSource(builder.dataSource).intervals(builder.querySegmentSpec).context(builder.context);
        }

        public SelectQueryBuilder dataSource(String ds) {
            this.dataSource = new TableDataSource(ds);
            return this;
        }

        public SelectQueryBuilder dataSource(DataSource ds) {
            this.dataSource = ds;
            return this;
        }

        public SelectQueryBuilder intervals(QuerySegmentSpec q) {
            this.querySegmentSpec = q;
            return this;
        }

        public SelectQueryBuilder intervals(String s) {
            this.querySegmentSpec = new LegacySegmentSpec(s);
            return this;
        }

        public SelectQueryBuilder intervals(List<Interval> l) {
            this.querySegmentSpec = new LegacySegmentSpec((Object)l);
            return this;
        }

        public SelectQueryBuilder descending(boolean descending) {
            this.descending = descending;
            return this;
        }

        public SelectQueryBuilder context(Map<String, Object> c) {
            this.context = c;
            return this;
        }

        public SelectQueryBuilder filters(String dimensionName, String value) {
            this.dimFilter = new SelectorDimFilter(dimensionName, value, null);
            return this;
        }

        public SelectQueryBuilder filters(String dimensionName, String value, String ... values) {
            this.dimFilter = new InDimFilter(dimensionName, Lists.asList((Object)value, (Object[])values), null);
            return this;
        }

        public SelectQueryBuilder filters(DimFilter f) {
            this.dimFilter = f;
            return this;
        }

        public SelectQueryBuilder granularity(String g) {
            this.granularity = QueryGranularity.fromString(g);
            return this;
        }

        public SelectQueryBuilder granularity(QueryGranularity g) {
            this.granularity = g;
            return this;
        }

        public SelectQueryBuilder dimensionSpecs(List<DimensionSpec> d) {
            this.dimensions = d;
            return this;
        }

        public SelectQueryBuilder dimensions(List<String> d) {
            this.dimensions = DefaultDimensionSpec.toSpec(d);
            return this;
        }

        public SelectQueryBuilder metrics(List<String> m) {
            this.metrics = m;
            return this;
        }

        public SelectQueryBuilder pagingSpec(PagingSpec p) {
            this.pagingSpec = p;
            return this;
        }
    }

    public static class SegmentMetadataQueryBuilder {
        private DataSource dataSource = null;
        private QuerySegmentSpec querySegmentSpec = null;
        private ColumnIncluderator toInclude = null;
        private EnumSet<SegmentMetadataQuery.AnalysisType> analysisTypes = null;
        private Boolean merge = null;
        private Boolean lenientAggregatorMerge = null;
        private Map<String, Object> context = null;

        public SegmentMetadataQuery build() {
            return new SegmentMetadataQuery(this.dataSource, this.querySegmentSpec, this.toInclude, this.merge, this.context, this.analysisTypes, false, this.lenientAggregatorMerge);
        }

        public SegmentMetadataQueryBuilder copy(SegmentMetadataQueryBuilder builder) {
            SegmentMetadataQuery.AnalysisType[] analysisTypesArray = this.analysisTypes != null ? this.analysisTypes.toArray(new SegmentMetadataQuery.AnalysisType[this.analysisTypes.size()]) : null;
            return new SegmentMetadataQueryBuilder().dataSource(builder.dataSource).intervals(builder.querySegmentSpec).toInclude(this.toInclude).analysisTypes(analysisTypesArray).merge(this.merge).lenientAggregatorMerge(this.lenientAggregatorMerge).context(builder.context);
        }

        public SegmentMetadataQueryBuilder dataSource(String ds) {
            this.dataSource = new TableDataSource(ds);
            return this;
        }

        public SegmentMetadataQueryBuilder dataSource(DataSource ds) {
            this.dataSource = ds;
            return this;
        }

        public SegmentMetadataQueryBuilder intervals(QuerySegmentSpec q) {
            this.querySegmentSpec = q;
            return this;
        }

        public SegmentMetadataQueryBuilder intervals(String s) {
            this.querySegmentSpec = new LegacySegmentSpec(s);
            return this;
        }

        public SegmentMetadataQueryBuilder intervals(List<Interval> l) {
            this.querySegmentSpec = new LegacySegmentSpec((Object)l);
            return this;
        }

        public SegmentMetadataQueryBuilder toInclude(ColumnIncluderator toInclude) {
            this.toInclude = toInclude;
            return this;
        }

        public SegmentMetadataQueryBuilder analysisTypes(SegmentMetadataQuery.AnalysisType ... analysisTypes) {
            this.analysisTypes = analysisTypes == null ? null : (analysisTypes.length == 0 ? EnumSet.noneOf(SegmentMetadataQuery.AnalysisType.class) : EnumSet.copyOf(Arrays.asList(analysisTypes)));
            return this;
        }

        public SegmentMetadataQueryBuilder merge(boolean merge) {
            this.merge = merge;
            return this;
        }

        public SegmentMetadataQueryBuilder lenientAggregatorMerge(boolean lenientAggregatorMerge) {
            this.lenientAggregatorMerge = lenientAggregatorMerge;
            return this;
        }

        public SegmentMetadataQueryBuilder context(Map<String, Object> c) {
            this.context = c;
            return this;
        }
    }

    public static class ResultBuilder<T> {
        private DateTime timestamp = new DateTime(0L);
        private Object value = null;

        public Result<T> build() {
            return new Result<Object>(this.timestamp, this.value);
        }

        public ResultBuilder copy(ResultBuilder builder) {
            return new ResultBuilder<T>().timestamp(builder.timestamp).value(builder.value);
        }

        public ResultBuilder<T> timestamp(DateTime t) {
            this.timestamp = t;
            return this;
        }

        public ResultBuilder<T> value(Object v) {
            this.value = v;
            return this;
        }
    }

    public static class TimeBoundaryQueryBuilder {
        private DataSource dataSource = null;
        private QuerySegmentSpec querySegmentSpec = null;
        private String bound = null;
        private Map<String, Object> context = null;

        public TimeBoundaryQuery build() {
            return new TimeBoundaryQuery(this.dataSource, this.querySegmentSpec, this.bound, this.context);
        }

        public TimeBoundaryQueryBuilder copy(TimeBoundaryQueryBuilder builder) {
            return new TimeBoundaryQueryBuilder().dataSource(builder.dataSource).intervals(builder.querySegmentSpec).bound(builder.bound).context(builder.context);
        }

        public TimeBoundaryQueryBuilder dataSource(String ds) {
            this.dataSource = new TableDataSource(ds);
            return this;
        }

        public TimeBoundaryQueryBuilder dataSource(DataSource ds) {
            this.dataSource = ds;
            return this;
        }

        public TimeBoundaryQueryBuilder intervals(QuerySegmentSpec q) {
            this.querySegmentSpec = q;
            return this;
        }

        public TimeBoundaryQueryBuilder intervals(String s) {
            this.querySegmentSpec = new LegacySegmentSpec(s);
            return this;
        }

        public TimeBoundaryQueryBuilder intervals(List<Interval> l) {
            this.querySegmentSpec = new LegacySegmentSpec((Object)l);
            return this;
        }

        public TimeBoundaryQueryBuilder bound(String b) {
            this.bound = b;
            return this;
        }

        public TimeBoundaryQueryBuilder context(Map<String, Object> c) {
            this.context = c;
            return this;
        }
    }

    public static class SearchQueryBuilder {
        private DataSource dataSource = null;
        private DimFilter dimFilter = null;
        private QueryGranularity granularity = QueryGranularities.ALL;
        private int limit = 0;
        private QuerySegmentSpec querySegmentSpec = null;
        private List<DimensionSpec> dimensions = null;
        private SearchQuerySpec querySpec = null;
        private SearchSortSpec sortSpec;
        private Map<String, Object> context = null;

        public SearchQuery build() {
            return new SearchQuery(this.dataSource, this.dimFilter, this.granularity, this.limit, this.querySegmentSpec, this.dimensions, this.querySpec, this.sortSpec, this.context);
        }

        public SearchQueryBuilder copy(SearchQuery query) {
            return new SearchQueryBuilder().dataSource(query.getDataSource()).intervals(query.getQuerySegmentSpec()).filters(query.getDimensionsFilter()).granularity(query.getGranularity()).limit(query.getLimit()).dimensions(query.getDimensions()).query(query.getQuery()).context(query.getContext());
        }

        public SearchQueryBuilder copy(SearchQueryBuilder builder) {
            return new SearchQueryBuilder().dataSource(builder.dataSource).intervals(builder.querySegmentSpec).filters(builder.dimFilter).granularity(builder.granularity).limit(builder.limit).dimensions(builder.dimensions).query(builder.querySpec).context(builder.context);
        }

        public SearchQueryBuilder dataSource(String d) {
            this.dataSource = new TableDataSource(d);
            return this;
        }

        public SearchQueryBuilder dataSource(DataSource d) {
            this.dataSource = d;
            return this;
        }

        public SearchQueryBuilder filters(String dimensionName, String value) {
            this.dimFilter = new SelectorDimFilter(dimensionName, value, null);
            return this;
        }

        public SearchQueryBuilder filters(String dimensionName, String value, String ... values) {
            this.dimFilter = new InDimFilter(dimensionName, Lists.asList((Object)value, (Object[])values), null);
            return this;
        }

        public SearchQueryBuilder filters(DimFilter f) {
            this.dimFilter = f;
            return this;
        }

        public SearchQueryBuilder granularity(String g) {
            this.granularity = QueryGranularity.fromString(g);
            return this;
        }

        public SearchQueryBuilder granularity(QueryGranularity g) {
            this.granularity = g;
            return this;
        }

        public SearchQueryBuilder limit(int l) {
            this.limit = l;
            return this;
        }

        public SearchQueryBuilder intervals(QuerySegmentSpec q) {
            this.querySegmentSpec = q;
            return this;
        }

        public SearchQueryBuilder intervals(String s) {
            this.querySegmentSpec = new LegacySegmentSpec(s);
            return this;
        }

        public SearchQueryBuilder intervals(List<Interval> l) {
            this.querySegmentSpec = new LegacySegmentSpec((Object)l);
            return this;
        }

        public SearchQueryBuilder dimensions(String d) {
            this.dimensions = ImmutableList.of((Object)DIMENSION_IDENTITY.apply((Object)d));
            return this;
        }

        public SearchQueryBuilder dimensions(Iterable<String> d) {
            this.dimensions = ImmutableList.copyOf((Iterable)Iterables.transform(d, DIMENSION_IDENTITY));
            return this;
        }

        public SearchQueryBuilder dimensions(DimensionSpec d) {
            this.dimensions = Lists.newArrayList((Object[])new DimensionSpec[]{d});
            return this;
        }

        public SearchQueryBuilder dimensions(List<DimensionSpec> d) {
            this.dimensions = d;
            return this;
        }

        public SearchQueryBuilder query(SearchQuerySpec s) {
            this.querySpec = s;
            return this;
        }

        public SearchQueryBuilder query(String q) {
            Preconditions.checkNotNull((Object)q, (Object)"no value");
            this.querySpec = new InsensitiveContainsSearchQuerySpec(q);
            return this;
        }

        public SearchQueryBuilder query(Map<String, Object> q) {
            String value = Preconditions.checkNotNull((Object)q.get("value"), (Object)"no value").toString();
            this.querySpec = new InsensitiveContainsSearchQuerySpec(value);
            return this;
        }

        public SearchQueryBuilder query(String q, boolean caseSensitive) {
            Preconditions.checkNotNull((Object)q, (Object)"no value");
            this.querySpec = new ContainsSearchQuerySpec(q, caseSensitive);
            return this;
        }

        public SearchQueryBuilder query(Map<String, Object> q, boolean caseSensitive) {
            String value = Preconditions.checkNotNull((Object)q.get("value"), (Object)"no value").toString();
            this.querySpec = new ContainsSearchQuerySpec(value, caseSensitive);
            return this;
        }

        public SearchQueryBuilder fragments(List<String> q) {
            return this.fragments(q, false);
        }

        public SearchQueryBuilder sortSpec(SearchSortSpec sortSpec) {
            this.sortSpec = sortSpec;
            return this;
        }

        public SearchQueryBuilder fragments(List<String> q, boolean caseSensitive) {
            Preconditions.checkNotNull(q, (Object)"no value");
            this.querySpec = new FragmentSearchQuerySpec(q, caseSensitive);
            return this;
        }

        public SearchQueryBuilder context(Map<String, Object> c) {
            this.context = c;
            return this;
        }
    }

    public static class TimeseriesQueryBuilder {
        private DataSource dataSource = null;
        private QuerySegmentSpec querySegmentSpec = null;
        private DimFilter dimFilter = null;
        private QueryGranularity granularity = QueryGranularities.ALL;
        private List<AggregatorFactory> aggregatorSpecs = Lists.newArrayList();
        private List<PostAggregator> postAggregatorSpecs = Lists.newArrayList();
        private Map<String, Object> context = null;
        private boolean descending;

        private TimeseriesQueryBuilder() {
        }

        public TimeseriesQuery build() {
            return new TimeseriesQuery(this.dataSource, this.querySegmentSpec, this.descending, this.dimFilter, this.granularity, this.aggregatorSpecs, this.postAggregatorSpecs, this.context);
        }

        public TimeseriesQueryBuilder copy(TimeseriesQuery query) {
            return new TimeseriesQueryBuilder().dataSource(query.getDataSource()).intervals(query.getIntervals()).filters(query.getDimensionsFilter()).descending(query.isDescending()).granularity(query.getGranularity()).aggregators(query.getAggregatorSpecs()).postAggregators(query.getPostAggregatorSpecs()).context(query.getContext());
        }

        public TimeseriesQueryBuilder copy(TimeseriesQueryBuilder builder) {
            return new TimeseriesQueryBuilder().dataSource(builder.dataSource).intervals(builder.querySegmentSpec).filters(builder.dimFilter).descending(builder.descending).granularity(builder.granularity).aggregators(builder.aggregatorSpecs).postAggregators(builder.postAggregatorSpecs).context(builder.context);
        }

        public DataSource getDataSource() {
            return this.dataSource;
        }

        public QuerySegmentSpec getQuerySegmentSpec() {
            return this.querySegmentSpec;
        }

        public DimFilter getDimFilter() {
            return this.dimFilter;
        }

        public boolean isDescending() {
            return this.descending;
        }

        public QueryGranularity getGranularity() {
            return this.granularity;
        }

        public List<AggregatorFactory> getAggregatorSpecs() {
            return this.aggregatorSpecs;
        }

        public List<PostAggregator> getPostAggregatorSpecs() {
            return this.postAggregatorSpecs;
        }

        public Map<String, Object> getContext() {
            return this.context;
        }

        public TimeseriesQueryBuilder dataSource(String ds) {
            this.dataSource = new TableDataSource(ds);
            return this;
        }

        public TimeseriesQueryBuilder dataSource(DataSource ds) {
            this.dataSource = ds;
            return this;
        }

        public TimeseriesQueryBuilder intervals(QuerySegmentSpec q) {
            this.querySegmentSpec = q;
            return this;
        }

        public TimeseriesQueryBuilder intervals(String s) {
            this.querySegmentSpec = new LegacySegmentSpec(s);
            return this;
        }

        public TimeseriesQueryBuilder intervals(List<Interval> l) {
            this.querySegmentSpec = new LegacySegmentSpec((Object)l);
            return this;
        }

        public TimeseriesQueryBuilder filters(String dimensionName, String value) {
            this.dimFilter = new SelectorDimFilter(dimensionName, value, null);
            return this;
        }

        public TimeseriesQueryBuilder filters(String dimensionName, String value, String ... values) {
            this.dimFilter = new InDimFilter(dimensionName, Lists.asList((Object)value, (Object[])values), null);
            return this;
        }

        public TimeseriesQueryBuilder filters(DimFilter f) {
            this.dimFilter = f;
            return this;
        }

        public TimeseriesQueryBuilder descending(boolean d) {
            this.descending = d;
            return this;
        }

        public TimeseriesQueryBuilder granularity(String g) {
            this.granularity = QueryGranularity.fromString(g);
            return this;
        }

        public TimeseriesQueryBuilder granularity(QueryGranularity g) {
            this.granularity = g;
            return this;
        }

        public TimeseriesQueryBuilder aggregators(List<AggregatorFactory> a) {
            this.aggregatorSpecs = a;
            return this;
        }

        public TimeseriesQueryBuilder postAggregators(List<PostAggregator> p) {
            this.postAggregatorSpecs = p;
            return this;
        }

        public TimeseriesQueryBuilder context(Map<String, Object> c) {
            this.context = c;
            return this;
        }
    }

    public static class NoopDimFilterBuilder {
        public NoopDimFilter build() {
            return new NoopDimFilter();
        }
    }

    public static class SelectorDimFilterBuilder {
        private String dimension = "";
        private String value = "";

        public SelectorDimFilter build() {
            return new SelectorDimFilter(this.dimension, this.value, null);
        }

        public SelectorDimFilterBuilder copy(SelectorDimFilterBuilder builder) {
            return new SelectorDimFilterBuilder().dimension(builder.dimension).value(builder.value);
        }

        public SelectorDimFilterBuilder dimension(String d) {
            this.dimension = d;
            return this;
        }

        public SelectorDimFilterBuilder value(String v) {
            this.value = v;
            return this;
        }
    }

    public static class NotDimFilterBuilder {
        private DimFilter field = null;

        public NotDimFilter build() {
            return new NotDimFilter(this.field);
        }

        public NotDimFilterBuilder copy(NotDimFilterBuilder builder) {
            return new NotDimFilterBuilder().field(builder.field);
        }

        public NotDimFilterBuilder field(DimFilter f) {
            this.field = f;
            return this;
        }
    }

    public static class OrDimFilterBuilder {
        private List<DimFilter> fields = Lists.newArrayList();

        public OrDimFilter build() {
            return new OrDimFilter(this.fields);
        }

        public OrDimFilterBuilder copy(OrDimFilterBuilder builder) {
            return new OrDimFilterBuilder().fields(builder.fields);
        }

        public OrDimFilterBuilder fields(String dimensionName, String value, String ... values) {
            this.fields = Lists.newArrayList((Object[])new DimFilter[]{new SelectorDimFilter(dimensionName, value, null)});
            for (String val : values) {
                this.fields.add(new SelectorDimFilter(dimensionName, val, null));
            }
            return this;
        }

        public OrDimFilterBuilder fields(List<DimFilter> f) {
            this.fields.addAll(f);
            return this;
        }
    }

    public static class AndDimFilterBuilder {
        private List<DimFilter> fields = Lists.newArrayList();

        public AndDimFilter build() {
            return new AndDimFilter(this.fields);
        }

        public AndDimFilterBuilder copy(AndDimFilterBuilder builder) {
            return new AndDimFilterBuilder().fields(builder.fields);
        }

        public AndDimFilterBuilder fields(List<DimFilter> f) {
            this.fields.addAll(f);
            return this;
        }
    }
}

