/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.metamx.common.guava.ResourceClosingSequence;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import com.metamx.common.logger.Logger;
import io.druid.granularity.QueryGranularity;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.Result;
import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.filter.Filter;
import io.druid.segment.Cursor;
import io.druid.segment.StorageAdapter;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import org.joda.time.Interval;

public class QueryRunnerHelper {
    private static final Logger log = new Logger(QueryRunnerHelper.class);

    public static Aggregator[] makeAggregators(Cursor cursor, List<AggregatorFactory> aggregatorSpecs) {
        Aggregator[] aggregators = new Aggregator[aggregatorSpecs.size()];
        int aggregatorIndex = 0;
        for (AggregatorFactory spec : aggregatorSpecs) {
            aggregators[aggregatorIndex] = spec.factorize(cursor);
            ++aggregatorIndex;
        }
        return aggregators;
    }

    public static <T> Sequence<Result<T>> makeCursorBasedQuery(final StorageAdapter adapter, List<Interval> queryIntervals, Filter filter, boolean descending, QueryGranularity granularity, final Function<Cursor, Result<T>> mapFn) {
        Preconditions.checkArgument((queryIntervals.size() == 1 ? 1 : 0) != 0, (String)"Can only handle a single interval, got[%s]", (Object[])new Object[]{queryIntervals});
        return Sequences.filter((Sequence)Sequences.map(adapter.makeCursors(filter, queryIntervals.get(0), granularity, descending), (Function)new Function<Cursor, Result<T>>(){

            public Result<T> apply(Cursor input) {
                log.debug("Running over cursor[%s]", new Object[]{adapter.getInterval(), input.getTime()});
                return (Result)mapFn.apply((Object)input);
            }
        }), (Predicate)Predicates.notNull());
    }

    public static <T> QueryRunner<T> makeClosingQueryRunner(final QueryRunner<T> runner, final Closeable closeable) {
        return new QueryRunner<T>(){

            @Override
            public Sequence<T> run(Query<T> query, Map<String, Object> responseContext) {
                return new ResourceClosingSequence(runner.run(query, responseContext), closeable);
            }
        };
    }
}

