/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.aggregation.hyperloglog;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Ordering;
import com.metamx.common.IAE;
import com.metamx.common.StringUtils;
import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.AggregatorFactoryNotMergeableException;
import io.druid.query.aggregation.Aggregators;
import io.druid.query.aggregation.BufferAggregator;
import io.druid.query.aggregation.hyperloglog.HyperLogLogCollector;
import io.druid.query.aggregation.hyperloglog.HyperUniquesAggregator;
import io.druid.query.aggregation.hyperloglog.HyperUniquesBufferAggregator;
import io.druid.segment.ColumnSelectorFactory;
import io.druid.segment.ObjectColumnSelector;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.codec.binary.Base64;

public class HyperUniquesAggregatorFactory
extends AggregatorFactory {
    private static final byte CACHE_TYPE_ID = 5;
    private final String name;
    private final String fieldName;

    public static Object estimateCardinality(Object object) {
        if (object == null) {
            return 0;
        }
        return ((HyperLogLogCollector)object).estimateCardinality();
    }

    @JsonCreator
    public HyperUniquesAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName) {
        this.name = name;
        this.fieldName = fieldName;
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        ObjectColumnSelector selector = metricFactory.makeObjectColumnSelector(this.fieldName);
        if (selector == null) {
            return Aggregators.noopAggregator();
        }
        Class classOfObject = selector.classOfObject();
        if (classOfObject.equals(Object.class) || HyperLogLogCollector.class.isAssignableFrom(classOfObject)) {
            return new HyperUniquesAggregator(this.name, selector);
        }
        throw new IAE("Incompatible type for metric[%s], expected a HyperUnique, got a %s", new Object[]{this.fieldName, classOfObject});
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        ObjectColumnSelector selector = metricFactory.makeObjectColumnSelector(this.fieldName);
        if (selector == null) {
            return Aggregators.noopBufferAggregator();
        }
        Class classOfObject = selector.classOfObject();
        if (classOfObject.equals(Object.class) || HyperLogLogCollector.class.isAssignableFrom(classOfObject)) {
            return new HyperUniquesBufferAggregator(selector);
        }
        throw new IAE("Incompatible type for metric[%s], expected a HyperUnique, got a %s", new Object[]{this.fieldName, classOfObject});
    }

    @Override
    public Comparator getComparator() {
        return Ordering.natural().nullsFirst();
    }

    @Override
    public Object combine(Object lhs, Object rhs) {
        if (rhs == null) {
            return lhs;
        }
        if (lhs == null) {
            return rhs;
        }
        return ((HyperLogLogCollector)lhs).fold((HyperLogLogCollector)rhs);
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new HyperUniquesAggregatorFactory(this.name, this.name);
    }

    @Override
    public AggregatorFactory getMergingFactory(AggregatorFactory other) throws AggregatorFactoryNotMergeableException {
        if (other.getName().equals(this.getName()) && this.getClass() == other.getClass()) {
            return this.getCombiningFactory();
        }
        throw new AggregatorFactoryNotMergeableException(this, other);
    }

    @Override
    public List<AggregatorFactory> getRequiredColumns() {
        return Arrays.asList(new HyperUniquesAggregatorFactory(this.fieldName, this.fieldName));
    }

    @Override
    public Object deserialize(Object object) {
        if (object instanceof byte[]) {
            return HyperLogLogCollector.makeCollector(ByteBuffer.wrap((byte[])object));
        }
        if (object instanceof ByteBuffer) {
            return HyperLogLogCollector.makeCollector((ByteBuffer)object);
        }
        if (object instanceof String) {
            return HyperLogLogCollector.makeCollector(ByteBuffer.wrap(Base64.decodeBase64((byte[])StringUtils.toUtf8((String)((String)object)))));
        }
        return object;
    }

    @Override
    public Object finalizeComputation(Object object) {
        return HyperUniquesAggregatorFactory.estimateCardinality(object);
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> requiredFields() {
        return Arrays.asList(this.fieldName);
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] fieldNameBytes = StringUtils.toUtf8((String)this.fieldName);
        return ByteBuffer.allocate(1 + fieldNameBytes.length).put((byte)5).put(fieldNameBytes).array();
    }

    @Override
    public String getTypeName() {
        return "hyperUnique";
    }

    @Override
    public int getMaxIntermediateSize() {
        return HyperLogLogCollector.getLatestNumBytesForDenseStorage();
    }

    @Override
    public Object getAggregatorStartValue() {
        return HyperLogLogCollector.makeLatestCollector();
    }

    public String toString() {
        return "HyperUniquesAggregatorFactory{name='" + this.name + '\'' + ", fieldName='" + this.fieldName + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HyperUniquesAggregatorFactory that = (HyperUniquesAggregatorFactory)o;
        if (!this.fieldName.equals(that.fieldName)) {
            return false;
        }
        return this.name.equals(that.name);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.fieldName.hashCode();
        return result;
    }
}

