/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.extraction;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.druid.query.extraction.DimExtractionFn;
import io.druid.query.extraction.ExtractionFn;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;

public class SubstringDimExtractionFn
extends DimExtractionFn {
    private static final byte CACHE_TYPE_ID = 8;
    private final int index;
    private final int end;

    @JsonCreator
    public SubstringDimExtractionFn(@JsonProperty(value="index") int index, @Nullable @JsonProperty(value="length") Integer length) {
        Preconditions.checkArgument((length == null || length > 0 ? 1 : 0) != 0, (Object)"length must be strictly positive");
        this.index = index;
        this.end = length != null ? index + length : -1;
    }

    @Override
    public byte[] getCacheKey() {
        return ByteBuffer.allocate(9).put((byte)8).putInt(this.index).putInt(this.end).array();
    }

    @Override
    public String apply(String dimValue) {
        if (Strings.isNullOrEmpty((String)dimValue)) {
            return null;
        }
        int len = dimValue.length();
        if (this.index < len) {
            if (this.end > 0) {
                return dimValue.substring(this.index, Math.min(this.end, len));
            }
            return dimValue.substring(this.index);
        }
        return null;
    }

    @JsonProperty
    public int getIndex() {
        return this.index;
    }

    @JsonProperty
    public Integer getLength() {
        return this.end > -1 ? Integer.valueOf(this.end - this.index) : null;
    }

    @Override
    public boolean preservesOrdering() {
        return this.index == 0;
    }

    @Override
    public ExtractionFn.ExtractionType getExtractionType() {
        return ExtractionFn.ExtractionType.MANY_TO_ONE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubstringDimExtractionFn that = (SubstringDimExtractionFn)o;
        if (this.index != that.index) {
            return false;
        }
        return this.end == that.end;
    }

    public int hashCode() {
        int result = this.index;
        result = 31 * result + this.end;
        return result;
    }
}

