/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.filter;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.metamx.common.ISE;
import com.metamx.common.StringUtils;
import io.druid.js.JavaScriptConfig;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.Filter;
import io.druid.segment.filter.JavaScriptFilter;
import java.nio.ByteBuffer;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JavaScriptDimFilter
implements DimFilter {
    private final String dimension;
    private final String function;
    private final ExtractionFn extractionFn;
    private final JavaScriptConfig config;
    private final JavaScriptPredicate predicate;

    @JsonCreator
    public JavaScriptDimFilter(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="function") String function, @JsonProperty(value="extractionFn") ExtractionFn extractionFn, @JacksonInject JavaScriptConfig config) {
        Preconditions.checkArgument((dimension != null ? 1 : 0) != 0, (Object)"dimension must not be null");
        Preconditions.checkArgument((function != null ? 1 : 0) != 0, (Object)"function must not be null");
        this.dimension = dimension;
        this.function = function;
        this.extractionFn = extractionFn;
        this.config = config;
        this.predicate = config.isDisabled() ? null : new JavaScriptPredicate(function, extractionFn);
    }

    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @JsonProperty
    public String getFunction() {
        return this.function;
    }

    @JsonProperty
    public ExtractionFn getExtractionFn() {
        return this.extractionFn;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] dimensionBytes = StringUtils.toUtf8((String)this.dimension);
        byte[] functionBytes = StringUtils.toUtf8((String)this.function);
        byte[] extractionFnBytes = this.extractionFn == null ? new byte[]{} : this.extractionFn.getCacheKey();
        return ByteBuffer.allocate(3 + dimensionBytes.length + functionBytes.length + extractionFnBytes.length).put((byte)7).put(dimensionBytes).put((byte)-1).put(functionBytes).put((byte)-1).put(extractionFnBytes).array();
    }

    @Override
    public DimFilter optimize() {
        return this;
    }

    @Override
    public Filter toFilter() {
        if (this.config.isDisabled()) {
            throw new ISE("JavaScript is disabled", new Object[0]);
        }
        return new JavaScriptFilter(this.dimension, this.predicate);
    }

    public String toString() {
        return "JavaScriptDimFilter{dimension='" + this.dimension + '\'' + ", function='" + this.function + '\'' + ", extractionFn='" + this.extractionFn + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaScriptDimFilter)) {
            return false;
        }
        JavaScriptDimFilter that = (JavaScriptDimFilter)o;
        if (!this.dimension.equals(that.dimension)) {
            return false;
        }
        if (!this.function.equals(that.function)) {
            return false;
        }
        return this.extractionFn != null ? this.extractionFn.equals(that.extractionFn) : that.extractionFn == null;
    }

    public int hashCode() {
        int result = this.dimension.hashCode();
        result = 31 * result + this.function.hashCode();
        result = 31 * result + (this.extractionFn != null ? this.extractionFn.hashCode() : 0);
        return result;
    }

    public static class JavaScriptPredicate
    implements Predicate<String> {
        final ScriptableObject scope;
        final Function fnApply;
        final String script;
        final ExtractionFn extractionFn;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JavaScriptPredicate(String script, ExtractionFn extractionFn) {
            Preconditions.checkNotNull((Object)script, (Object)"script must not be null");
            this.script = script;
            this.extractionFn = extractionFn;
            Context cx = Context.enter();
            try {
                cx.setOptimizationLevel(9);
                this.scope = cx.initStandardObjects();
                this.fnApply = cx.compileFunction((Scriptable)this.scope, script, "script", 1, null);
            }
            finally {
                Context.exit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean apply(String input) {
            Context cx = Context.enter();
            try {
                boolean bl = this.applyInContext(cx, input);
                return bl;
            }
            finally {
                Context.exit();
            }
        }

        public boolean applyInContext(Context cx, String input) {
            if (this.extractionFn != null) {
                input = this.extractionFn.apply(input);
            }
            return Context.toBoolean((Object)this.fnApply.call(cx, (Scriptable)this.scope, (Scriptable)this.scope, (Object[])new String[]{input}));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JavaScriptPredicate that = (JavaScriptPredicate)o;
            return this.script.equals(that.script);
        }

        public int hashCode() {
            return this.script.hashCode();
        }
    }
}

