/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.metamx.common.StringUtils;
import io.druid.query.extraction.ExtractionFn;
import io.druid.query.filter.DimFilter;
import io.druid.query.filter.Filter;
import io.druid.query.filter.InDimFilter;
import io.druid.segment.filter.DimensionPredicateFilter;
import io.druid.segment.filter.SelectorFilter;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;

public class SelectorDimFilter
implements DimFilter {
    private final String dimension;
    private final String value;
    private final ExtractionFn extractionFn;

    @JsonCreator
    public SelectorDimFilter(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="value") String value, @JsonProperty(value="extractionFn") ExtractionFn extractionFn) {
        Preconditions.checkArgument((dimension != null ? 1 : 0) != 0, (Object)"dimension must not be null");
        this.dimension = dimension;
        this.value = Strings.nullToEmpty((String)value);
        this.extractionFn = extractionFn;
    }

    @Override
    public byte[] getCacheKey() {
        byte[] dimensionBytes = StringUtils.toUtf8((String)this.dimension);
        byte[] valueBytes = this.value == null ? new byte[]{} : StringUtils.toUtf8((String)this.value);
        byte[] extractionFnBytes = this.extractionFn == null ? new byte[]{} : this.extractionFn.getCacheKey();
        return ByteBuffer.allocate(3 + dimensionBytes.length + valueBytes.length + extractionFnBytes.length).put((byte)0).put(dimensionBytes).put((byte)-1).put(valueBytes).put((byte)-1).put(extractionFnBytes).array();
    }

    @Override
    public DimFilter optimize() {
        return new InDimFilter(this.dimension, (List<String>)ImmutableList.of((Object)this.value), this.extractionFn).optimize();
    }

    @Override
    public Filter toFilter() {
        if (this.extractionFn == null) {
            return new SelectorFilter(this.dimension, this.value);
        }
        final String valueOrNull = Strings.emptyToNull((String)this.value);
        Predicate<String> predicate = new Predicate<String>(){

            public boolean apply(String input) {
                return Objects.equals(valueOrNull, input);
            }
        };
        return new DimensionPredicateFilter(this.dimension, predicate, this.extractionFn);
    }

    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @JsonProperty
    public String getValue() {
        return this.value;
    }

    @JsonProperty
    public ExtractionFn getExtractionFn() {
        return this.extractionFn;
    }

    public String toString() {
        if (this.extractionFn != null) {
            return String.format("%s(%s) = %s", this.extractionFn, this.dimension, this.value);
        }
        return String.format("%s = %s", this.dimension, this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SelectorDimFilter that = (SelectorDimFilter)o;
        if (!this.dimension.equals(that.dimension)) {
            return false;
        }
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        return this.extractionFn != null ? this.extractionFn.equals(that.extractionFn) : that.extractionFn == null;
    }

    public int hashCode() {
        int result = this.dimension.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.extractionFn != null ? this.extractionFn.hashCode() : 0);
        return result;
    }
}

