/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.select;

import com.metamx.common.guava.nary.BinaryFn;
import io.druid.granularity.AllGranularity;
import io.druid.granularity.QueryGranularity;
import io.druid.query.Result;
import io.druid.query.select.EventHolder;
import io.druid.query.select.PagingSpec;
import io.druid.query.select.SelectResultValue;
import io.druid.query.select.SelectResultValueBuilder;
import java.util.List;
import org.joda.time.DateTime;

public class SelectBinaryFn
implements BinaryFn<Result<SelectResultValue>, Result<SelectResultValue>, Result<SelectResultValue>> {
    private final QueryGranularity gran;
    private final PagingSpec pagingSpec;
    private final boolean descending;

    public SelectBinaryFn(QueryGranularity granularity, PagingSpec pagingSpec, boolean descending) {
        this.gran = granularity;
        this.pagingSpec = pagingSpec;
        this.descending = descending;
    }

    public Result<SelectResultValue> apply(Result<SelectResultValue> arg1, Result<SelectResultValue> arg2) {
        if (arg1 == null) {
            return arg2;
        }
        if (arg2 == null) {
            return arg1;
        }
        List<EventHolder> arg1Val = arg1.getValue().getEvents();
        List<EventHolder> arg2Val = arg2.getValue().getEvents();
        if (arg1Val == null || arg1Val.isEmpty()) {
            return arg2;
        }
        if (arg2Val == null || arg2Val.isEmpty()) {
            return arg1;
        }
        DateTime timestamp = this.gran instanceof AllGranularity ? arg1.getTimestamp() : this.gran.toDateTime(this.gran.truncate(arg1.getTimestamp().getMillis()));
        SelectResultValueBuilder.MergeBuilder builder = new SelectResultValueBuilder.MergeBuilder(timestamp, this.pagingSpec, this.descending);
        for (EventHolder event : arg1Val) {
            builder.addEntry(event);
        }
        for (EventHolder event : arg2Val) {
            builder.addEntry(event);
        }
        return builder.build();
    }
}

