/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.metamx.collections.bitmap.BitmapFactory;
import com.metamx.collections.bitmap.ImmutableBitmap;
import com.metamx.collections.bitmap.MutableBitmap;
import com.metamx.collections.bitmap.WrappedImmutableRoaringBitmap;
import io.druid.segment.data.Offset;
import io.druid.segment.data.RoaringBitmapSerdeFactory;
import org.roaringbitmap.IntIterator;

public class BitmapOffset
implements Offset {
    private static final int INVALID_VALUE = -1;
    private final IntIterator itr;
    private final BitmapFactory bitmapFactory;
    private final ImmutableBitmap bitmapIndex;
    private final boolean descending;
    private volatile int val;

    public BitmapOffset(BitmapFactory bitmapFactory, ImmutableBitmap bitmapIndex, boolean descending) {
        this.bitmapFactory = bitmapFactory;
        this.bitmapIndex = bitmapIndex;
        this.descending = descending;
        this.itr = this.newIterator();
        this.increment();
    }

    private IntIterator newIterator() {
        if (!this.descending) {
            return this.bitmapIndex.iterator();
        }
        ImmutableBitmap roaringBitmap = this.bitmapIndex;
        if (!(this.bitmapIndex instanceof WrappedImmutableRoaringBitmap)) {
            BitmapFactory factory = RoaringBitmapSerdeFactory.bitmapFactory;
            MutableBitmap bitmap = factory.makeEmptyMutableBitmap();
            IntIterator iterator = this.bitmapIndex.iterator();
            while (iterator.hasNext()) {
                bitmap.add(iterator.next());
            }
            roaringBitmap = factory.makeImmutableBitmap(bitmap);
        }
        return ((WrappedImmutableRoaringBitmap)roaringBitmap).getBitmap().getReverseIntIterator();
    }

    private BitmapOffset(BitmapOffset otherOffset) {
        this.bitmapFactory = otherOffset.bitmapFactory;
        this.bitmapIndex = otherOffset.bitmapIndex;
        this.descending = otherOffset.descending;
        this.itr = otherOffset.itr.clone();
        this.val = otherOffset.val;
    }

    @Override
    public void increment() {
        this.val = this.itr.hasNext() ? this.itr.next() : -1;
    }

    @Override
    public boolean withinBounds() {
        return this.val > -1;
    }

    @Override
    public Offset clone() {
        if (this.bitmapIndex == null || this.bitmapIndex.size() == 0) {
            return new BitmapOffset(this.bitmapFactory, this.bitmapFactory.makeEmptyImmutableBitmap(), this.descending);
        }
        return new BitmapOffset(this);
    }

    @Override
    public int getOffset() {
        return this.val;
    }
}

