/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.google.common.io.Files;
import com.google.common.io.OutputSupplier;
import io.druid.segment.IndexIO;
import io.druid.segment.MetricColumnSerializer;
import io.druid.segment.MetricHolder;
import io.druid.segment.data.CompressedFloatsSupplierSerializer;
import io.druid.segment.data.CompressedObjectStrategy;
import io.druid.segment.data.IOPeon;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public class FloatMetricColumnSerializer
implements MetricColumnSerializer {
    private final String metricName;
    private final IOPeon ioPeon;
    private final File outDir;
    private CompressedFloatsSupplierSerializer writer;

    public FloatMetricColumnSerializer(String metricName, File outDir, IOPeon ioPeon) {
        this.metricName = metricName;
        this.ioPeon = ioPeon;
        this.outDir = outDir;
    }

    @Override
    public void open() throws IOException {
        this.writer = CompressedFloatsSupplierSerializer.create(this.ioPeon, String.format("%s_little", this.metricName), IndexIO.BYTE_ORDER, CompressedObjectStrategy.DEFAULT_COMPRESSION_STRATEGY);
        this.writer.open();
    }

    @Override
    public void serialize(Object obj) throws IOException {
        float val = obj == null ? 0.0f : ((Number)obj).floatValue();
        this.writer.add(val);
    }

    @Override
    public void close() throws IOException {
        File outFile = IndexIO.makeMetricFile(this.outDir, this.metricName, IndexIO.BYTE_ORDER);
        outFile.delete();
        MetricHolder.writeFloatMetric((OutputSupplier<? extends OutputStream>)Files.newOutputStreamSupplier((File)outFile, (boolean)true), this.metricName, this.writer);
        IndexIO.checkFileSize(outFile);
        this.writer = null;
    }
}

