/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.PeekingIterator;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closer;
import com.google.common.io.Files;
import com.google.common.io.OutputSupplier;
import com.google.common.primitives.Ints;
import com.google.inject.Inject;
import com.metamx.collections.bitmap.BitmapFactory;
import com.metamx.collections.bitmap.ImmutableBitmap;
import com.metamx.collections.bitmap.MutableBitmap;
import com.metamx.collections.spatial.ImmutableRTree;
import com.metamx.collections.spatial.RTree;
import com.metamx.collections.spatial.split.LinearGutmanSplitStrategy;
import com.metamx.collections.spatial.split.SplitStrategy;
import com.metamx.common.IAE;
import com.metamx.common.ISE;
import com.metamx.common.Pair;
import com.metamx.common.guava.FunctionalIterable;
import com.metamx.common.guava.MergeIterable;
import com.metamx.common.guava.nary.BinaryFn;
import com.metamx.common.io.smoosh.Smoosh;
import com.metamx.common.logger.Logger;
import io.druid.collections.CombiningIterable;
import io.druid.common.guava.FileOutputSupplier;
import io.druid.common.guava.GuavaUtils;
import io.druid.common.utils.JodaUtils;
import io.druid.common.utils.SerializerUtils;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.segment.BaseProgressIndicator;
import io.druid.segment.FloatMetricColumnSerializer;
import io.druid.segment.IndexIO;
import io.druid.segment.IndexSpec;
import io.druid.segment.IndexableAdapter;
import io.druid.segment.LongMetricColumnSerializer;
import io.druid.segment.Metadata;
import io.druid.segment.MetricColumnSerializer;
import io.druid.segment.ProgressIndicator;
import io.druid.segment.QueryableIndex;
import io.druid.segment.QueryableIndexIndexableAdapter;
import io.druid.segment.Rowboat;
import io.druid.segment.column.ColumnCapabilities;
import io.druid.segment.column.ColumnCapabilitiesImpl;
import io.druid.segment.column.ValueType;
import io.druid.segment.data.BitmapSerdeFactory;
import io.druid.segment.data.ByteBufferWriter;
import io.druid.segment.data.CompressedLongsSupplierSerializer;
import io.druid.segment.data.CompressedObjectStrategy;
import io.druid.segment.data.GenericIndexed;
import io.druid.segment.data.GenericIndexedWriter;
import io.druid.segment.data.Indexed;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.data.IndexedIterable;
import io.druid.segment.data.IndexedRTree;
import io.druid.segment.data.ListIndexed;
import io.druid.segment.data.TmpFileIOPeon;
import io.druid.segment.data.VSizeIndexedWriter;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.incremental.IncrementalIndexAdapter;
import io.druid.segment.serde.ComplexMetricColumnSerializer;
import io.druid.segment.serde.ComplexMetricSerde;
import io.druid.segment.serde.ComplexMetrics;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class IndexMerger {
    private static final Logger log = new Logger(IndexMerger.class);
    protected static final ListIndexed EMPTY_STR_DIM_VAL = new ListIndexed<String>(Arrays.asList(""), String.class);
    protected static final SerializerUtils serializerUtils = new SerializerUtils();
    protected static final int INVALID_ROW = -1;
    protected static final Splitter SPLITTER = Splitter.on((String)",");
    protected final ObjectMapper mapper;
    protected final IndexIO indexIO;

    @Inject
    public IndexMerger(ObjectMapper mapper, IndexIO indexIO) {
        this.mapper = (ObjectMapper)Preconditions.checkNotNull((Object)mapper, (Object)"null ObjectMapper");
        this.indexIO = (IndexIO)Preconditions.checkNotNull((Object)indexIO, (Object)"null IndexIO");
    }

    public File persist(IncrementalIndex index, File outDir, IndexSpec indexSpec) throws IOException {
        return this.persist(index, index.getInterval(), outDir, indexSpec);
    }

    public File persist(IncrementalIndex index, Interval dataInterval, File outDir, IndexSpec indexSpec) throws IOException {
        return this.persist(index, dataInterval, outDir, indexSpec, new BaseProgressIndicator());
    }

    public File persist(IncrementalIndex index, Interval dataInterval, File outDir, IndexSpec indexSpec, ProgressIndicator progress) throws IOException {
        if (index.isEmpty()) {
            throw new IAE("Trying to persist an empty index!", new Object[0]);
        }
        long firstTimestamp = index.getMinTime().getMillis();
        long lastTimestamp = index.getMaxTime().getMillis();
        if (!dataInterval.contains(firstTimestamp) || !dataInterval.contains(lastTimestamp)) {
            throw new IAE("interval[%s] does not encapsulate the full range of timestamps[%s, %s]", new Object[]{dataInterval, new DateTime(firstTimestamp), new DateTime(lastTimestamp)});
        }
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        if (!outDir.isDirectory()) {
            throw new ISE("Can only persist to directories, [%s] wasn't a directory", new Object[]{outDir});
        }
        log.info("Starting persist for interval[%s], rows[%,d]", new Object[]{dataInterval, index.size()});
        return this.merge(Arrays.asList(new IncrementalIndexAdapter(dataInterval, index, indexSpec.getBitmapSerdeFactory().getBitmapFactory())), index.getMetricAggs(), outDir, indexSpec, progress);
    }

    public File mergeQueryableIndex(List<QueryableIndex> indexes, AggregatorFactory[] metricAggs, File outDir, IndexSpec indexSpec) throws IOException {
        return this.mergeQueryableIndex(indexes, metricAggs, outDir, indexSpec, new BaseProgressIndicator());
    }

    public File mergeQueryableIndex(List<QueryableIndex> indexes, AggregatorFactory[] metricAggs, File outDir, IndexSpec indexSpec, ProgressIndicator progress) throws IOException {
        ArrayList indexAdapteres = Lists.newArrayList((Iterable)Iterables.transform(indexes, (Function)new Function<QueryableIndex, IndexableAdapter>(){

            public IndexableAdapter apply(QueryableIndex input) {
                return new QueryableIndexIndexableAdapter(input);
            }
        }));
        return this.merge(indexAdapteres, metricAggs, outDir, indexSpec, progress);
    }

    public File merge(List<IndexableAdapter> indexes, AggregatorFactory[] metricAggs, File outDir, IndexSpec indexSpec) throws IOException {
        return this.merge(indexes, metricAggs, outDir, indexSpec, new BaseProgressIndicator());
    }

    private static List<String> getLexicographicMergedDimensions(List<IndexableAdapter> indexes) {
        return IndexMerger.mergeIndexed(Lists.transform(indexes, (Function)new Function<IndexableAdapter, Iterable<String>>(){

            public Iterable<String> apply(@Nullable IndexableAdapter input) {
                return input.getDimensionNames();
            }
        }));
    }

    private static List<String> getLongestSharedDimOrder(List<IndexableAdapter> indexes) {
        int maxSize = 0;
        Indexed<String> orderingCandidate = null;
        for (IndexableAdapter index : indexes) {
            int iterSize = index.getDimensionNames().size();
            if (iterSize <= maxSize) continue;
            maxSize = iterSize;
            orderingCandidate = index.getDimensionNames();
        }
        if (orderingCandidate == null) {
            return null;
        }
        for (IndexableAdapter index : indexes) {
            Iterator candidateIter = orderingCandidate.iterator();
            for (String matchDim : index.getDimensionNames()) {
                boolean matched = false;
                while (candidateIter.hasNext()) {
                    String nextDim = (String)candidateIter.next();
                    if (!matchDim.equals(nextDim)) continue;
                    matched = true;
                    break;
                }
                if (matched) continue;
                return null;
            }
        }
        return ImmutableList.copyOf(orderingCandidate);
    }

    public static List<String> getMergedDimensions(List<IndexableAdapter> indexes) {
        if (indexes.size() == 0) {
            return ImmutableList.of();
        }
        List<String> commonDimOrder = IndexMerger.getLongestSharedDimOrder(indexes);
        if (commonDimOrder == null) {
            log.warn("Indexes have incompatible dimension orders, using lexicographic order.", new Object[0]);
            return IndexMerger.getLexicographicMergedDimensions(indexes);
        }
        return commonDimOrder;
    }

    public File merge(List<IndexableAdapter> indexes, AggregatorFactory[] metricAggs, File outDir, IndexSpec indexSpec, ProgressIndicator progress) throws IOException {
        int i;
        FileUtils.deleteDirectory((File)outDir);
        if (!outDir.mkdirs()) {
            throw new ISE("Couldn't make outdir[%s].", new Object[]{outDir});
        }
        List<String> mergedDimensions = IndexMerger.getMergedDimensions(indexes);
        List mergedMetrics = Lists.transform(IndexMerger.mergeIndexed(Lists.newArrayList((Iterable)FunctionalIterable.create(indexes).transform((Function)new Function<IndexableAdapter, Iterable<String>>(){

            public Iterable<String> apply(@Nullable IndexableAdapter input) {
                return input.getMetricNames();
            }
        }))), (Function)new Function<String, String>(){

            public String apply(@Nullable String input) {
                return input;
            }
        });
        final AggregatorFactory[] sortedMetricAggs = new AggregatorFactory[mergedMetrics.size()];
        for (i = 0; i < metricAggs.length; ++i) {
            AggregatorFactory metricAgg = metricAggs[i];
            int metricIndex = mergedMetrics.indexOf(metricAgg.getName());
            if (metricIndex <= -1) continue;
            sortedMetricAggs[metricIndex] = metricAgg;
        }
        for (i = 0; i < sortedMetricAggs.length; ++i) {
            if (sortedMetricAggs[i] != null) continue;
            throw new IAE("Indices to merge contained metric[%s], but requested metrics did not", new Object[]{mergedMetrics.get(i)});
        }
        for (i = 0; i < mergedMetrics.size(); ++i) {
            if (sortedMetricAggs[i].getName().equals(mergedMetrics.get(i))) continue;
            throw new IAE("Metric mismatch, index[%d] [%s] != [%s]", new Object[]{i, sortedMetricAggs[i].getName(), mergedMetrics.get(i)});
        }
        Function<ArrayList<Iterable<Rowboat>>, Iterable<Rowboat>> rowMergerFn = new Function<ArrayList<Iterable<Rowboat>>, Iterable<Rowboat>>(){

            public Iterable<Rowboat> apply(@Nullable ArrayList<Iterable<Rowboat>> boats) {
                return CombiningIterable.create((Iterable)new MergeIterable((Comparator)Ordering.natural().nullsFirst(), boats), (Comparator)Ordering.natural().nullsFirst(), (BinaryFn)new RowboatMergeFunction(sortedMetricAggs));
            }
        };
        return this.makeIndexFiles(indexes, sortedMetricAggs, outDir, progress, mergedDimensions, mergedMetrics, rowMergerFn, indexSpec);
    }

    public File convert(File inDir, File outDir, IndexSpec indexSpec) throws IOException {
        return this.convert(inDir, outDir, indexSpec, new BaseProgressIndicator());
    }

    public File convert(File inDir, File outDir, IndexSpec indexSpec, ProgressIndicator progress) throws IOException {
        try (QueryableIndex index = this.indexIO.loadIndex(inDir);){
            QueryableIndexIndexableAdapter adapter = new QueryableIndexIndexableAdapter(index);
            File file = this.makeIndexFiles((List<IndexableAdapter>)ImmutableList.of((Object)adapter), null, outDir, progress, Lists.newArrayList(adapter.getDimensionNames()), Lists.newArrayList(adapter.getMetricNames()), new Function<ArrayList<Iterable<Rowboat>>, Iterable<Rowboat>>(){

                @Nullable
                public Iterable<Rowboat> apply(ArrayList<Iterable<Rowboat>> input) {
                    return input.get(0);
                }
            }, indexSpec);
            return file;
        }
    }

    public File append(List<IndexableAdapter> indexes, AggregatorFactory[] aggregators, File outDir, IndexSpec indexSpec) throws IOException {
        return this.append(indexes, aggregators, outDir, indexSpec, new BaseProgressIndicator());
    }

    public File append(List<IndexableAdapter> indexes, AggregatorFactory[] aggregators, File outDir, IndexSpec indexSpec, ProgressIndicator progress) throws IOException {
        FileUtils.deleteDirectory((File)outDir);
        if (!outDir.mkdirs()) {
            throw new ISE("Couldn't make outdir[%s].", new Object[]{outDir});
        }
        List<String> mergedDimensions = IndexMerger.getMergedDimensions(indexes);
        ArrayList<String> mergedMetrics = IndexMerger.mergeIndexed(Lists.transform(indexes, (Function)new Function<IndexableAdapter, Iterable<String>>(){

            public Iterable<String> apply(@Nullable IndexableAdapter input) {
                return Iterables.transform(input.getMetricNames(), (Function)new Function<String, String>(){

                    public String apply(@Nullable String input) {
                        return input;
                    }
                });
            }
        }));
        Function<ArrayList<Iterable<Rowboat>>, Iterable<Rowboat>> rowMergerFn = new Function<ArrayList<Iterable<Rowboat>>, Iterable<Rowboat>>(){

            public Iterable<Rowboat> apply(@Nullable ArrayList<Iterable<Rowboat>> boats) {
                return new MergeIterable((Comparator)Ordering.natural().nullsFirst(), boats);
            }
        };
        return this.makeIndexFiles(indexes, aggregators, outDir, progress, mergedDimensions, mergedMetrics, rowMergerFn, indexSpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected File makeIndexFiles(List<IndexableAdapter> indexes, AggregatorFactory[] metricAggs, File outDir, ProgressIndicator progress, List<String> mergedDimensions, List<String> mergedMetrics, Function<ArrayList<Iterable<Rowboat>>, Iterable<Rowboat>> rowMergerFn, IndexSpec indexSpec) throws IOException {
        List metadataList = Lists.transform(indexes, (Function)new Function<IndexableAdapter, Metadata>(){

            @Nullable
            public Metadata apply(IndexableAdapter input) {
                return input.getMetadata();
            }
        });
        Metadata segmentMetadata = null;
        if (metricAggs != null) {
            AggregatorFactory[] combiningMetricAggs = new AggregatorFactory[metricAggs.length];
            for (int i = 0; i < metricAggs.length; ++i) {
                combiningMetricAggs[i] = metricAggs[i].getCombiningFactory();
            }
            segmentMetadata = Metadata.merge(metadataList, combiningMetricAggs);
        } else {
            segmentMetadata = Metadata.merge(metadataList, null);
        }
        TreeMap valueTypes = Maps.newTreeMap((Comparator)Ordering.natural().nullsFirst());
        TreeMap metricTypeNames = Maps.newTreeMap((Comparator)Ordering.natural().nullsFirst());
        HashMap columnCapabilities = Maps.newHashMap();
        for (IndexableAdapter adapter : indexes) {
            ColumnCapabilities capabilities;
            ColumnCapabilitiesImpl mergedCapabilities;
            for (String dimension : adapter.getDimensionNames()) {
                mergedCapabilities = (ColumnCapabilitiesImpl)columnCapabilities.get(dimension);
                capabilities = adapter.getCapabilities(dimension);
                if (mergedCapabilities == null) {
                    mergedCapabilities = new ColumnCapabilitiesImpl();
                    mergedCapabilities.setType(ValueType.STRING);
                }
                columnCapabilities.put(dimension, mergedCapabilities.merge(capabilities));
            }
            for (String metric : adapter.getMetricNames()) {
                mergedCapabilities = (ColumnCapabilitiesImpl)columnCapabilities.get(metric);
                capabilities = adapter.getCapabilities(metric);
                if (mergedCapabilities == null) {
                    mergedCapabilities = new ColumnCapabilitiesImpl();
                }
                columnCapabilities.put(metric, mergedCapabilities.merge(capabilities));
                valueTypes.put(metric, capabilities.getType());
                metricTypeNames.put(metric, adapter.getMetricType(metric));
            }
        }
        Closer closer = Closer.create();
        final File v8OutDir = new File(outDir, "v8-tmp");
        v8OutDir.mkdirs();
        closer.register(new Closeable(){

            @Override
            public void close() throws IOException {
                FileUtils.deleteDirectory((File)v8OutDir);
            }
        });
        final TmpFileIOPeon ioPeon = new TmpFileIOPeon();
        closer.register(new Closeable(){

            @Override
            public void close() throws IOException {
                ioPeon.cleanup();
            }
        });
        try {
            Interval dataInterval;
            progress.progress();
            long startTime = System.currentTimeMillis();
            File indexFile = new File(v8OutDir, "index.drd");
            try (FileOutputStream fileOutputStream = new FileOutputStream(indexFile);
                 FileChannel channel = fileOutputStream.getChannel();){
                channel.write(ByteBuffer.wrap(new byte[]{8}));
                GenericIndexed.fromIterable(mergedDimensions, GenericIndexed.STRING_STRATEGY).writeToChannel(channel);
                GenericIndexed.fromIterable(mergedMetrics, GenericIndexed.STRING_STRATEGY).writeToChannel(channel);
                DateTime minTime = new DateTime(0x3FFFFFFFFFFFFFFFL);
                DateTime maxTime = new DateTime(-4611686018427387904L);
                for (IndexableAdapter index : indexes) {
                    minTime = JodaUtils.minDateTime((DateTime[])new DateTime[]{minTime, index.getDataInterval().getStart()});
                    maxTime = JodaUtils.maxDateTime((DateTime[])new DateTime[]{maxTime, index.getDataInterval().getEnd()});
                }
                dataInterval = new Interval((ReadableInstant)minTime, (ReadableInstant)maxTime);
                serializerUtils.writeString((WritableByteChannel)channel, String.format("%s/%s", minTime, maxTime));
                serializerUtils.writeString((WritableByteChannel)channel, this.mapper.writeValueAsString((Object)indexSpec.getBitmapSerdeFactory()));
            }
            IndexIO.checkFileSize(indexFile);
            log.info("outDir[%s] completed index.drd in %,d millis.", new Object[]{v8OutDir, System.currentTimeMillis() - startTime});
            progress.progress();
            startTime = System.currentTimeMillis();
            ArrayList dimOuts = Lists.newArrayListWithCapacity((int)mergedDimensions.size());
            HashMap dimensionCardinalities = Maps.newHashMap();
            ArrayList dimConversions = Lists.newArrayListWithCapacity((int)indexes.size());
            ArrayList convertMissingDimsFlags = Lists.newArrayListWithCapacity((int)mergedDimensions.size());
            ArrayList nullRowsList = Lists.newArrayListWithCapacity((int)mergedDimensions.size());
            ArrayList dimHasNullFlags = Lists.newArrayListWithCapacity((int)mergedDimensions.size());
            for (int i = 0; i < indexes.size(); ++i) {
                dimConversions.add(Maps.newHashMap());
            }
            for (String dimension : mergedDimensions) {
                nullRowsList.add(indexSpec.getBitmapSerdeFactory().getBitmapFactory().makeEmptyMutableBitmap());
                GenericIndexedWriter<String> writer = new GenericIndexedWriter<String>(ioPeon, dimension, GenericIndexed.STRING_STRATEGY);
                writer.open();
                boolean dimHasNull = false;
                boolean dimHasValues = false;
                boolean dimAbsentFromSomeIndex = false;
                int numMergeIndex = 0;
                Indexed<Object> dimValueLookup = null;
                Indexed[] dimValueLookups = new Indexed[indexes.size() + 1];
                for (int i = 0; i < indexes.size(); ++i) {
                    Indexed<String> dimValues = indexes.get(i).getDimValueLookup(dimension);
                    if (!IndexMerger.isNullColumn(dimValues)) {
                        dimHasValues = true;
                        dimHasNull |= dimValues.indexOf(null) >= 0;
                        dimValueLookup = dimValues;
                        dimValueLookups[i] = dimValueLookup;
                        ++numMergeIndex;
                        continue;
                    }
                    dimAbsentFromSomeIndex = true;
                }
                boolean convertMissingDims = dimHasValues && dimAbsentFromSomeIndex;
                convertMissingDimsFlags.add(convertMissingDims);
                if (convertMissingDims && !dimHasNull) {
                    dimHasNull = true;
                    dimValueLookup = EMPTY_STR_DIM_VAL;
                    dimValueLookups[indexes.size()] = dimValueLookup;
                    ++numMergeIndex;
                }
                int cardinality = 0;
                if (numMergeIndex > 1) {
                    void var39_73;
                    Iterator<String> iterator = new DictionaryMergeIterator(dimValueLookups, true);
                    while (((DictionaryMergeIterator)iterator).hasNext()) {
                        writer.write(((DictionaryMergeIterator)iterator).next());
                    }
                    boolean bl = false;
                    while (var39_73 < indexes.size()) {
                        if (dimValueLookups[var39_73] != null && ((DictionaryMergeIterator)iterator).needConversion((int)var39_73)) {
                            ((Map)dimConversions.get((int)var39_73)).put(dimension, ((DictionaryMergeIterator)iterator).conversions[var39_73]);
                        }
                        ++var39_73;
                    }
                    cardinality = ((DictionaryMergeIterator)iterator).counter;
                } else if (numMergeIndex == 1) {
                    for (String string : dimValueLookup) {
                        writer.write(string);
                    }
                    cardinality = dimValueLookup.size();
                }
                dimensionCardinalities.put(dimension, cardinality);
                dimHasNullFlags.add(dimHasNull);
                FileOutputSupplier dimOut = new FileOutputSupplier(IndexIO.makeDimFile(v8OutDir, dimension), true);
                dimOuts.add(dimOut);
                writer.close();
                serializerUtils.writeString((OutputSupplier)dimOut, dimension);
                ByteStreams.copy(writer.combineStreams(), (OutputSupplier)dimOut);
                ioPeon.cleanup();
            }
            log.info("outDir[%s] completed dim conversions in %,d millis.", new Object[]{v8OutDir, System.currentTimeMillis() - startTime});
            progress.progress();
            startTime = System.currentTimeMillis();
            Iterable<Rowboat> theRows = this.makeRowIterable(indexes, mergedDimensions, mergedMetrics, dimConversions, convertMissingDimsFlags, rowMergerFn);
            CompressedLongsSupplierSerializer timeWriter = CompressedLongsSupplierSerializer.create(ioPeon, "little_end_time", IndexIO.BYTE_ORDER, CompressedObjectStrategy.DEFAULT_COMPRESSION_STRATEGY);
            timeWriter.open();
            ArrayList forwardDimWriters = Lists.newArrayListWithCapacity((int)mergedDimensions.size());
            for (String dimension : mergedDimensions) {
                VSizeIndexedWriter writer = new VSizeIndexedWriter(ioPeon, dimension, (Integer)dimensionCardinalities.get(dimension));
                writer.open();
                forwardDimWriters.add(writer);
            }
            ArrayList metWriters = Lists.newArrayListWithCapacity((int)mergedMetrics.size());
            block38: for (String metric : mergedMetrics) {
                ValueType type = (ValueType)((Object)valueTypes.get(metric));
                switch (type) {
                    case LONG: {
                        metWriters.add(new LongMetricColumnSerializer(metric, v8OutDir, ioPeon));
                        continue block38;
                    }
                    case FLOAT: {
                        metWriters.add(new FloatMetricColumnSerializer(metric, v8OutDir, ioPeon));
                        continue block38;
                    }
                    case COMPLEX: {
                        String typeName = (String)metricTypeNames.get(metric);
                        Iterator<Rowboat> serde = ComplexMetrics.getSerdeForType(typeName);
                        if (serde == null) {
                            throw new ISE("Unknown type[%s]", new Object[]{typeName});
                        }
                        metWriters.add(new ComplexMetricColumnSerializer(metric, v8OutDir, ioPeon, (ComplexMetricSerde)((Object)serde)));
                        continue block38;
                    }
                }
                throw new ISE("Unknown type[%s]", new Object[]{type});
            }
            for (MetricColumnSerializer metWriter : metWriters) {
                metWriter.open();
            }
            int rowCount = 0;
            long time = System.currentTimeMillis();
            ArrayList rowNumConversions = Lists.newArrayListWithCapacity((int)indexes.size());
            for (IndexableAdapter index : indexes) {
                int[] arr = new int[index.getNumRows()];
                Arrays.fill(arr, -1);
                rowNumConversions.add(IntBuffer.wrap(arr));
            }
            for (Rowboat theRow : theRows) {
                void var39_76;
                progress.progress();
                timeWriter.add(theRow.getTimestamp());
                Object[] metrics = theRow.getMetrics();
                for (int i = 0; i < metrics.length; ++i) {
                    ((MetricColumnSerializer)metWriters.get(i)).serialize(metrics[i]);
                }
                int[][] dims = theRow.getDims();
                boolean bl = false;
                while (var39_76 < dims.length) {
                    List listToWrite = var39_76 >= dims.length || dims[var39_76] == null ? null : Ints.asList((int[])dims[var39_76]);
                    ((VSizeIndexedWriter)forwardDimWriters.get((int)var39_76)).write(listToWrite);
                    if (listToWrite == null || listToWrite.isEmpty()) {
                        ((MutableBitmap)nullRowsList.get((int)var39_76)).add(rowCount);
                    } else if (((Boolean)dimHasNullFlags.get((int)var39_76)).booleanValue() && listToWrite.size() == 1 && (Integer)listToWrite.get(0) == 0) {
                        ((MutableBitmap)nullRowsList.get((int)var39_76)).add(rowCount);
                    }
                    ++var39_76;
                }
                for (Map.Entry<Integer, TreeSet<Integer>> comprisedRow : theRow.getComprisedRows().entrySet()) {
                    IntBuffer conversionBuffer = (IntBuffer)rowNumConversions.get(comprisedRow.getKey());
                    for (Integer n : comprisedRow.getValue()) {
                        while (conversionBuffer.position() < n) {
                            conversionBuffer.put(-1);
                        }
                        conversionBuffer.put(rowCount);
                    }
                }
                if (++rowCount % 500000 != 0) continue;
                log.info("outDir[%s] walked 500,000/%,d rows in %,d millis.", new Object[]{v8OutDir, rowCount, System.currentTimeMillis() - time});
                time = System.currentTimeMillis();
            }
            for (IntBuffer rowNumConversion : rowNumConversions) {
                rowNumConversion.rewind();
            }
            File timeFile = IndexIO.makeTimeFile(v8OutDir, IndexIO.BYTE_ORDER);
            timeFile.delete();
            OutputSupplier out = Files.newOutputStreamSupplier((File)timeFile, (boolean)true);
            timeWriter.closeAndConsolidate((OutputSupplier<? extends OutputStream>)out);
            IndexIO.checkFileSize(timeFile);
            for (int i = 0; i < mergedDimensions.size(); ++i) {
                ((VSizeIndexedWriter)forwardDimWriters.get(i)).close();
                ByteStreams.copy(((VSizeIndexedWriter)forwardDimWriters.get(i)).combineStreams(), (OutputSupplier)((OutputSupplier)dimOuts.get(i)));
            }
            for (MetricColumnSerializer metWriter : metWriters) {
                metWriter.close();
            }
            ioPeon.cleanup();
            log.info("outDir[%s] completed walk through of %,d rows in %,d millis.", new Object[]{v8OutDir, rowCount, System.currentTimeMillis() - startTime});
            startTime = System.currentTimeMillis();
            File invertedFile = new File(v8OutDir, "inverted.drd");
            Files.touch((File)invertedFile);
            out = Files.newOutputStreamSupplier((File)invertedFile, (boolean)true);
            File geoFile = new File(v8OutDir, "spatial.drd");
            Files.touch((File)geoFile);
            OutputSupplier outputSupplier = Files.newOutputStreamSupplier((File)geoFile, (boolean)true);
            for (int i = 0; i < mergedDimensions.size(); ++i) {
                File dimOutFile;
                MappedByteBuffer dimValsMapped;
                long dimStartTime = System.currentTimeMillis();
                String string = mergedDimensions.get(i);
                if (!string.equals(serializerUtils.readString((ByteBuffer)(dimValsMapped = Files.map((File)(dimOutFile = ((FileOutputSupplier)dimOuts.get(i)).getFile())))))) {
                    throw new ISE("dimensions[%s] didn't equate!?  This is a major WTF moment.", new Object[]{string});
                }
                GenericIndexed<String> dimVals = GenericIndexed.read(dimValsMapped, GenericIndexed.STRING_STRATEGY);
                log.info("Starting dimension[%s] with cardinality[%,d]", new Object[]{string, dimVals.size()});
                BitmapSerdeFactory bitmapSerdeFactory = indexSpec.getBitmapSerdeFactory();
                GenericIndexedWriter<ImmutableBitmap> writer = new GenericIndexedWriter<ImmutableBitmap>(ioPeon, string, bitmapSerdeFactory.getObjectStrategy());
                writer.open();
                boolean isSpatialDim = ((ColumnCapabilitiesImpl)columnCapabilities.get(string)).hasSpatialIndexes();
                ByteBufferWriter<ImmutableRTree> spatialWriter = null;
                RTree tree = null;
                TmpFileIOPeon spatialIoPeon = new TmpFileIOPeon();
                if (isSpatialDim) {
                    BitmapFactory bitmapFactory = bitmapSerdeFactory.getBitmapFactory();
                    spatialWriter = new ByteBufferWriter<ImmutableRTree>(spatialIoPeon, string, new IndexedRTree.ImmutableRTreeObjectStrategy(bitmapFactory));
                    spatialWriter.open();
                    tree = new RTree(2, (SplitStrategy)new LinearGutmanSplitStrategy(0, 50, bitmapFactory), bitmapFactory);
                }
                IndexSeeker[] dictIdSeeker = this.toIndexSeekers(indexes, dimConversions, string);
                for (int dictId = 0; dictId < dimVals.size(); ++dictId) {
                    String dimVal;
                    progress.progress();
                    ArrayList convertedInverteds = Lists.newArrayListWithCapacity((int)indexes.size());
                    for (int j = 0; j < indexes.size(); ++j) {
                        int seekedDictId = dictIdSeeker[j].seek(dictId);
                        if (seekedDictId == -1) continue;
                        convertedInverteds.add(new ConvertingIndexedInts(indexes.get(j).getBitmapIndex(string, seekedDictId), (IntBuffer)rowNumConversions.get(j)));
                    }
                    MutableBitmap bitset = bitmapSerdeFactory.getBitmapFactory().makeEmptyMutableBitmap();
                    for (Integer row : CombiningIterable.createSplatted((Iterable)convertedInverteds, (Comparator)Ordering.natural().nullsFirst())) {
                        if (row == -1) continue;
                        bitset.add(row.intValue());
                    }
                    if (dictId == 0 && Iterables.getFirst(dimVals, (Object)"") == null) {
                        bitset.or((MutableBitmap)nullRowsList.get(i));
                    }
                    writer.write(bitmapSerdeFactory.getBitmapFactory().makeImmutableBitmap(bitset));
                    if (!isSpatialDim || (dimVal = (String)dimVals.get(dictId)) == null) continue;
                    ArrayList stringCoords = Lists.newArrayList((Iterable)SPLITTER.split((CharSequence)dimVal));
                    float[] coords = new float[stringCoords.size()];
                    for (int j = 0; j < coords.length; ++j) {
                        coords[j] = Float.valueOf((String)stringCoords.get(j)).floatValue();
                    }
                    tree.insert(coords, bitset);
                }
                writer.close();
                serializerUtils.writeString(out, string);
                ByteStreams.copy(writer.combineStreams(), (OutputSupplier)out);
                ioPeon.cleanup();
                log.info("Completed dimension[%s] in %,d millis.", new Object[]{string, System.currentTimeMillis() - dimStartTime});
                if (!isSpatialDim) continue;
                spatialWriter.write(ImmutableRTree.newImmutableFromMutable((RTree)tree));
                spatialWriter.close();
                serializerUtils.writeString(outputSupplier, string);
                ByteStreams.copy(spatialWriter.combineStreams(), (OutputSupplier)outputSupplier);
                spatialIoPeon.cleanup();
            }
            log.info("outDir[%s] completed inverted.drd in %,d millis.", new Object[]{v8OutDir, System.currentTimeMillis() - startTime});
            ArrayList expectedFiles = Lists.newArrayList((Iterable)Iterables.concat(Arrays.asList("index.drd", "inverted.drd", "spatial.drd", String.format("time_%s.drd", IndexIO.BYTE_ORDER)), (Iterable)Iterables.transform(mergedDimensions, (Function)GuavaUtils.formatFunction((String)"dim_%s.drd")), (Iterable)Iterables.transform(mergedMetrics, (Function)GuavaUtils.formatFunction((String)String.format("met_%%s_%s.drd", IndexIO.BYTE_ORDER)))));
            if (segmentMetadata != null) {
                this.writeMetadataToFile(new File(v8OutDir, "metadata.drd"), segmentMetadata);
                log.info("wrote metadata.drd in outDir[%s].", new Object[]{v8OutDir});
                expectedFiles.add("metadata.drd");
            }
            LinkedHashMap files = Maps.newLinkedHashMap();
            for (String string : expectedFiles) {
                files.put(string, new File(v8OutDir, string));
            }
            File smooshDir = new File(v8OutDir, "smoosher");
            smooshDir.mkdir();
            for (Map.Entry entry : Smoosh.smoosh((File)v8OutDir, (File)smooshDir, (Map)files).entrySet()) {
                ((File)entry.getValue()).delete();
            }
            for (File file : smooshDir.listFiles()) {
                Files.move((File)file, (File)new File(v8OutDir, file.getName()));
            }
            if (!smooshDir.delete()) {
                log.info("Unable to delete temporary dir[%s], contains[%s]", new Object[]{smooshDir, Arrays.asList(smooshDir.listFiles())});
                throw new IOException(String.format("Unable to delete temporary dir[%s]", smooshDir));
            }
            this.createIndexDrdFile((byte)8, v8OutDir, GenericIndexed.fromIterable(mergedDimensions, GenericIndexed.STRING_STRATEGY), GenericIndexed.fromIterable(mergedMetrics, GenericIndexed.STRING_STRATEGY), dataInterval, indexSpec.getBitmapSerdeFactory());
            this.indexIO.getDefaultIndexIOHandler().convertV8toV9(v8OutDir, outDir, indexSpec);
            File file = outDir;
            return file;
        }
        finally {
            closer.close();
        }
    }

    protected Iterable<Rowboat> makeRowIterable(List<IndexableAdapter> indexes, final List<String> mergedDimensions, final List<String> mergedMetrics, ArrayList<Map<String, IntBuffer>> dimConversions, ArrayList<Boolean> convertMissingDimsFlags, Function<ArrayList<Iterable<Rowboat>>, Iterable<Rowboat>> rowMergerFn) {
        ArrayList boats = Lists.newArrayListWithCapacity((int)indexes.size());
        for (int i = 0; i < indexes.size(); ++i) {
            IndexableAdapter adapter = indexes.get(i);
            final int[] dimLookup = this.toLookupMap(adapter.getDimensionNames(), mergedDimensions);
            final int[] metricLookup = this.toLookupMap(adapter.getMetricNames(), mergedMetrics);
            Iterable target = indexes.get(i).getRows();
            if (dimLookup != null || metricLookup != null) {
                target = Iterables.transform(target, (Function)new Function<Rowboat, Rowboat>(){

                    public Rowboat apply(Rowboat input) {
                        Object newDims = input.getDims();
                        if (dimLookup != null) {
                            newDims = new int[mergedDimensions.size()][];
                            int j = 0;
                            for (int[] dim : input.getDims()) {
                                newDims[dimLookup[j]] = dim;
                                ++j;
                            }
                        }
                        Object[] newMetrics = input.getMetrics();
                        if (metricLookup != null) {
                            newMetrics = new Object[mergedMetrics.size()];
                            int j = 0;
                            Object[] objectArray = input.getMetrics();
                            int n = objectArray.length;
                            for (int i = 0; i < n; ++i) {
                                Object met;
                                newMetrics[metricLookup[j]] = met = objectArray[i];
                                ++j;
                            }
                        }
                        return new Rowboat(input.getTimestamp(), (int[][])newDims, newMetrics, input.getRowNum());
                    }
                });
            }
            boats.add(new MMappedIndexRowIterable(target, mergedDimensions, dimConversions.get(i), i, convertMissingDimsFlags));
        }
        return (Iterable)rowMergerFn.apply((Object)boats);
    }

    private int[] toLookupMap(Indexed<String> indexed, List<String> values) {
        if (this.isSame(indexed, values)) {
            return null;
        }
        int[] dimLookup = new int[values.size()];
        for (int i = 0; i < indexed.size(); ++i) {
            dimLookup[i] = values.indexOf(indexed.get(i));
        }
        return dimLookup;
    }

    private boolean isSame(Indexed<String> indexed, List<String> values) {
        if (indexed.size() != values.size()) {
            return false;
        }
        for (int i = 0; i < indexed.size(); ++i) {
            if (indexed.get(i).equals(values.get(i))) continue;
            return false;
        }
        return true;
    }

    public static <T extends Comparable> ArrayList<T> mergeIndexed(List<Iterable<T>> indexedLists) {
        TreeSet retVal = Sets.newTreeSet((Comparator)Ordering.natural().nullsFirst());
        for (Iterable<T> indexedList : indexedLists) {
            for (Comparable val : indexedList) {
                retVal.add(val);
            }
        }
        return Lists.newArrayList((Iterable)retVal);
    }

    public void createIndexDrdFile(byte versionId, File inDir, GenericIndexed<String> availableDimensions, GenericIndexed<String> availableMetrics, Interval dataInterval, BitmapSerdeFactory bitmapSerdeFactory) throws IOException {
        File indexFile = new File(inDir, "index.drd");
        try (FileChannel channel = new FileOutputStream(indexFile).getChannel();){
            channel.write(ByteBuffer.wrap(new byte[]{versionId}));
            availableDimensions.writeToChannel(channel);
            availableMetrics.writeToChannel(channel);
            serializerUtils.writeString((WritableByteChannel)channel, String.format("%s/%s", dataInterval.getStart(), dataInterval.getEnd()));
            serializerUtils.writeString((WritableByteChannel)channel, this.mapper.writeValueAsString((Object)bitmapSerdeFactory));
        }
        IndexIO.checkFileSize(indexFile);
    }

    protected IndexSeeker[] toIndexSeekers(List<IndexableAdapter> adapters, ArrayList<Map<String, IntBuffer>> dimConversions, String dimension) {
        IndexSeeker[] seekers = new IndexSeeker[adapters.size()];
        for (int i = 0; i < adapters.size(); ++i) {
            Indexed<String> dimValueLookup;
            IntBuffer dimConversion = dimConversions.get(i).get(dimension);
            seekers[i] = dimConversion != null ? new IndexSeekerWithConversion((IntBuffer)dimConversion.asReadOnlyBuffer().rewind()) : new IndexSeekerWithoutConversion((dimValueLookup = adapters.get(i).getDimValueLookup(dimension)) == null ? 0 : dimValueLookup.size());
        }
        return seekers;
    }

    public static boolean isNullColumn(Iterable<String> dimValues) {
        if (dimValues == null) {
            return true;
        }
        for (String val : dimValues) {
            if (val == null) continue;
            return false;
        }
        return true;
    }

    private void writeMetadataToFile(File metadataFile, Metadata metadata) throws IOException {
        try (FileOutputStream metadataFileOutputStream = new FileOutputStream(metadataFile);
             FileChannel metadataFilechannel = metadataFileOutputStream.getChannel();){
            byte[] metadataBytes = this.mapper.writeValueAsBytes((Object)metadata);
            if (metadataBytes.length != metadataFilechannel.write(ByteBuffer.wrap(metadataBytes))) {
                throw new IOException("Failed to write metadata for file");
            }
        }
        IndexIO.checkFileSize(metadataFile);
    }

    static class DictionaryMergeIterator
    implements Iterator<String> {
        protected final IntBuffer[] conversions;
        protected final PriorityQueue<Pair<Integer, PeekingIterator<String>>> pQueue;
        protected int counter;

        DictionaryMergeIterator(Indexed<String>[] dimValueLookups, boolean useDirect) {
            this.pQueue = new PriorityQueue<Pair<Integer, PeekingIterator<String>>>(dimValueLookups.length, new Comparator<Pair<Integer, PeekingIterator<String>>>(){

                @Override
                public int compare(Pair<Integer, PeekingIterator<String>> lhs, Pair<Integer, PeekingIterator<String>> rhs) {
                    return ((String)((PeekingIterator)lhs.rhs).peek()).compareTo((String)((PeekingIterator)rhs.rhs).peek());
                }
            });
            this.conversions = new IntBuffer[dimValueLookups.length];
            for (int i = 0; i < this.conversions.length; ++i) {
                if (dimValueLookups[i] == null) continue;
                Indexed<String> indexed = dimValueLookups[i];
                this.conversions[i] = useDirect ? ByteBuffer.allocateDirect(indexed.size() * 4).asIntBuffer() : IntBuffer.allocate(indexed.size());
                PeekingIterator iter = Iterators.peekingIterator((Iterator)Iterators.transform(indexed.iterator(), (Function)new Function<String, String>(){

                    public String apply(@Nullable String input) {
                        return Strings.nullToEmpty((String)input);
                    }
                }));
                if (!iter.hasNext()) continue;
                this.pQueue.add((Pair<Integer, PeekingIterator<String>>)Pair.of((Object)i, (Object)iter));
            }
        }

        @Override
        public boolean hasNext() {
            return !this.pQueue.isEmpty();
        }

        @Override
        public String next() {
            Pair smallest = (Pair)this.pQueue.remove();
            if (smallest == null) {
                throw new NoSuchElementException();
            }
            String value = this.writeTranslate((Pair<Integer, PeekingIterator<String>>)smallest, this.counter);
            while (!this.pQueue.isEmpty() && value.equals(((PeekingIterator)this.pQueue.peek().rhs).peek())) {
                this.writeTranslate((Pair<Integer, PeekingIterator<String>>)((Pair)this.pQueue.remove()), this.counter);
            }
            ++this.counter;
            return value;
        }

        boolean needConversion(int index) {
            IntBuffer readOnly = this.conversions[index].asReadOnlyBuffer();
            readOnly.rewind();
            int i = 0;
            while (readOnly.hasRemaining()) {
                if (i != readOnly.get()) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private String writeTranslate(Pair<Integer, PeekingIterator<String>> smallest, int counter) {
            int index = (Integer)smallest.lhs;
            String value = (String)((PeekingIterator)smallest.rhs).next();
            this.conversions[index].put(counter);
            if (((PeekingIterator)smallest.rhs).hasNext()) {
                this.pQueue.add(smallest);
            }
            return value;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    public static class RowboatMergeFunction
    implements BinaryFn<Rowboat, Rowboat, Rowboat> {
        private final AggregatorFactory[] metricAggs;

        public RowboatMergeFunction(AggregatorFactory[] metricAggs) {
            this.metricAggs = metricAggs;
        }

        public Rowboat apply(Rowboat lhs, Rowboat rhs) {
            if (lhs == null) {
                return rhs;
            }
            if (rhs == null) {
                return lhs;
            }
            Object[] metrics = new Object[this.metricAggs.length];
            Object[] lhsMetrics = lhs.getMetrics();
            Object[] rhsMetrics = rhs.getMetrics();
            for (int i = 0; i < metrics.length; ++i) {
                Object lhsMetric = lhsMetrics[i];
                Object rhsMetric = rhsMetrics[i];
                metrics[i] = lhsMetric == null ? rhsMetric : (rhsMetric == null ? lhsMetric : this.metricAggs[i].combine(lhsMetric, rhsMetric));
            }
            Rowboat retVal = new Rowboat(lhs.getTimestamp(), lhs.getDims(), metrics, lhs.getRowNum());
            for (Rowboat rowboat : Arrays.asList(lhs, rhs)) {
                for (Map.Entry<Integer, TreeSet<Integer>> entry : rowboat.getComprisedRows().entrySet()) {
                    for (Integer rowNum : entry.getValue()) {
                        retVal.addRow(entry.getKey(), rowNum);
                    }
                }
            }
            return retVal;
        }
    }

    public static class AggFactoryStringIndexed
    implements Indexed<String> {
        private final AggregatorFactory[] metricAggs;

        public AggFactoryStringIndexed(AggregatorFactory[] metricAggs) {
            this.metricAggs = metricAggs;
        }

        @Override
        public Class<? extends String> getClazz() {
            return String.class;
        }

        @Override
        public int size() {
            return this.metricAggs.length;
        }

        @Override
        public String get(int index) {
            return this.metricAggs[index].getName();
        }

        @Override
        public int indexOf(String value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<String> iterator() {
            return IndexedIterable.create(this).iterator();
        }
    }

    public static class MMappedIndexRowIterable
    implements Iterable<Rowboat> {
        private final Iterable<Rowboat> index;
        private final List<String> convertedDims;
        private final Map<String, IntBuffer> converters;
        private final int indexNumber;
        private final ArrayList<Boolean> convertMissingDimsFlags;
        private static final int[] EMPTY_STR_DIM = new int[]{0};

        MMappedIndexRowIterable(Iterable<Rowboat> index, List<String> convertedDims, Map<String, IntBuffer> converters, int indexNumber, ArrayList<Boolean> convertMissingDimsFlags) {
            this.index = index;
            this.convertedDims = convertedDims;
            this.converters = converters;
            this.indexNumber = indexNumber;
            this.convertMissingDimsFlags = convertMissingDimsFlags;
        }

        public Iterable<Rowboat> getIndex() {
            return this.index;
        }

        @Override
        public Iterator<Rowboat> iterator() {
            final IntBuffer[] converterArray = (IntBuffer[])FluentIterable.from(this.convertedDims).transform((Function)new Function<String, IntBuffer>(){

                public IntBuffer apply(String input) {
                    return (IntBuffer)MMappedIndexRowIterable.this.converters.get(input);
                }
            }).toArray(IntBuffer.class);
            return Iterators.transform(this.index.iterator(), (Function)new Function<Rowboat, Rowboat>(){

                public Rowboat apply(@Nullable Rowboat input) {
                    int[][] dims = input.getDims();
                    int[][] newDims = new int[MMappedIndexRowIterable.this.convertedDims.size()][];
                    for (int i = 0; i < MMappedIndexRowIterable.this.convertedDims.size(); ++i) {
                        IntBuffer converter = converterArray[i];
                        if (i >= dims.length) continue;
                        if (dims[i] == null && ((Boolean)MMappedIndexRowIterable.this.convertMissingDimsFlags.get(i)).booleanValue()) {
                            newDims[i] = EMPTY_STR_DIM;
                            continue;
                        }
                        if (converter == null) {
                            newDims[i] = dims[i];
                            continue;
                        }
                        newDims[i] = new int[dims[i].length];
                        for (int j = 0; j < dims[i].length; ++j) {
                            newDims[i][j] = converter.get(dims[i][j]);
                        }
                    }
                    Rowboat retVal = new Rowboat(input.getTimestamp(), newDims, input.getMetrics(), input.getRowNum());
                    retVal.addRow(MMappedIndexRowIterable.this.indexNumber, input.getRowNum());
                    return retVal;
                }
            });
        }
    }

    public static class ConvertingIndexedInts
    implements Iterable<Integer> {
        private final IndexedInts baseIndex;
        private final IntBuffer conversionBuffer;

        public ConvertingIndexedInts(IndexedInts baseIndex, IntBuffer conversionBuffer) {
            this.baseIndex = baseIndex;
            this.conversionBuffer = conversionBuffer;
        }

        public int size() {
            return this.baseIndex.size();
        }

        public int get(int index) {
            return this.conversionBuffer.get(this.baseIndex.get(index));
        }

        @Override
        public Iterator<Integer> iterator() {
            return Iterators.transform(this.baseIndex.iterator(), (Function)new Function<Integer, Integer>(){

                public Integer apply(@Nullable Integer input) {
                    return ConvertingIndexedInts.this.conversionBuffer.get(input);
                }
            });
        }
    }

    static class IndexSeekerWithConversion
    implements IndexSeeker {
        private final IntBuffer dimConversions;
        private int currIndex;
        private int currVal;
        private int lastVal;

        IndexSeekerWithConversion(IntBuffer dimConversions) {
            this.dimConversions = dimConversions;
            this.currIndex = 0;
            this.currVal = -1;
            this.lastVal = -1;
        }

        @Override
        public int seek(int dictId) {
            if (this.dimConversions == null) {
                return -1;
            }
            if (this.lastVal != -1) {
                if (dictId <= this.lastVal) {
                    throw new ISE("Value dictId[%d] is less than the last value dictId[%d] I have, cannot be.", new Object[]{dictId, this.lastVal});
                }
                return -1;
            }
            if (this.currVal == -1) {
                this.currVal = this.dimConversions.get();
            }
            if (this.currVal == dictId) {
                int ret = this.currIndex++;
                if (this.dimConversions.hasRemaining()) {
                    this.currVal = this.dimConversions.get();
                } else {
                    this.lastVal = dictId;
                }
                return ret;
            }
            if (this.currVal < dictId) {
                throw new ISE("Skipped currValue dictId[%d], currIndex[%d]; incoming value dictId[%d]", new Object[]{this.currVal, this.currIndex, dictId});
            }
            return -1;
        }
    }

    static class IndexSeekerWithoutConversion
    implements IndexSeeker {
        private final int limit;

        public IndexSeekerWithoutConversion(int limit) {
            this.limit = limit;
        }

        @Override
        public int seek(int dictId) {
            return dictId < this.limit ? dictId : -1;
        }
    }

    static interface IndexSeeker {
        public static final int NOT_EXIST = -1;
        public static final int NOT_INIT = -1;

        public int seek(int var1);
    }
}

