/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.column;

import io.druid.segment.column.GenericColumn;
import io.druid.segment.column.ValueType;
import io.druid.segment.data.Indexed;
import io.druid.segment.data.IndexedFloats;
import io.druid.segment.data.IndexedLongs;
import java.io.IOException;

public class IndexedFloatsGenericColumn
implements GenericColumn {
    private final IndexedFloats column;

    public IndexedFloatsGenericColumn(IndexedFloats column) {
        this.column = column;
    }

    @Override
    public int length() {
        return this.column.size();
    }

    @Override
    public ValueType getType() {
        return ValueType.FLOAT;
    }

    @Override
    public boolean hasMultipleValues() {
        return false;
    }

    @Override
    public String getStringSingleValueRow(int rowNum) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Indexed<String> getStringMultiValueRow(int rowNum) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float getFloatSingleValueRow(int rowNum) {
        return this.column.get(rowNum);
    }

    @Override
    public IndexedFloats getFloatMultiValueRow(int rowNum) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLongSingleValueRow(int rowNum) {
        return (long)this.column.get(rowNum);
    }

    @Override
    public IndexedLongs getLongMultiValueRow(int rowNum) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        this.column.close();
    }
}

