/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.io.ByteStreams;
import com.google.common.primitives.Ints;
import io.druid.collections.ResourceHolder;
import io.druid.collections.StupidResourceHolder;
import io.druid.segment.IndexIO;
import io.druid.segment.data.CompressedByteBufferObjectStrategy;
import io.druid.segment.data.CompressedObjectStrategy;
import io.druid.segment.data.CompressedVSizeIntsIndexedSupplier;
import io.druid.segment.data.GenericIndexedWriter;
import io.druid.segment.data.IOPeon;
import io.druid.segment.data.SingleValueIndexedIntsWriter;
import io.druid.segment.data.VSizeIndexedInts;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class CompressedVSizeIntsIndexedWriter
extends SingleValueIndexedIntsWriter {
    private static final byte VERSION = 2;
    private final int numBytes;
    private final int chunkFactor;
    private final int chunkBytes;
    private final ByteOrder byteOrder;
    private final CompressedObjectStrategy.CompressionStrategy compression;
    private final GenericIndexedWriter<ResourceHolder<ByteBuffer>> flattener;
    private final ByteBuffer intBuffer;
    private ByteBuffer endBuffer;
    private int numInserted;

    public static CompressedVSizeIntsIndexedWriter create(IOPeon ioPeon, String filenameBase, int maxValue, CompressedObjectStrategy.CompressionStrategy compression) {
        return new CompressedVSizeIntsIndexedWriter(ioPeon, filenameBase, maxValue, CompressedVSizeIntsIndexedSupplier.maxIntsInBufferForValue(maxValue), IndexIO.BYTE_ORDER, compression);
    }

    public CompressedVSizeIntsIndexedWriter(IOPeon ioPeon, String filenameBase, int maxValue, int chunkFactor, ByteOrder byteOrder, CompressedObjectStrategy.CompressionStrategy compression) {
        this.numBytes = VSizeIndexedInts.getNumBytesForMax(maxValue);
        this.chunkFactor = chunkFactor;
        this.chunkBytes = chunkFactor * this.numBytes + CompressedVSizeIntsIndexedSupplier.bufferPadding(this.numBytes);
        this.byteOrder = byteOrder;
        this.compression = compression;
        this.flattener = new GenericIndexedWriter<ResourceHolder<ByteBuffer>>(ioPeon, filenameBase, CompressedByteBufferObjectStrategy.getBufferForOrder(byteOrder, compression, this.chunkBytes));
        this.intBuffer = ByteBuffer.allocate(4).order(byteOrder);
        this.endBuffer = ByteBuffer.allocate(this.chunkBytes).order(byteOrder);
        this.endBuffer.limit(this.numBytes * chunkFactor);
        this.numInserted = 0;
    }

    @Override
    public void open() throws IOException {
        this.flattener.open();
    }

    @Override
    protected void addValue(int val) throws IOException {
        if (!this.endBuffer.hasRemaining()) {
            this.endBuffer.rewind();
            this.flattener.write((ResourceHolder<ByteBuffer>)StupidResourceHolder.create((Object)this.endBuffer));
            this.endBuffer = ByteBuffer.allocate(this.chunkBytes).order(this.byteOrder);
            this.endBuffer.limit(this.numBytes * this.chunkFactor);
        }
        this.intBuffer.putInt(0, val);
        if (this.byteOrder.equals(ByteOrder.BIG_ENDIAN)) {
            this.endBuffer.put(this.intBuffer.array(), 4 - this.numBytes, this.numBytes);
        } else {
            this.endBuffer.put(this.intBuffer.array(), 0, this.numBytes);
        }
        ++this.numInserted;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.numInserted > 0) {
                this.endBuffer.limit(this.endBuffer.position());
                this.endBuffer.rewind();
                this.flattener.write((ResourceHolder<ByteBuffer>)StupidResourceHolder.create((Object)this.endBuffer));
            }
            this.endBuffer = null;
        }
        finally {
            this.flattener.close();
        }
    }

    @Override
    public long getSerializedSize() {
        return 11L + this.flattener.getSerializedSize();
    }

    @Override
    public void writeToChannel(WritableByteChannel channel) throws IOException {
        channel.write(ByteBuffer.wrap(new byte[]{2, (byte)this.numBytes}));
        channel.write(ByteBuffer.wrap(Ints.toByteArray((int)this.numInserted)));
        channel.write(ByteBuffer.wrap(Ints.toByteArray((int)this.chunkFactor)));
        channel.write(ByteBuffer.wrap(new byte[]{this.compression.getId()}));
        ReadableByteChannel from = Channels.newChannel((InputStream)this.flattener.combineStreams().getInput());
        ByteStreams.copy((ReadableByteChannel)from, (WritableByteChannel)channel);
    }
}

