/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.incremental;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.metamx.common.IAE;
import com.metamx.common.ISE;
import com.metamx.common.parsers.ParseException;
import io.druid.data.input.InputRow;
import io.druid.data.input.MapBasedRow;
import io.druid.data.input.Row;
import io.druid.data.input.impl.DimensionSchema;
import io.druid.data.input.impl.DimensionsSpec;
import io.druid.granularity.QueryGranularity;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.PostAggregator;
import io.druid.query.dimension.DimensionSpec;
import io.druid.query.extraction.ExtractionFn;
import io.druid.segment.ColumnSelectorFactory;
import io.druid.segment.DimensionSelector;
import io.druid.segment.FloatColumnSelector;
import io.druid.segment.LongColumnSelector;
import io.druid.segment.Metadata;
import io.druid.segment.ObjectColumnSelector;
import io.druid.segment.column.ColumnCapabilities;
import io.druid.segment.column.ColumnCapabilitiesImpl;
import io.druid.segment.column.ValueType;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.incremental.IncrementalIndexSchema;
import io.druid.segment.incremental.IndexSizeExceededException;
import io.druid.segment.incremental.SpatialDimensionRowTransformer;
import io.druid.segment.serde.ComplexMetricExtractor;
import io.druid.segment.serde.ComplexMetricSerde;
import io.druid.segment.serde.ComplexMetrics;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public abstract class IncrementalIndex<AggregatorType>
implements Iterable<Row>,
Closeable {
    private volatile DateTime maxIngestedEventTime;
    private static final Map<Object, ValueType> TYPE_MAP = ImmutableMap.builder().put(Long.class, (Object)ValueType.LONG).put(Double.class, (Object)ValueType.FLOAT).put(Float.class, (Object)ValueType.FLOAT).put(String.class, (Object)ValueType.STRING).put((Object)DimensionSchema.ValueType.LONG, (Object)ValueType.LONG).put((Object)DimensionSchema.ValueType.FLOAT, (Object)ValueType.FLOAT).put((Object)DimensionSchema.ValueType.STRING, (Object)ValueType.STRING).build();
    private static final Function<Object, String> STRING_TRANSFORMER = new Function<Object, String>(){

        public String apply(Object o) {
            return o == null ? null : String.valueOf(o);
        }
    };
    private static final Function<Object, Long> LONG_TRANSFORMER = new Function<Object, Long>(){

        public Long apply(Object o) {
            if (o == null) {
                return null;
            }
            if (o instanceof String) {
                String s = (String)o;
                try {
                    return s.isEmpty() ? null : Long.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    throw new ParseException((Throwable)nfe, "Unable to parse value[%s] as long in column: ", new Object[]{o});
                }
            }
            if (o instanceof Number) {
                return ((Number)o).longValue();
            }
            return null;
        }
    };
    private static final Function<Object, Float> FLOAT_TRANSFORMER = new Function<Object, Float>(){

        public Float apply(Object o) {
            if (o == null) {
                return null;
            }
            if (o instanceof String) {
                String s = (String)o;
                try {
                    return s.isEmpty() ? null : Float.valueOf(s);
                }
                catch (NumberFormatException nfe) {
                    throw new ParseException((Throwable)nfe, "Unable to parse value[%s] as float in column: ", new Object[]{o});
                }
            }
            if (o instanceof Number) {
                return Float.valueOf(((Number)o).floatValue());
            }
            return null;
        }
    };
    private static final Map<ValueType, Function> VALUE_TRANSFORMS = ImmutableMap.builder().put((Object)ValueType.LONG, LONG_TRANSFORMER).put((Object)ValueType.FLOAT, FLOAT_TRANSFORMER).put((Object)ValueType.STRING, STRING_TRANSFORMER).build();
    private final long minTimestamp;
    private final QueryGranularity gran;
    private final List<Function<InputRow, InputRow>> rowTransformers;
    private final AggregatorFactory[] metrics;
    private final AggregatorType[] aggs;
    private final boolean deserializeComplexMetrics;
    private final boolean reportParseExceptions;
    private final boolean sortFacts;
    private final Metadata metadata;
    private final Map<String, MetricDesc> metricDescs;
    private final Map<String, DimensionDesc> dimensionDescs;
    private final Map<String, ColumnCapabilitiesImpl> columnCapabilities;
    private final List<DimDim> dimValues;
    private final Ordering<Comparable> ordering = Ordering.natural().nullsFirst();
    private final AtomicInteger numEntries = new AtomicInteger();
    private final ThreadLocal<InputRow> in = new ThreadLocal();
    private final Supplier<InputRow> rowSupplier = new Supplier<InputRow>(){

        public InputRow get() {
            return (InputRow)IncrementalIndex.this.in.get();
        }
    };

    public static ColumnSelectorFactory makeColumnSelectorFactory(final AggregatorFactory agg, final Supplier<InputRow> in, final boolean deserializeComplexMetrics) {
        return new ColumnSelectorFactory(){

            @Override
            public LongColumnSelector makeLongColumnSelector(final String columnName) {
                if (columnName.equals("__time")) {
                    return new LongColumnSelector(){

                        @Override
                        public long get() {
                            return ((InputRow)in.get()).getTimestampFromEpoch();
                        }
                    };
                }
                return new LongColumnSelector(){

                    @Override
                    public long get() {
                        return ((InputRow)in.get()).getLongMetric(columnName);
                    }
                };
            }

            @Override
            public FloatColumnSelector makeFloatColumnSelector(final String columnName) {
                return new FloatColumnSelector(){

                    @Override
                    public float get() {
                        return ((InputRow)in.get()).getFloatMetric(columnName);
                    }
                };
            }

            @Override
            public ObjectColumnSelector makeObjectColumnSelector(final String column) {
                String typeName = agg.getTypeName();
                ObjectColumnSelector<Object> rawColumnSelector = new ObjectColumnSelector<Object>(){

                    @Override
                    public Class classOfObject() {
                        return Object.class;
                    }

                    @Override
                    public Object get() {
                        return ((InputRow)in.get()).getRaw(column);
                    }
                };
                if (!deserializeComplexMetrics) {
                    return rawColumnSelector;
                }
                if (typeName.equals("float")) {
                    return rawColumnSelector;
                }
                ComplexMetricSerde serde = ComplexMetrics.getSerdeForType(typeName);
                if (serde == null) {
                    throw new ISE("Don't know how to handle type[%s]", new Object[]{typeName});
                }
                final ComplexMetricExtractor extractor = serde.getExtractor();
                return new ObjectColumnSelector(){

                    public Class classOfObject() {
                        return extractor.extractedClass();
                    }

                    public Object get() {
                        return extractor.extractValue((InputRow)in.get(), column);
                    }
                };
            }

            @Override
            public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
                return dimensionSpec.decorate(this.makeDimensionSelectorUndecorated(dimensionSpec));
            }

            private DimensionSelector makeDimensionSelectorUndecorated(DimensionSpec dimensionSpec) {
                final String dimension = dimensionSpec.getDimension();
                final ExtractionFn extractionFn = dimensionSpec.getExtractionFn();
                return new DimensionSelector(){

                    @Override
                    public IndexedInts getRow() {
                        List dimensionValues = ((InputRow)in.get()).getDimension(dimension);
                        final ArrayList vals = Lists.newArrayList();
                        if (dimensionValues != null) {
                            for (int i = 0; i < dimensionValues.size(); ++i) {
                                vals.add(i);
                            }
                        }
                        return new IndexedInts(){

                            @Override
                            public int size() {
                                return vals.size();
                            }

                            @Override
                            public int get(int index) {
                                return (Integer)vals.get(index);
                            }

                            @Override
                            public Iterator<Integer> iterator() {
                                return vals.iterator();
                            }

                            @Override
                            public void close() throws IOException {
                            }

                            @Override
                            public void fill(int index, int[] toFill) {
                                throw new UnsupportedOperationException("fill not supported");
                            }
                        };
                    }

                    @Override
                    public int getValueCardinality() {
                        throw new UnsupportedOperationException("value cardinality is unknown in incremental index");
                    }

                    @Override
                    public String lookupName(int id) {
                        String value = (String)((InputRow)in.get()).getDimension(dimension).get(id);
                        return extractionFn == null ? value : extractionFn.apply(value);
                    }

                    @Override
                    public int lookupId(String name) {
                        if (extractionFn != null) {
                            throw new UnsupportedOperationException("cannot perform lookup when applying an extraction function");
                        }
                        return ((InputRow)in.get()).getDimension(dimension).indexOf(name);
                    }
                };
            }
        };
    }

    public IncrementalIndex(IncrementalIndexSchema incrementalIndexSchema, boolean deserializeComplexMetrics, boolean reportParseExceptions, boolean sortFacts) {
        this.minTimestamp = incrementalIndexSchema.getMinTimestamp();
        this.gran = incrementalIndexSchema.getGran();
        this.metrics = incrementalIndexSchema.getMetrics();
        this.rowTransformers = new CopyOnWriteArrayList<Function<InputRow, InputRow>>();
        this.deserializeComplexMetrics = deserializeComplexMetrics;
        this.reportParseExceptions = reportParseExceptions;
        this.sortFacts = sortFacts;
        this.metadata = new Metadata().setAggregators(IncrementalIndex.getCombiningAggregators(this.metrics)).setQueryGranularity(this.gran);
        this.aggs = this.initAggs(this.metrics, this.rowSupplier, deserializeComplexMetrics);
        this.columnCapabilities = Maps.newHashMap();
        this.metricDescs = Maps.newLinkedHashMap();
        for (AggregatorFactory metric : this.metrics) {
            MetricDesc metricDesc = new MetricDesc(this.metricDescs.size(), metric);
            this.metricDescs.put(metricDesc.getName(), metricDesc);
            this.columnCapabilities.put(metricDesc.getName(), metricDesc.getCapabilities());
        }
        DimensionsSpec dimensionsSpec = incrementalIndexSchema.getDimensionsSpec();
        this.dimensionDescs = Maps.newLinkedHashMap();
        this.dimValues = Collections.synchronizedList(Lists.newArrayList());
        for (DimensionSchema dimSchema : dimensionsSpec.getDimensions()) {
            ColumnCapabilitiesImpl capabilities = new ColumnCapabilitiesImpl();
            ValueType type = TYPE_MAP.get(dimSchema.getValueType());
            capabilities.setType(type);
            if (dimSchema.getTypeName().equals("spatial")) {
                capabilities.setHasSpatialIndexes(true);
            } else {
                this.addNewDimension(dimSchema.getName(), capabilities);
            }
            this.columnCapabilities.put(dimSchema.getName(), capabilities);
        }
        List spatialDimensions = dimensionsSpec.getSpatialDimensions();
        if (!spatialDimensions.isEmpty()) {
            this.rowTransformers.add(new SpatialDimensionRowTransformer(spatialDimensions));
        }
    }

    private DimDim newDimDim(String dimension, ValueType type) {
        DimDim newDimDim;
        switch (type) {
            case LONG: {
                newDimDim = this.makeDimDim(dimension, this.getDimensionDescs());
                break;
            }
            case FLOAT: {
                newDimDim = this.makeDimDim(dimension, this.getDimensionDescs());
                break;
            }
            case STRING: {
                newDimDim = new NullValueConverterDimDim(this.makeDimDim(dimension, this.getDimensionDescs()));
                break;
            }
            default: {
                throw new IAE("Invalid column type: " + (Object)((Object)type), new Object[0]);
            }
        }
        return newDimDim;
    }

    protected abstract DimDim makeDimDim(String var1, Object var2);

    public abstract ConcurrentMap<TimeAndDims, Integer> getFacts();

    public abstract boolean canAppendRow();

    public abstract String getOutOfRowsReason();

    protected abstract AggregatorType[] initAggs(AggregatorFactory[] var1, Supplier<InputRow> var2, boolean var3);

    protected abstract Integer addToFacts(AggregatorFactory[] var1, boolean var2, boolean var3, InputRow var4, AtomicInteger var5, TimeAndDims var6, ThreadLocal<InputRow> var7, Supplier<InputRow> var8) throws IndexSizeExceededException;

    protected abstract AggregatorType[] getAggsForRow(int var1);

    protected abstract Object getAggVal(AggregatorType var1, int var2, int var3);

    protected abstract float getMetricFloatValue(int var1, int var2);

    protected abstract long getMetricLongValue(int var1, int var2);

    protected abstract Object getMetricObjectValue(int var1, int var2);

    @Override
    public void close() {
        this.dimValues.clear();
    }

    public InputRow formatRow(InputRow row) {
        for (Function<InputRow, InputRow> rowTransformer : this.rowTransformers) {
            row = (InputRow)rowTransformer.apply((Object)row);
        }
        if (row == null) {
            throw new IAE("Row is null? How can this be?!", new Object[0]);
        }
        return row;
    }

    private ValueType getTypeFromDimVal(Object dimVal) {
        List dimValList;
        Object singleVal = dimVal instanceof List ? ((dimValList = (List)dimVal).size() == 0 ? null : dimValList.get(0)) : dimVal;
        if (singleVal == null) {
            return null;
        }
        return TYPE_MAP.get(singleVal.getClass());
    }

    private List<Comparable> getRowDimensionAsComparables(InputRow row, String dimension, ValueType type) {
        List<Comparable> dimensionValues;
        Object dimVal = row.getRaw(dimension);
        Function transformer = VALUE_TRANSFORMS.get((Object)type);
        try {
            dimensionValues = dimVal == null ? Collections.emptyList() : (dimVal instanceof List ? Lists.transform((List)((List)dimVal), (Function)transformer) : Collections.singletonList((Comparable)transformer.apply(dimVal)));
        }
        catch (ParseException pe) {
            throw new ParseException(pe.getMessage() + dimension, new Object[0]);
        }
        return dimensionValues;
    }

    public Map<String, DimensionDesc> getDimensionDescs() {
        return this.dimensionDescs;
    }

    public int add(InputRow row) throws IndexSizeExceededException {
        TimeAndDims key = this.toTimeAndDims(row);
        int rv = this.addToFacts(this.metrics, this.deserializeComplexMetrics, this.reportParseExceptions, row, this.numEntries, key, this.in, this.rowSupplier);
        this.updateMaxIngestedTime(row.getTimestamp());
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    TimeAndDims toTimeAndDims(InputRow row) throws IndexSizeExceededException {
        int[][] dims;
        if ((row = this.formatRow(row)).getTimestampFromEpoch() < this.minTimestamp) {
            throw new IAE("Cannot add row[%s] because it is below the minTimestamp[%s]", new Object[]{row, new DateTime(this.minTimestamp)});
        }
        List rowDimensions = row.getDimensions();
        List overflow = null;
        ArrayList overflowTypes = null;
        Map<String, DimensionDesc> map = this.dimensionDescs;
        synchronized (map) {
            dims = new int[this.dimensionDescs.size()][];
            for (String dimension : rowDimensions) {
                ColumnCapabilitiesImpl capabilities;
                DimensionDesc desc = this.dimensionDescs.get(dimension);
                if (desc != null) {
                    capabilities = desc.getCapabilities();
                } else {
                    capabilities = this.columnCapabilities.get(dimension);
                    if (capabilities == null) {
                        capabilities = new ColumnCapabilitiesImpl();
                        capabilities.setType(ValueType.STRING);
                        this.columnCapabilities.put(dimension, capabilities);
                    }
                }
                ValueType valType = capabilities.getType();
                List<Comparable> dimensionValues = this.getRowDimensionAsComparables(row, dimension, valType);
                if (!capabilities.hasMultipleValues() && dimensionValues.size() > 1) {
                    capabilities.setHasMultipleValues(true);
                }
                if (desc == null) {
                    desc = this.addNewDimension(dimension, capabilities);
                    if (overflow == null) {
                        overflow = Lists.newArrayList();
                        overflowTypes = Lists.newArrayList();
                    }
                    overflow.add(this.getDimVals(desc.getValues(), dimensionValues));
                    overflowTypes.add(valType);
                    continue;
                }
                if (desc.getIndex() > dims.length || dims[desc.getIndex()] != null) {
                    throw new ISE("Dimension[%s] occurred more than once in InputRow", new Object[]{dimension});
                }
                dims[desc.getIndex()] = this.getDimVals(desc.getValues(), dimensionValues);
            }
        }
        if (overflow != null) {
            int[][] newDims = new int[dims.length + overflow.size()][];
            System.arraycopy(dims, 0, newDims, 0, dims.length);
            for (int i = 0; i < overflow.size(); ++i) {
                newDims[dims.length + i] = (int[])overflow.get(i);
            }
            dims = newDims;
        }
        long truncated = this.gran.truncate(row.getTimestampFromEpoch());
        return new TimeAndDims(Math.max(truncated, this.minTimestamp), dims);
    }

    private synchronized void updateMaxIngestedTime(DateTime eventTime) {
        if (this.maxIngestedEventTime == null || this.maxIngestedEventTime.isBefore((ReadableInstant)eventTime)) {
            this.maxIngestedEventTime = eventTime;
        }
    }

    public boolean isEmpty() {
        return this.numEntries.get() == 0;
    }

    public int size() {
        return this.numEntries.get();
    }

    private long getMinTimeMillis() {
        if (this.sortFacts) {
            return ((TimeAndDims)((ConcurrentNavigableMap)this.getFacts()).firstKey()).getTimestamp();
        }
        throw new UnsupportedOperationException("can't get minTime from unsorted facts data.");
    }

    private long getMaxTimeMillis() {
        if (this.sortFacts) {
            return ((TimeAndDims)((ConcurrentNavigableMap)this.getFacts()).lastKey()).getTimestamp();
        }
        throw new UnsupportedOperationException("can't get maxTime from unsorted facts data.");
    }

    private int[] getDimVals(DimDim dimLookup, List<Comparable> dimValues) {
        if (dimValues.size() == 0) {
            dimLookup.add(null);
            return null;
        }
        if (dimValues.size() == 1) {
            Comparable dimVal = dimValues.get(0);
            return new int[]{dimLookup.add(dimVal)};
        }
        Comparable[] dimArray = dimValues.toArray(new Comparable[dimValues.size()]);
        Arrays.sort(dimArray, this.ordering);
        int[] retVal = new int[dimArray.length];
        for (int i = 0; i < dimArray.length; ++i) {
            retVal[i] = dimLookup.add(dimArray[i]);
        }
        return retVal;
    }

    public AggregatorType[] getAggs() {
        return this.aggs;
    }

    public AggregatorFactory[] getMetricAggs() {
        return this.metrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getDimensionNames() {
        Map<String, DimensionDesc> map = this.dimensionDescs;
        synchronized (map) {
            return ImmutableList.copyOf(this.dimensionDescs.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DimensionDesc> getDimensions() {
        Map<String, DimensionDesc> map = this.dimensionDescs;
        synchronized (map) {
            return ImmutableList.copyOf(this.dimensionDescs.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DimensionDesc getDimension(String dimension) {
        Map<String, DimensionDesc> map = this.dimensionDescs;
        synchronized (map) {
            return this.dimensionDescs.get(dimension);
        }
    }

    public String getMetricType(String metric) {
        MetricDesc metricDesc = this.metricDescs.get(metric);
        return metricDesc != null ? metricDesc.getType() : null;
    }

    public Interval getInterval() {
        return new Interval(this.minTimestamp, this.isEmpty() ? this.minTimestamp : this.gran.next(this.getMaxTimeMillis()));
    }

    public DateTime getMinTime() {
        return this.isEmpty() ? null : new DateTime(this.getMinTimeMillis());
    }

    public DateTime getMaxTime() {
        return this.isEmpty() ? null : new DateTime(this.getMaxTimeMillis());
    }

    public DimDim getDimensionValues(String dimension) {
        DimensionDesc dimSpec = this.getDimension(dimension);
        return dimSpec == null ? null : dimSpec.getValues();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getDimensionOrder() {
        Map<String, DimensionDesc> map = this.dimensionDescs;
        synchronized (map) {
            return ImmutableList.copyOf(this.dimensionDescs.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadDimensionIterable(Iterable<String> oldDimensionOrder) {
        Map<String, DimensionDesc> map = this.dimensionDescs;
        synchronized (map) {
            if (!this.dimensionDescs.isEmpty()) {
                throw new ISE("Cannot load dimension order when existing order[%s] is not empty.", new Object[]{this.dimensionDescs.keySet()});
            }
            for (String dim : oldDimensionOrder) {
                if (this.dimensionDescs.get(dim) != null) continue;
                ColumnCapabilitiesImpl capabilities = new ColumnCapabilitiesImpl();
                capabilities.setType(ValueType.STRING);
                this.columnCapabilities.put(dim, capabilities);
                this.addNewDimension(dim, capabilities);
            }
        }
    }

    @GuardedBy(value="dimensionDescs")
    private DimensionDesc addNewDimension(String dim, ColumnCapabilitiesImpl capabilities) {
        DimensionDesc desc = new DimensionDesc(this.dimensionDescs.size(), dim, this.newDimDim(dim, capabilities.getType()), capabilities);
        if (this.dimValues.size() != desc.getIndex()) {
            throw new ISE("dimensionDescs and dimValues for [%s] is out of sync!!", new Object[]{dim});
        }
        this.dimensionDescs.put(dim, desc);
        this.dimValues.add(desc.getValues());
        return desc;
    }

    public List<String> getMetricNames() {
        return ImmutableList.copyOf(this.metricDescs.keySet());
    }

    public List<MetricDesc> getMetrics() {
        return ImmutableList.copyOf(this.metricDescs.values());
    }

    public Integer getMetricIndex(String metricName) {
        MetricDesc metSpec = this.metricDescs.get(metricName);
        return metSpec == null ? null : Integer.valueOf(metSpec.getIndex());
    }

    public ColumnCapabilities getCapabilities(String column) {
        return this.columnCapabilities.get(column);
    }

    public ConcurrentNavigableMap<TimeAndDims, Integer> getSubMap(TimeAndDims start, TimeAndDims end) {
        if (this.sortFacts) {
            return ((ConcurrentNavigableMap)this.getFacts()).subMap(start, end);
        }
        throw new UnsupportedOperationException("can't get subMap from unsorted facts data.");
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    private static AggregatorFactory[] getCombiningAggregators(AggregatorFactory[] aggregators) {
        AggregatorFactory[] combiningAggregators = new AggregatorFactory[aggregators.length];
        for (int i = 0; i < aggregators.length; ++i) {
            combiningAggregators[i] = aggregators[i].getCombiningFactory();
        }
        return combiningAggregators;
    }

    @Override
    public Iterator<Row> iterator() {
        return this.iterableWithPostAggregations(null, false).iterator();
    }

    public Iterable<Row> iterableWithPostAggregations(final List<PostAggregator> postAggs, final boolean descending) {
        return new Iterable<Row>(){

            @Override
            public Iterator<Row> iterator() {
                final List<DimensionDesc> dimensions = IncrementalIndex.this.getDimensions();
                Map<TimeAndDims, Integer> facts = null;
                facts = descending && IncrementalIndex.this.sortFacts ? ((ConcurrentNavigableMap)IncrementalIndex.this.getFacts()).descendingMap() : IncrementalIndex.this.getFacts();
                return Iterators.transform(facts.entrySet().iterator(), (Function)new Function<Map.Entry<TimeAndDims, Integer>, Row>(){

                    public Row apply(Map.Entry<TimeAndDims, Integer> input) {
                        TimeAndDims timeAndDims = input.getKey();
                        int rowOffset = input.getValue();
                        int[][] theDims = timeAndDims.getDims();
                        LinkedHashMap theVals = Maps.newLinkedHashMap();
                        for (int i = 0; i < theDims.length; ++i) {
                            int[] dim = theDims[i];
                            DimensionDesc dimensionDesc = (DimensionDesc)dimensions.get(i);
                            if (dimensionDesc == null) continue;
                            ValueType type = dimensionDesc.getCapabilities().getType();
                            String dimensionName = dimensionDesc.getName();
                            if (dim == null || dim.length == 0) {
                                theVals.put(dimensionName, null);
                                continue;
                            }
                            if (dim.length == 1) {
                                Object val = dimensionDesc.getValues().getValue(dim[0]);
                                if (type == ValueType.STRING) {
                                    val = Strings.nullToEmpty((String)((String)val));
                                }
                                theVals.put(dimensionName, val);
                                continue;
                            }
                            Comparable[] dimVals = new Comparable[dim.length];
                            for (int j = 0; j < dimVals.length; ++j) {
                                Object val = dimensionDesc.getValues().getValue(dim[j]);
                                if (type == ValueType.STRING) {
                                    val = Strings.nullToEmpty((String)((String)val));
                                }
                                dimVals[j] = val;
                            }
                            theVals.put(dimensionName, dimVals);
                        }
                        AggregatorType[] aggs = IncrementalIndex.this.getAggsForRow(rowOffset);
                        for (int i = 0; i < aggs.length; ++i) {
                            theVals.put(IncrementalIndex.this.metrics[i].getName(), IncrementalIndex.this.getAggVal(aggs[i], rowOffset, i));
                        }
                        if (postAggs != null) {
                            for (PostAggregator postAgg : postAggs) {
                                theVals.put(postAgg.getName(), postAgg.compute(theVals));
                            }
                        }
                        return new MapBasedRow(timeAndDims.getTimestamp(), (Map)theVals);
                    }
                });
            }
        };
    }

    public DateTime getMaxIngestedEventTime() {
        return this.maxIngestedEventTime;
    }

    protected final Comparator<TimeAndDims> dimsComparator() {
        return new TimeAndDimsComp(this.dimValues);
    }

    @VisibleForTesting
    static final class TimeAndDimsComp
    implements Comparator<TimeAndDims> {
        private final List<DimDim> dimValues;

        public TimeAndDimsComp(List<DimDim> dimValues) {
            this.dimValues = dimValues;
        }

        @Override
        public int compare(TimeAndDims lhs, TimeAndDims rhs) {
            int retVal = Longs.compare((long)lhs.timestamp, (long)rhs.timestamp);
            int numComparisons = Math.min(lhs.dims.length, rhs.dims.length);
            int index = 0;
            while (retVal == 0 && index < numComparisons) {
                int[] lhsIdxs = lhs.dims[index];
                int[] rhsIdxs = rhs.dims[index];
                if (lhsIdxs == null) {
                    if (rhsIdxs == null) {
                        ++index;
                        continue;
                    }
                    return -1;
                }
                if (rhsIdxs == null) {
                    return 1;
                }
                retVal = Ints.compare((int)lhsIdxs.length, (int)rhsIdxs.length);
                for (int valsIndex = 0; retVal == 0 && valsIndex < lhsIdxs.length; ++valsIndex) {
                    if (lhsIdxs[valsIndex] == rhsIdxs[valsIndex]) continue;
                    DimDim dimLookup = this.dimValues.get(index);
                    Object lhsVal = dimLookup.getValue(lhsIdxs[valsIndex]);
                    Object rhsVal = dimLookup.getValue(rhsIdxs[valsIndex]);
                    if (lhsVal != null && rhsVal != null) {
                        retVal = lhsVal.compareTo(rhsVal);
                        continue;
                    }
                    if (!(lhsVal == null ^ rhsVal == null)) continue;
                    retVal = lhsVal == null ? -1 : 1;
                }
                ++index;
            }
            if (retVal == 0) {
                return Ints.compare((int)lhs.dims.length, (int)rhs.dims.length);
            }
            return retVal;
        }
    }

    static final class TimeAndDims {
        private final long timestamp;
        private final int[][] dims;

        TimeAndDims(long timestamp, int[][] dims) {
            this.timestamp = timestamp;
            this.dims = dims;
        }

        long getTimestamp() {
            return this.timestamp;
        }

        int[][] getDims() {
            return this.dims;
        }

        public String toString() {
            return "TimeAndDims{timestamp=" + new DateTime(this.timestamp) + ", dims=" + Lists.transform(Arrays.asList(this.dims), (Function)new Function<int[], Object>(){

                public Object apply(@Nullable int[] input) {
                    if (input == null || input.length == 0) {
                        return Arrays.asList("null");
                    }
                    return Arrays.asList(new int[][]{input});
                }
            }) + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TimeAndDims that = (TimeAndDims)o;
            if (this.timestamp != that.timestamp) {
                return false;
            }
            if (this.dims.length != that.dims.length) {
                return false;
            }
            for (int i = 0; i < this.dims.length; ++i) {
                if (Arrays.equals(this.dims[i], that.dims[i])) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int hash = (int)this.timestamp;
            for (int i = 0; i < this.dims.length; ++i) {
                hash = 31 * hash + Arrays.hashCode(this.dims[i]);
            }
            return hash;
        }
    }

    private static class NullValueConverterDimLookup
    implements SortedDimLookup<String> {
        private final SortedDimLookup<String> delegate;

        public NullValueConverterDimLookup(SortedDimLookup delegate) {
            this.delegate = delegate;
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public int getUnsortedIdFromSortedId(int index) {
            return this.delegate.getUnsortedIdFromSortedId(index);
        }

        @Override
        public int getSortedIdFromUnsortedId(int id) {
            return this.delegate.getSortedIdFromUnsortedId(id);
        }

        @Override
        public String getValueFromSortedId(int index) {
            return Strings.emptyToNull((String)this.delegate.getValueFromSortedId(index));
        }
    }

    static class NullValueConverterDimDim
    implements DimDim<String> {
        private final DimDim<String> delegate;

        NullValueConverterDimDim(DimDim delegate) {
            this.delegate = delegate;
        }

        @Override
        public int getId(String value) {
            return this.delegate.getId(Strings.nullToEmpty((String)value));
        }

        @Override
        public String getValue(int id) {
            return Strings.emptyToNull((String)this.delegate.getValue(id));
        }

        @Override
        public boolean contains(String value) {
            return this.delegate.contains(Strings.nullToEmpty((String)value));
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public String getMinValue() {
            return Strings.nullToEmpty((String)this.delegate.getMinValue());
        }

        @Override
        public String getMaxValue() {
            return Strings.nullToEmpty((String)this.delegate.getMaxValue());
        }

        @Override
        public int add(String value) {
            return this.delegate.add(Strings.nullToEmpty((String)value));
        }

        @Override
        public SortedDimLookup sort() {
            return new NullValueConverterDimLookup(this.delegate.sort());
        }
    }

    static interface SortedDimLookup<T extends Comparable<? super T>> {
        public int size();

        public int getSortedIdFromUnsortedId(int var1);

        public int getUnsortedIdFromSortedId(int var1);

        public T getValueFromSortedId(int var1);
    }

    static interface DimDim<T extends Comparable<? super T>> {
        public int getId(T var1);

        public T getValue(int var1);

        public boolean contains(T var1);

        public int size();

        public T getMinValue();

        public T getMaxValue();

        public int add(T var1);

        public SortedDimLookup sort();
    }

    public static final class MetricDesc {
        private final int index;
        private final String name;
        private final String type;
        private final ColumnCapabilitiesImpl capabilities;

        public MetricDesc(int index, AggregatorFactory factory) {
            this.index = index;
            this.name = factory.getName();
            this.type = factory.getTypeName();
            this.capabilities = new ColumnCapabilitiesImpl();
            if (this.type.equalsIgnoreCase("float")) {
                this.capabilities.setType(ValueType.FLOAT);
            } else if (this.type.equalsIgnoreCase("long")) {
                this.capabilities.setType(ValueType.LONG);
            } else {
                this.capabilities.setType(ValueType.COMPLEX);
            }
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public ColumnCapabilitiesImpl getCapabilities() {
            return this.capabilities;
        }
    }

    public static final class DimensionDesc {
        private final int index;
        private final String name;
        private final DimDim values;
        private final ColumnCapabilitiesImpl capabilities;

        public DimensionDesc(int index, String name, DimDim values, ColumnCapabilitiesImpl capabilities) {
            this.index = index;
            this.name = name;
            this.values = values;
            this.capabilities = capabilities;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public DimDim getValues() {
            return this.values;
        }

        public ColumnCapabilitiesImpl getCapabilities() {
            return this.capabilities;
        }
    }
}

