/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.serde;

import com.google.common.base.Supplier;
import io.druid.segment.column.DictionaryEncodedColumn;
import io.druid.segment.column.SimpleDictionaryEncodedColumn;
import io.druid.segment.data.CachingIndexed;
import io.druid.segment.data.GenericIndexed;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.data.IndexedMultivalue;

public class DictionaryEncodedColumnSupplier
implements Supplier<DictionaryEncodedColumn> {
    private final GenericIndexed<String> dictionary;
    private final Supplier<IndexedInts> singleValuedColumn;
    private final Supplier<IndexedMultivalue<IndexedInts>> multiValuedColumn;
    private final int lookupCacheSize;

    public DictionaryEncodedColumnSupplier(GenericIndexed<String> dictionary, Supplier<IndexedInts> singleValuedColumn, Supplier<IndexedMultivalue<IndexedInts>> multiValuedColumn, int lookupCacheSize) {
        this.dictionary = dictionary;
        this.singleValuedColumn = singleValuedColumn;
        this.multiValuedColumn = multiValuedColumn;
        this.lookupCacheSize = lookupCacheSize;
    }

    public DictionaryEncodedColumn get() {
        return new SimpleDictionaryEncodedColumn(this.singleValuedColumn != null ? (IndexedInts)this.singleValuedColumn.get() : null, this.multiValuedColumn != null ? (IndexedMultivalue)this.multiValuedColumn.get() : null, new CachingIndexed<String>(this.dictionary, this.lookupCacheSize));
    }
}

