/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class TaskLocation {
    private static final TaskLocation UNKNOWN = new TaskLocation(null, -1);
    private final String host;
    private final int port;

    public static TaskLocation create(String host, int port) {
        return new TaskLocation(host, port);
    }

    public static TaskLocation unknown() {
        return UNKNOWN;
    }

    @JsonCreator
    public TaskLocation(@JsonProperty(value="host") String host, @JsonProperty(value="port") int port) {
        this.host = host;
        this.port = port;
    }

    @JsonProperty
    public String getHost() {
        return this.host;
    }

    @JsonProperty
    public int getPort() {
        return this.port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskLocation that = (TaskLocation)o;
        return this.port == that.port && Objects.equals(this.host, that.host);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port);
    }

    public String toString() {
        return "TaskLocation{host='" + this.host + '\'' + ", port=" + this.port + '}';
    }
}

