/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.actions;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.metamx.common.ISE;
import com.metamx.emitter.service.ServiceEmitter;
import io.druid.indexing.common.TaskLock;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import io.druid.indexing.overlord.TaskLockbox;
import io.druid.timeline.DataSegment;
import java.util.List;
import java.util.Set;
import org.joda.time.ReadableInterval;

public class TaskActionToolbox {
    private final TaskLockbox taskLockbox;
    private final IndexerMetadataStorageCoordinator indexerMetadataStorageCoordinator;
    private final ServiceEmitter emitter;

    @Inject
    public TaskActionToolbox(TaskLockbox taskLockbox, IndexerMetadataStorageCoordinator indexerMetadataStorageCoordinator, ServiceEmitter emitter) {
        this.taskLockbox = taskLockbox;
        this.indexerMetadataStorageCoordinator = indexerMetadataStorageCoordinator;
        this.emitter = emitter;
    }

    public TaskLockbox getTaskLockbox() {
        return this.taskLockbox;
    }

    public IndexerMetadataStorageCoordinator getIndexerMetadataStorageCoordinator() {
        return this.indexerMetadataStorageCoordinator;
    }

    public ServiceEmitter getEmitter() {
        return this.emitter;
    }

    public void verifyTaskLocks(Task task, Set<DataSegment> segments) {
        if (!this.taskLockCoversSegments(task, segments)) {
            throw new ISE("Segments not covered by locks for task: %s", new Object[]{task.getId()});
        }
    }

    public boolean taskLockCoversSegments(Task task, Set<DataSegment> segments) {
        List<TaskLock> taskLocks = this.getTaskLockbox().findLocksForTask(task);
        for (final DataSegment segment : segments) {
            boolean ok = Iterables.any(taskLocks, (Predicate)new Predicate<TaskLock>(){

                public boolean apply(TaskLock taskLock) {
                    return taskLock.getDataSource().equals(segment.getDataSource()) && taskLock.getInterval().contains((ReadableInterval)segment.getInterval()) && taskLock.getVersion().compareTo(segment.getVersion()) >= 0;
                }
            });
            if (ok) continue;
            return false;
        }
        return true;
    }
}

