/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import io.druid.indexing.common.TaskToolbox;
import io.druid.indexing.common.task.MergeTaskBase;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.segment.IndexSpec;
import io.druid.segment.IndexableAdapter;
import io.druid.segment.QueryableIndexIndexableAdapter;
import io.druid.segment.Rowboat;
import io.druid.segment.RowboatFilteringIndexAdapter;
import io.druid.timeline.DataSegment;
import io.druid.timeline.TimelineObjectHolder;
import io.druid.timeline.VersionedIntervalTimeline;
import io.druid.timeline.partition.PartitionChunk;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.joda.time.Interval;

public class AppendTask
extends MergeTaskBase {
    private final IndexSpec indexSpec;
    private final List<AggregatorFactory> aggregators;

    @JsonCreator
    public AppendTask(@JsonProperty(value="id") String id, @JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="segments") List<DataSegment> segments, @JsonProperty(value="aggregations") List<AggregatorFactory> aggregators, @JsonProperty(value="indexSpec") IndexSpec indexSpec, @JsonProperty(value="context") Map<String, Object> context) {
        super(id, dataSource, segments, context);
        this.indexSpec = indexSpec == null ? new IndexSpec() : indexSpec;
        this.aggregators = aggregators;
    }

    @Override
    public File merge(TaskToolbox toolbox, final Map<DataSegment, File> segments, File outDir) throws Exception {
        VersionedIntervalTimeline timeline = new VersionedIntervalTimeline((Comparator)Ordering.natural().nullsFirst());
        for (DataSegment segment : segments.keySet()) {
            timeline.add(segment.getInterval(), (Object)segment.getVersion(), segment.getShardSpec().createChunk((Object)segment));
        }
        Iterable segmentsToMerge = Iterables.concat((Iterable)Iterables.transform((Iterable)timeline.lookup(new Interval((Object)"1000-01-01/3000-01-01")), (Function)new Function<TimelineObjectHolder<String, DataSegment>, Iterable<SegmentToMergeHolder>>(){

            public Iterable<SegmentToMergeHolder> apply(final TimelineObjectHolder<String, DataSegment> input) {
                return Iterables.transform((Iterable)input.getObject(), (Function)new Function<PartitionChunk<DataSegment>, SegmentToMergeHolder>(){

                    @Nullable
                    public SegmentToMergeHolder apply(PartitionChunk<DataSegment> chunkInput) {
                        DataSegment segment = (DataSegment)chunkInput.getObject();
                        return new SegmentToMergeHolder(segment, input.getInterval(), (File)Preconditions.checkNotNull(segments.get(segment), (String)"File for segment %s", (Object[])new Object[]{segment.getIdentifier()}));
                    }
                });
            }
        }));
        ArrayList adapters = Lists.newArrayList();
        for (final SegmentToMergeHolder holder : segmentsToMerge) {
            adapters.add(new RowboatFilteringIndexAdapter((IndexableAdapter)new QueryableIndexIndexableAdapter(toolbox.getIndexIO().loadIndex(holder.getFile())), (Predicate)new Predicate<Rowboat>(){

                public boolean apply(Rowboat input) {
                    return holder.getInterval().contains(input.getTimestamp());
                }
            }));
        }
        return toolbox.getIndexMerger().append((List)adapters, this.aggregators == null ? null : this.aggregators.toArray(new AggregatorFactory[this.aggregators.size()]), outDir, this.indexSpec);
    }

    @Override
    public String getType() {
        return "append";
    }

    @JsonProperty(value="aggregations")
    public List<AggregatorFactory> getAggregators() {
        return this.aggregators;
    }

    private static class SegmentToMergeHolder {
        private final DataSegment segment;
        private final Interval interval;
        private final File file;

        private SegmentToMergeHolder(DataSegment segment, Interval interval, File file) {
            this.segment = segment;
            this.interval = interval;
            this.file = file;
        }

        public DataSegment getSegment() {
            return this.segment;
        }

        public Interval getInterval() {
            return this.interval;
        }

        public File getFile() {
            return this.file;
        }
    }
}

