/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.metamx.common.UOE;
import com.metamx.common.logger.Logger;
import io.druid.indexer.updater.HadoopConverterJob;
import io.druid.indexer.updater.HadoopDruidConverterConfig;
import io.druid.indexing.common.TaskStatus;
import io.druid.indexing.common.TaskToolbox;
import io.druid.indexing.common.actions.TaskActionClient;
import io.druid.indexing.common.task.ConvertSegmentTask;
import io.druid.indexing.common.task.HadoopTask;
import io.druid.indexing.common.task.Task;
import io.druid.segment.IndexSpec;
import io.druid.timeline.DataSegment;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.joda.time.Interval;

public class HadoopConverterTask
extends ConvertSegmentTask {
    private static final String TYPE = "hadoop_convert_segment";
    private static final Logger log = new Logger(HadoopConverterTask.class);
    private final List<String> hadoopDependencyCoordinates;
    private final URI distributedSuccessCache;
    private final String jobPriority;
    private final String segmentOutputPath;
    private final String classpathPrefix;

    @JsonCreator
    public HadoopConverterTask(@JsonProperty(value="id") String id, @JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="interval") Interval interval, @JsonProperty(value="indexSpec") IndexSpec indexSpec, @JsonProperty(value="force") boolean force, @JsonProperty(value="validate") Boolean validate, @JsonProperty(value="hadoopDependencyCoordinates") List<String> hadoopDependencyCoordinates, @JsonProperty(value="distributedSuccessCache") URI distributedSuccessCache, @JsonProperty(value="jobPriority") String jobPriority, @JsonProperty(value="segmentOutputPath") String segmentOutputPath, @JsonProperty(value="classpathPrefix") String classpathPrefix, @JsonProperty(value="context") Map<String, Object> context) {
        super(HadoopConverterTask.makeId(id, TYPE, (String)Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource"), (Interval)Preconditions.checkNotNull((Object)interval, (Object)"interval")), dataSource, interval, null, indexSpec, force, validate == null ? true : validate, context);
        this.hadoopDependencyCoordinates = hadoopDependencyCoordinates;
        this.distributedSuccessCache = (URI)Preconditions.checkNotNull((Object)distributedSuccessCache, (Object)"distributedSuccessCache");
        this.segmentOutputPath = (String)Preconditions.checkNotNull((Object)segmentOutputPath, (Object)"segmentOutputPath");
        this.jobPriority = jobPriority;
        this.classpathPrefix = classpathPrefix;
    }

    @JsonProperty
    public List<String> getHadoopDependencyCoordinates() {
        return this.hadoopDependencyCoordinates;
    }

    @JsonProperty
    public URI getDistributedSuccessCache() {
        return this.distributedSuccessCache;
    }

    @JsonProperty
    public String getJobPriority() {
        return this.jobPriority;
    }

    @JsonProperty
    public String getSegmentOutputPath() {
        return this.segmentOutputPath;
    }

    @Override
    @JsonProperty
    public String getClasspathPrefix() {
        return this.classpathPrefix;
    }

    @Override
    protected Iterable<Task> generateSubTasks(String groupId, Iterable<DataSegment> segments, IndexSpec indexSpec, boolean force, boolean validate, Map<String, Object> context) {
        return Collections.singleton(new ConverterSubTask((List<DataSegment>)ImmutableList.copyOf(segments), this, context));
    }

    @Override
    @JsonIgnore
    public DataSegment getSegment() {
        throw new UOE("Sub-less data segment not supported for hadoop converter task. Specify interval and datasource instead", new Object[0]);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public static class JobInvoker {
        public static String runTask(String[] input) {
            HadoopDruidConverterConfig config;
            try {
                config = (HadoopDruidConverterConfig)HadoopDruidConverterConfig.jsonMapper.readValue(input[0], HadoopDruidConverterConfig.class);
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
            HadoopConverterJob hadoopConverterJob = new HadoopConverterJob(config);
            try {
                List result = hadoopConverterJob.run();
                return result == null ? null : HadoopDruidConverterConfig.jsonMapper.writeValueAsString((Object)result);
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    public static class ConverterSubTask
    extends HadoopTask {
        private final List<DataSegment> segments;
        private final HadoopConverterTask parent;

        @JsonCreator
        public ConverterSubTask(@JsonProperty(value="segments") List<DataSegment> segments, @JsonProperty(value="parent") HadoopConverterTask parent, @JsonProperty(value="context") Map<String, Object> context) {
            super(ConverterSubTask.joinId(((HadoopConverterTask)Preconditions.checkNotNull((Object)parent, (Object)"parent")).getGroupId(), "sub", parent.getInterval().getStart(), parent.getInterval().getEnd()), parent.getDataSource(), parent.getHadoopDependencyCoordinates(), context);
            this.segments = segments;
            this.parent = parent;
        }

        @JsonProperty
        public List<DataSegment> getSegments() {
            return this.segments;
        }

        @JsonProperty
        public HadoopConverterTask getParent() {
            return this.parent;
        }

        @Override
        public String getType() {
            return "hadoop_convert_segment_sub";
        }

        @Override
        public boolean isReady(TaskActionClient taskActionClient) throws Exception {
            return true;
        }

        @Override
        public TaskStatus run(TaskToolbox toolbox) throws Exception {
            HashMap<String, String> hadoopProperties = new HashMap<String, String>();
            Properties properties = (Properties)injector.getInstance(Properties.class);
            for (String name : properties.stringPropertyNames()) {
                if (!name.startsWith("hadoop.")) continue;
                hadoopProperties.put(name.substring("hadoop.".length()), properties.getProperty(name));
            }
            ClassLoader loader = this.buildClassLoader(toolbox);
            HadoopDruidConverterConfig config = new HadoopDruidConverterConfig(this.getDataSource(), this.parent.getInterval(), this.parent.getIndexSpec(), this.segments, Boolean.valueOf(this.parent.isValidate()), this.parent.getDistributedSuccessCache(), hadoopProperties, this.parent.getJobPriority(), this.parent.getSegmentOutputPath());
            String finishedSegmentString = (String)ConverterSubTask.invokeForeignLoader("io.druid.indexing.common.task.HadoopConverterTask$JobInvoker", new String[]{HadoopDruidConverterConfig.jsonMapper.writeValueAsString((Object)config)}, loader);
            if (finishedSegmentString == null) {
                return TaskStatus.failure(this.getId());
            }
            List finishedSegments = (List)HadoopDruidConverterConfig.jsonMapper.readValue(finishedSegmentString, (TypeReference)new TypeReference<List<DataSegment>>(){});
            log.debug("Found new segments %s", new Object[]{Arrays.toString(finishedSegments.toArray())});
            toolbox.publishSegments(finishedSegments);
            return this.success();
        }
    }
}

