/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.metamx.common.logger.Logger;
import io.druid.common.utils.JodaUtils;
import io.druid.indexer.HadoopDruidDetermineConfigurationJob;
import io.druid.indexer.HadoopDruidIndexerConfig;
import io.druid.indexer.HadoopDruidIndexerJob;
import io.druid.indexer.HadoopIngestionSpec;
import io.druid.indexer.MetadataStorageUpdaterJobHandler;
import io.druid.indexer.path.UsedSegmentLister;
import io.druid.indexing.common.TaskLock;
import io.druid.indexing.common.TaskStatus;
import io.druid.indexing.common.TaskToolbox;
import io.druid.indexing.common.actions.LockAcquireAction;
import io.druid.indexing.common.actions.LockTryAcquireAction;
import io.druid.indexing.common.actions.TaskActionClient;
import io.druid.indexing.common.task.HadoopTask;
import io.druid.indexing.hadoop.OverlordActionBasedUsedSegmentLister;
import io.druid.timeline.DataSegment;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class HadoopIndexTask
extends HadoopTask {
    private static final Logger log = new Logger(HadoopIndexTask.class);
    @JsonIgnore
    private HadoopIngestionSpec spec;
    @JsonIgnore
    private final String classpathPrefix;
    @JsonIgnore
    private final ObjectMapper jsonMapper;

    private static String getTheDataSource(HadoopIngestionSpec spec) {
        return spec.getDataSchema().getDataSource();
    }

    @JsonCreator
    public HadoopIndexTask(@JsonProperty(value="id") String id, @JsonProperty(value="spec") HadoopIngestionSpec spec, @JsonProperty(value="hadoopCoordinates") String hadoopCoordinates, @JsonProperty(value="hadoopDependencyCoordinates") List<String> hadoopDependencyCoordinates, @JsonProperty(value="classpathPrefix") String classpathPrefix, @JacksonInject ObjectMapper jsonMapper, @JsonProperty(value="context") Map<String, Object> context) {
        super(id != null ? id : String.format("index_hadoop_%s_%s", HadoopIndexTask.getTheDataSource(spec), new DateTime()), HadoopIndexTask.getTheDataSource(spec), (List<String>)(hadoopDependencyCoordinates == null ? (hadoopCoordinates == null ? null : ImmutableList.of((Object)hadoopCoordinates)) : hadoopDependencyCoordinates), context);
        this.spec = spec;
        Preconditions.checkArgument((this.spec.getIOConfig().getSegmentOutputPath() == null ? 1 : 0) != 0, (Object)"segmentOutputPath must be absent");
        Preconditions.checkArgument((this.spec.getTuningConfig().getWorkingPath() == null ? 1 : 0) != 0, (Object)"workingPath must be absent");
        Preconditions.checkArgument((this.spec.getIOConfig().getMetadataUpdateSpec() == null ? 1 : 0) != 0, (Object)"metadataUpdateSpec must be absent");
        this.classpathPrefix = classpathPrefix;
        this.jsonMapper = (ObjectMapper)Preconditions.checkNotNull((Object)jsonMapper, (Object)"null ObjectMappper");
    }

    @Override
    public String getType() {
        return "index_hadoop";
    }

    @Override
    public boolean isReady(TaskActionClient taskActionClient) throws Exception {
        Optional intervals = this.spec.getDataSchema().getGranularitySpec().bucketIntervals();
        if (intervals.isPresent()) {
            Interval interval = JodaUtils.umbrellaInterval((Iterable)JodaUtils.condenseIntervals((Iterable)((Iterable)intervals.get())));
            return taskActionClient.submit(new LockTryAcquireAction(interval)) != null;
        }
        return true;
    }

    @JsonProperty(value="spec")
    public HadoopIngestionSpec getSpec() {
        return this.spec;
    }

    @Override
    @JsonProperty
    public List<String> getHadoopDependencyCoordinates() {
        return super.getHadoopDependencyCoordinates();
    }

    @Override
    @JsonProperty
    public String getClasspathPrefix() {
        return this.classpathPrefix;
    }

    @Override
    public TaskStatus run(TaskToolbox toolbox) throws Exception {
        String version;
        ClassLoader loader = this.buildClassLoader(toolbox);
        boolean determineIntervals = !this.spec.getDataSchema().getGranularitySpec().bucketIntervals().isPresent();
        this.spec = HadoopIngestionSpec.updateSegmentListIfDatasourcePathSpecIsUsed((HadoopIngestionSpec)this.spec, (ObjectMapper)this.jsonMapper, (UsedSegmentLister)new OverlordActionBasedUsedSegmentLister(toolbox));
        String config = (String)HadoopIndexTask.invokeForeignLoader("io.druid.indexing.common.task.HadoopIndexTask$HadoopDetermineConfigInnerProcessing", new String[]{toolbox.getObjectMapper().writeValueAsString((Object)this.spec), toolbox.getConfig().getHadoopWorkingPath(), toolbox.getSegmentPusher().getPathForHadoop(this.getDataSource())}, loader);
        HadoopIngestionSpec indexerSchema = (HadoopIngestionSpec)toolbox.getObjectMapper().readValue(config, HadoopIngestionSpec.class);
        if (determineIntervals) {
            Interval interval = JodaUtils.umbrellaInterval((Iterable)JodaUtils.condenseIntervals((Iterable)((Iterable)indexerSchema.getDataSchema().getGranularitySpec().bucketIntervals().get())));
            TaskLock lock = toolbox.getTaskActionClient().submit(new LockAcquireAction(interval));
            version = lock.getVersion();
        } else {
            Iterable<TaskLock> locks = this.getTaskLocks(toolbox);
            TaskLock myLock = (TaskLock)Iterables.getOnlyElement(locks);
            version = myLock.getVersion();
        }
        log.info("Setting version to: %s", new Object[]{version});
        String segments = (String)HadoopIndexTask.invokeForeignLoader("io.druid.indexing.common.task.HadoopIndexTask$HadoopIndexGeneratorInnerProcessing", new String[]{toolbox.getObjectMapper().writeValueAsString((Object)indexerSchema), version}, loader);
        if (segments != null) {
            List publishedSegments = (List)toolbox.getObjectMapper().readValue(segments, (TypeReference)new TypeReference<List<DataSegment>>(){});
            toolbox.publishSegments(publishedSegments);
            return TaskStatus.success(this.getId());
        }
        return TaskStatus.failure(this.getId());
    }

    public static class HadoopDetermineConfigInnerProcessing {
        public static String runTask(String[] args) throws Exception {
            String schema = args[0];
            String workingPath = args[1];
            String segmentOutputPath = args[2];
            HadoopIngestionSpec theSchema = (HadoopIngestionSpec)HadoopDruidIndexerConfig.JSON_MAPPER.readValue(schema, HadoopIngestionSpec.class);
            HadoopDruidIndexerConfig config = HadoopDruidIndexerConfig.fromSpec((HadoopIngestionSpec)theSchema.withIOConfig(theSchema.getIOConfig().withSegmentOutputPath(segmentOutputPath)).withTuningConfig(theSchema.getTuningConfig().withWorkingPath(workingPath)));
            HadoopDruidDetermineConfigurationJob job = new HadoopDruidDetermineConfigurationJob(config);
            log.info("Starting a hadoop determine configuration job...", new Object[0]);
            if (job.run()) {
                return HadoopDruidIndexerConfig.JSON_MAPPER.writeValueAsString((Object)config.getSchema());
            }
            return null;
        }
    }

    public static class HadoopIndexGeneratorInnerProcessing {
        public static String runTask(String[] args) throws Exception {
            String schema = args[0];
            String version = args[1];
            HadoopIngestionSpec theSchema = (HadoopIngestionSpec)HadoopDruidIndexerConfig.JSON_MAPPER.readValue(schema, HadoopIngestionSpec.class);
            HadoopDruidIndexerConfig config = HadoopDruidIndexerConfig.fromSpec((HadoopIngestionSpec)theSchema.withTuningConfig(theSchema.getTuningConfig().withVersion(version)));
            MetadataStorageUpdaterJobHandler maybeHandler = config.isUpdaterJobSpecSet() ? (MetadataStorageUpdaterJobHandler)HadoopTask.injector.getInstance(MetadataStorageUpdaterJobHandler.class) : null;
            HadoopDruidIndexerJob job = new HadoopDruidIndexerJob(config, maybeHandler);
            log.info("Starting a hadoop index generator job...", new Object[0]);
            if (job.run()) {
                return HadoopDruidIndexerConfig.JSON_MAPPER.writeValueAsString((Object)job.getPublishedSegments());
            }
            return null;
        }
    }
}

