/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.metamx.common.ISE;
import com.metamx.common.logger.Logger;
import io.druid.data.input.FirehoseFactory;
import io.druid.indexing.common.TaskStatus;
import io.druid.indexing.common.TaskToolbox;
import io.druid.indexing.common.actions.TaskActionClient;
import io.druid.indexing.common.task.AbstractTask;
import java.util.Map;
import java.util.UUID;
import org.joda.time.DateTime;

public class NoopTask
extends AbstractTask {
    private static final Logger log = new Logger(NoopTask.class);
    private static final int defaultRunTime = 2500;
    private static final int defaultIsReadyTime = 0;
    private static final IsReadyResult defaultIsReadyResult = IsReadyResult.YES;
    @JsonIgnore
    private final long runTime;
    @JsonIgnore
    private final long isReadyTime;
    @JsonIgnore
    private final IsReadyResult isReadyResult;
    @JsonIgnore
    private final FirehoseFactory firehoseFactory;

    @JsonCreator
    public NoopTask(@JsonProperty(value="id") String id, @JsonProperty(value="runTime") long runTime, @JsonProperty(value="isReadyTime") long isReadyTime, @JsonProperty(value="isReadyResult") String isReadyResult, @JsonProperty(value="firehose") FirehoseFactory firehoseFactory, @JsonProperty(value="context") Map<String, Object> context) {
        super(id == null ? String.format("noop_%s_%s", new DateTime(), UUID.randomUUID().toString()) : id, "none", context);
        this.runTime = runTime == 0L ? 2500L : runTime;
        this.isReadyTime = isReadyTime == 0L ? 0L : isReadyTime;
        this.isReadyResult = isReadyResult == null ? defaultIsReadyResult : IsReadyResult.valueOf(isReadyResult.toUpperCase());
        this.firehoseFactory = firehoseFactory;
    }

    @Override
    public String getType() {
        return "noop";
    }

    @JsonProperty
    public long getRunTime() {
        return this.runTime;
    }

    @JsonProperty
    public long getIsReadyTime() {
        return this.isReadyTime;
    }

    @JsonProperty
    public IsReadyResult getIsReadyResult() {
        return this.isReadyResult;
    }

    @JsonProperty(value="firehose")
    public FirehoseFactory getFirehoseFactory() {
        return this.firehoseFactory;
    }

    @Override
    public boolean isReady(TaskActionClient taskActionClient) throws Exception {
        switch (this.isReadyResult) {
            case YES: {
                return true;
            }
            case NO: {
                return false;
            }
            case EXCEPTION: {
                throw new ISE("Not ready. Never will be ready. Go away!", new Object[0]);
            }
        }
        throw new AssertionError((Object)"#notreached");
    }

    @Override
    public TaskStatus run(TaskToolbox toolbox) throws Exception {
        if (this.firehoseFactory != null) {
            log.info("Connecting firehose", new Object[0]);
            this.firehoseFactory.connect(null);
        }
        log.info("Running noop task[%s]", new Object[]{this.getId()});
        log.info("Sleeping for %,d millis.", new Object[]{this.runTime});
        Thread.sleep(this.runTime);
        log.info("Woke up!", new Object[0]);
        return TaskStatus.success(this.getId());
    }

    public static NoopTask create() {
        return new NoopTask(null, 0L, 0L, null, null, null);
    }

    static enum IsReadyResult {
        YES,
        NO,
        EXCEPTION;

    }
}

