/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.metamx.common.guava.CloseQuietly;
import com.metamx.emitter.EmittingLogger;
import com.metamx.metrics.Monitor;
import io.druid.data.input.Committer;
import io.druid.data.input.Firehose;
import io.druid.data.input.FirehoseFactory;
import io.druid.indexing.common.TaskLock;
import io.druid.indexing.common.TaskStatus;
import io.druid.indexing.common.TaskToolbox;
import io.druid.indexing.common.actions.LockAcquireAction;
import io.druid.indexing.common.actions.LockReleaseAction;
import io.druid.indexing.common.actions.TaskActionClient;
import io.druid.indexing.common.task.AbstractTask;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.common.task.TaskResource;
import io.druid.query.FinalizeResultsQueryRunner;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerFactory;
import io.druid.query.QueryRunnerFactoryConglomerate;
import io.druid.query.QueryToolChest;
import io.druid.segment.realtime.FireDepartment;
import io.druid.segment.realtime.FireDepartmentMetrics;
import io.druid.segment.realtime.RealtimeMetricsMonitor;
import io.druid.segment.realtime.SegmentPublisher;
import io.druid.segment.realtime.firehose.ClippedFirehoseFactory;
import io.druid.segment.realtime.firehose.EventReceiverFirehoseFactory;
import io.druid.segment.realtime.firehose.TimedShutoffFirehoseFactory;
import io.druid.segment.realtime.plumber.Committers;
import io.druid.segment.realtime.plumber.Plumber;
import io.druid.segment.realtime.plumber.Plumbers;
import io.druid.segment.realtime.plumber.RealtimePlumberSchool;
import io.druid.segment.realtime.plumber.VersioningPolicy;
import io.druid.server.coordination.DataSegmentAnnouncer;
import io.druid.timeline.DataSegment;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class RealtimeIndexTask
extends AbstractTask {
    private static final EmittingLogger log = new EmittingLogger(RealtimeIndexTask.class);
    private static final Random random = new Random();
    @JsonIgnore
    private final FireDepartment spec;
    @JsonIgnore
    private volatile Plumber plumber = null;
    @JsonIgnore
    private volatile Firehose firehose = null;
    @JsonIgnore
    private volatile FireDepartmentMetrics metrics = null;
    @JsonIgnore
    private volatile boolean gracefullyStopped = false;
    @JsonIgnore
    private volatile boolean finishingJob = false;
    @JsonIgnore
    private volatile Thread runThread = null;
    @JsonIgnore
    private volatile QueryRunnerFactoryConglomerate queryRunnerFactoryConglomerate = null;

    private static String makeTaskId(FireDepartment fireDepartment) {
        return RealtimeIndexTask.makeTaskId(fireDepartment.getDataSchema().getDataSource(), fireDepartment.getTuningConfig().getShardSpec().getPartitionNum(), new DateTime(), random.nextInt());
    }

    static String makeTaskId(String dataSource, int partitionNumber, DateTime timestamp, int randomBits) {
        StringBuilder suffix = new StringBuilder(8);
        for (int i = 0; i < 8; ++i) {
            suffix.append((char)(97 + (randomBits >>> i * 4 & 0xF)));
        }
        return String.format("index_realtime_%s_%d_%s_%s", dataSource, partitionNumber, timestamp, suffix);
    }

    private static String makeDatasource(FireDepartment fireDepartment) {
        return fireDepartment.getDataSchema().getDataSource();
    }

    @JsonCreator
    public RealtimeIndexTask(@JsonProperty(value="id") String id, @JsonProperty(value="resource") TaskResource taskResource, @JsonProperty(value="spec") FireDepartment fireDepartment, @JsonProperty(value="context") Map<String, Object> context) {
        super(id == null ? RealtimeIndexTask.makeTaskId(fireDepartment) : id, String.format("index_realtime_%s", RealtimeIndexTask.makeDatasource(fireDepartment)), taskResource, RealtimeIndexTask.makeDatasource(fireDepartment), context);
        this.spec = fireDepartment;
    }

    @Override
    public String getType() {
        return "index_realtime";
    }

    @Override
    public String getNodeType() {
        return "realtime";
    }

    @Override
    public <T> QueryRunner<T> getQueryRunner(Query<T> query) {
        if (this.plumber != null) {
            QueryRunnerFactory factory = this.queryRunnerFactoryConglomerate.findFactory(query);
            QueryToolChest toolChest = factory.getToolchest();
            return new FinalizeResultsQueryRunner(this.plumber.getQueryRunner(query), toolChest);
        }
        return null;
    }

    @Override
    public boolean isReady(TaskActionClient taskActionClient) throws Exception {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public TaskStatus run(final TaskToolbox toolbox) throws Exception {
        block42: {
            this.runThread = Thread.currentThread();
            if (this.plumber != null) {
                throw new IllegalStateException("WTF?!? run with non-null plumber??!");
            }
            normalExit = true;
            segmentPublisher = new TaskActionSegmentPublisher(this, toolbox);
            lockingSegmentAnnouncer = new DataSegmentAnnouncer(){

                public void announceSegment(DataSegment segment) throws IOException {
                    toolbox.getTaskActionClient().submit(new LockAcquireAction(segment.getInterval()));
                    toolbox.getSegmentAnnouncer().announceSegment(segment);
                }

                public void unannounceSegment(DataSegment segment) throws IOException {
                    try {
                        toolbox.getSegmentAnnouncer().unannounceSegment(segment);
                    }
                    finally {
                        toolbox.getTaskActionClient().submit(new LockReleaseAction(segment.getInterval()));
                    }
                }

                public void announceSegments(Iterable<DataSegment> segments) throws IOException {
                    for (DataSegment segment : segments) {
                        toolbox.getTaskActionClient().submit(new LockAcquireAction(segment.getInterval()));
                    }
                    toolbox.getSegmentAnnouncer().announceSegments(segments);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void unannounceSegments(Iterable<DataSegment> segments) throws IOException {
                    try {
                        toolbox.getSegmentAnnouncer().unannounceSegments(segments);
                    }
                    finally {
                        for (DataSegment segment : segments) {
                            toolbox.getTaskActionClient().submit(new LockReleaseAction(segment.getInterval()));
                        }
                    }
                }

                public boolean isAnnounced(DataSegment segment) {
                    return toolbox.getSegmentAnnouncer().isAnnounced(segment);
                }
            };
            versioningPolicy = new VersioningPolicy(){

                public String getVersion(Interval interval) {
                    try {
                        TaskLock myLock = toolbox.getTaskActionClient().submit(new LockAcquireAction(interval));
                        return myLock.getVersion();
                    }
                    catch (IOException e) {
                        throw Throwables.propagate((Throwable)e);
                    }
                }
            };
            dataSchema = this.spec.getDataSchema();
            realtimeIOConfig = this.spec.getIOConfig();
            tuningConfig = this.spec.getTuningConfig().withBasePersistDirectory(new File(toolbox.getTaskWorkDir(), "persist")).withVersioningPolicy(versioningPolicy);
            fireDepartment = new FireDepartment(dataSchema, realtimeIOConfig, tuningConfig);
            this.metrics = fireDepartment.getMetrics();
            metricsMonitor = new RealtimeMetricsMonitor((List)ImmutableList.of((Object)fireDepartment), (Map)ImmutableMap.of((Object)"taskId", (Object)new String[]{this.getId()}));
            this.queryRunnerFactoryConglomerate = toolbox.getQueryRunnerFactoryConglomerate();
            plumberSchool = new RealtimePlumberSchool(toolbox.getEmitter(), toolbox.getQueryRunnerFactoryConglomerate(), toolbox.getSegmentPusher(), lockingSegmentAnnouncer, (SegmentPublisher)segmentPublisher, toolbox.getSegmentHandoffNotifierFactory(), toolbox.getQueryExecutorService(), toolbox.getIndexMerger(), toolbox.getIndexMergerV9(), toolbox.getIndexIO(), toolbox.getCache(), toolbox.getCacheConfig(), toolbox.getObjectMapper());
            this.plumber = plumberSchool.findPlumber(dataSchema, tuningConfig, this.metrics);
            committerSupplier = null;
            this.plumber.startJob();
            toolbox.getMonitorScheduler().addMonitor((Monitor)metricsMonitor);
            firehoseFactory = this.spec.getIOConfig().getFirehoseFactory();
            firehoseDrainableByClosing = this.isFirehoseDrainableByClosing(firehoseFactory);
            var15_19 = this;
            synchronized (var15_19) {
                if (!this.gracefullyStopped) {
                    this.firehose = firehoseFactory.connect(this.spec.getDataSchema().getParser());
                    committerSupplier = Committers.supplierFromFirehose((Firehose)this.firehose);
                }
            }
            while (this.firehose != null && (!this.gracefullyStopped || firehoseDrainableByClosing) && this.firehose.hasMore()) {
                Plumbers.addNextRow((Supplier)committerSupplier, (Firehose)this.firehose, (Plumber)this.plumber, (boolean)tuningConfig.isReportParseExceptions(), (FireDepartmentMetrics)this.metrics);
            }
            if (!normalExit) break block42;
            try {
                if (this.firehose != null) {
                    RealtimeIndexTask.log.info("Persisting remaining data.", new Object[0]);
                    committer /* !! */  = (Committer)committerSupplier.get();
                    persistLatch = new CountDownLatch(1);
                    this.plumber.persist(new Committer(committer /* !! */ , persistLatch){
                        final /* synthetic */ Committer val$committer;
                        final /* synthetic */ CountDownLatch val$persistLatch;
                        {
                            this.val$committer = committer;
                            this.val$persistLatch = countDownLatch;
                        }

                        public Object getMetadata() {
                            return this.val$committer.getMetadata();
                        }

                        public void run() {
                            try {
                                this.val$committer.run();
                            }
                            finally {
                                this.val$persistLatch.countDown();
                            }
                        }
                    });
                    persistLatch.await();
                }
                if (this.gracefullyStopped) {
                    RealtimeIndexTask.log.info("Gracefully stopping.", new Object[0]);
                }
                RealtimeIndexTask.log.info("Finishing the job.", new Object[0]);
                committer /* !! */  = this;
                synchronized (committer /* !! */ ) {
                    if (this.gracefullyStopped) {
                        RealtimeIndexTask.log.info("Gracefully stopping.", new Object[0]);
                    } else {
                        this.finishingJob = true;
                    }
                }
                if (!this.finishingJob) ** GOTO lbl116
                this.plumber.finishJob();
            }
            catch (InterruptedException e) {
                RealtimeIndexTask.log.debug((Throwable)e, "Interrupted while finishing the job", new Object[0]);
            }
            catch (Exception e) {
                RealtimeIndexTask.log.makeAlert((Throwable)e, "Failed to finish realtime task", new Object[0]).emit();
                throw e;
            }
            finally {
                if (this.firehose != null) {
                    CloseQuietly.close((Closeable)this.firehose);
                }
                toolbox.getMonitorScheduler().removeMonitor((Monitor)metricsMonitor);
            }
            catch (Throwable e) {
                try {
                    normalExit = false;
                    RealtimeIndexTask.log.makeAlert(e, "Exception aborted realtime processing[%s]", new Object[]{dataSchema.getDataSource()}).emit();
                    throw e;
                }
                catch (Throwable var19_23) {
                    block43: {
                        if (normalExit) {
                            try {
                                if (this.firehose != null) {
                                    RealtimeIndexTask.log.info("Persisting remaining data.", new Object[0]);
                                    committer /* !! */  = (Committer)committerSupplier.get();
                                    persistLatch = new CountDownLatch(1);
                                    this.plumber.persist(new /* invalid duplicate definition of identical inner class */);
                                    persistLatch.await();
                                }
                                if (this.gracefullyStopped) {
                                    RealtimeIndexTask.log.info("Gracefully stopping.", new Object[0]);
                                    break block43;
                                }
                                RealtimeIndexTask.log.info("Finishing the job.", new Object[0]);
                                committer /* !! */  = this;
                                synchronized (committer /* !! */ ) {
                                    if (this.gracefullyStopped) {
                                        RealtimeIndexTask.log.info("Gracefully stopping.", new Object[0]);
                                    } else {
                                        this.finishingJob = true;
                                    }
                                }
                                if (this.finishingJob) {
                                    this.plumber.finishJob();
                                }
                            }
                            catch (InterruptedException e) {
                                RealtimeIndexTask.log.debug((Throwable)e, "Interrupted while finishing the job", new Object[0]);
                            }
                            catch (Exception e) {
                                RealtimeIndexTask.log.makeAlert((Throwable)e, "Failed to finish realtime task", new Object[0]).emit();
                                throw e;
                            }
                            finally {
                                if (this.firehose != null) {
                                    CloseQuietly.close((Closeable)this.firehose);
                                }
                                toolbox.getMonitorScheduler().removeMonitor((Monitor)metricsMonitor);
                            }
                        }
                    }
                    throw var19_23;
                }
            }
        }
        RealtimeIndexTask.log.info("Job done!", new Object[0]);
        return TaskStatus.success(this.getId());
    }

    @Override
    public boolean canRestore() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopGracefully() {
        try {
            RealtimeIndexTask realtimeIndexTask = this;
            synchronized (realtimeIndexTask) {
                if (!this.gracefullyStopped) {
                    this.gracefullyStopped = true;
                    if (this.firehose == null) {
                        log.info("stopGracefully: Firehose not started yet, so nothing to stop.", new Object[0]);
                    } else if (this.finishingJob) {
                        log.info("stopGracefully: Interrupting finishJob.", new Object[0]);
                        this.runThread.interrupt();
                    } else if (this.isFirehoseDrainableByClosing(this.spec.getIOConfig().getFirehoseFactory())) {
                        log.info("stopGracefully: Draining firehose.", new Object[0]);
                        this.firehose.close();
                    } else {
                        log.info("stopGracefully: Cannot drain firehose by closing, interrupting run thread.", new Object[0]);
                        this.runThread.interrupt();
                    }
                }
            }
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    @JsonIgnore
    public Firehose getFirehose() {
        return this.firehose;
    }

    @JsonIgnore
    public FireDepartmentMetrics getMetrics() {
        return this.metrics;
    }

    @JsonProperty(value="spec")
    public FireDepartment getRealtimeIngestionSchema() {
        return this.spec;
    }

    protected boolean isFirehoseDrainableByClosing(FirehoseFactory firehoseFactory) {
        return firehoseFactory instanceof EventReceiverFirehoseFactory || firehoseFactory instanceof TimedShutoffFirehoseFactory && this.isFirehoseDrainableByClosing(((TimedShutoffFirehoseFactory)firehoseFactory).getDelegateFactory()) || firehoseFactory instanceof ClippedFirehoseFactory && this.isFirehoseDrainableByClosing(((ClippedFirehoseFactory)firehoseFactory).getDelegate());
    }

    public static class TaskActionSegmentPublisher
    implements SegmentPublisher {
        final Task task;
        final TaskToolbox taskToolbox;

        public TaskActionSegmentPublisher(Task task, TaskToolbox taskToolbox) {
            this.task = task;
            this.taskToolbox = taskToolbox;
        }

        public void publishSegment(DataSegment segment) throws IOException {
            this.taskToolbox.publishSegments((Iterable<DataSegment>)ImmutableList.of((Object)segment));
        }
    }
}

