/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.metamx.common.ISE;
import com.metamx.common.logger.Logger;
import io.druid.indexing.common.TaskLock;
import io.druid.indexing.common.TaskStatus;
import io.druid.indexing.common.TaskToolbox;
import io.druid.indexing.common.actions.SegmentListUnusedAction;
import io.druid.indexing.common.actions.SegmentMetadataUpdateAction;
import io.druid.indexing.common.task.AbstractFixedIntervalTask;
import io.druid.timeline.DataSegment;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joda.time.Interval;

public class RestoreTask
extends AbstractFixedIntervalTask {
    private static final Logger log = new Logger(RestoreTask.class);

    public RestoreTask(@JsonProperty(value="id") String id, @JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="interval") Interval interval, @JsonProperty(value="context") Map<String, Object> context) {
        super(RestoreTask.makeId(id, "restore", dataSource, interval), dataSource, interval, context);
    }

    @Override
    public String getType() {
        return "restore";
    }

    @Override
    public TaskStatus run(TaskToolbox toolbox) throws Exception {
        TaskLock myLock = (TaskLock)Iterables.getOnlyElement(this.getTaskLocks(toolbox));
        if (!myLock.getDataSource().equals(this.getDataSource())) {
            throw new ISE("WTF?! Lock dataSource[%s] != task dataSource[%s]", new Object[]{myLock.getDataSource(), this.getDataSource()});
        }
        if (!myLock.getInterval().equals((Object)this.getInterval())) {
            throw new ISE("WTF?! Lock interval[%s] != task interval[%s]", new Object[]{myLock.getInterval(), this.getInterval()});
        }
        List<DataSegment> unusedSegments = toolbox.getTaskActionClient().submit(new SegmentListUnusedAction(myLock.getDataSource(), myLock.getInterval()));
        for (DataSegment unusedSegment : unusedSegments) {
            if (unusedSegment.getVersion().compareTo(myLock.getVersion()) > 0) {
                throw new ISE("WTF?! Unused segment[%s] has version[%s] > task version[%s]", new Object[]{unusedSegment.getIdentifier(), unusedSegment.getVersion(), myLock.getVersion()});
            }
            log.info("OK to restore segment: %s", new Object[]{unusedSegment.getIdentifier()});
        }
        LinkedList restoredSegments = Lists.newLinkedList();
        for (DataSegment segment : unusedSegments) {
            restoredSegments.add(toolbox.getDataSegmentArchiver().restore(segment));
        }
        toolbox.getTaskActionClient().submit(new SegmentMetadataUpdateAction((Set<DataSegment>)ImmutableSet.copyOf((Collection)restoredSegments)));
        return TaskStatus.success(this.getId());
    }
}

