/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.common.tasklogs;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteSource;
import com.google.inject.Inject;
import io.druid.tasklogs.TaskLogStreamer;
import java.io.IOException;
import java.util.List;

public class SwitchingTaskLogStreamer
implements TaskLogStreamer {
    private final List<TaskLogStreamer> providers;

    @Inject
    public SwitchingTaskLogStreamer(List<TaskLogStreamer> providers) {
        this.providers = ImmutableList.copyOf(providers);
    }

    public Optional<ByteSource> streamTaskLog(String taskid, long offset) throws IOException {
        for (TaskLogStreamer provider : this.providers) {
            Optional stream = provider.streamTaskLog(taskid, offset);
            if (!stream.isPresent()) continue;
            return stream;
        }
        return Optional.absent();
    }
}

