/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.firehose;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.inject.Injector;
import com.metamx.common.parsers.ParseException;
import com.metamx.emitter.EmittingLogger;
import io.druid.data.input.Firehose;
import io.druid.data.input.FirehoseFactory;
import io.druid.data.input.impl.InputRowParser;
import io.druid.granularity.QueryGranularities;
import io.druid.indexing.common.TaskToolbox;
import io.druid.indexing.common.TaskToolboxFactory;
import io.druid.indexing.common.actions.SegmentListUsedAction;
import io.druid.indexing.common.task.NoopTask;
import io.druid.query.filter.DimFilter;
import io.druid.segment.IndexIO;
import io.druid.segment.QueryableIndexStorageAdapter;
import io.druid.segment.StorageAdapter;
import io.druid.segment.loading.SegmentLoadingException;
import io.druid.segment.realtime.firehose.IngestSegmentFirehose;
import io.druid.segment.realtime.firehose.WindowedStorageAdapter;
import io.druid.timeline.DataSegment;
import io.druid.timeline.TimelineObjectHolder;
import io.druid.timeline.VersionedIntervalTimeline;
import io.druid.timeline.partition.PartitionChunk;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joda.time.Interval;

public class IngestSegmentFirehoseFactory
implements FirehoseFactory<InputRowParser> {
    private static final EmittingLogger log = new EmittingLogger(IngestSegmentFirehoseFactory.class);
    private final String dataSource;
    private final Interval interval;
    private final DimFilter dimFilter;
    private final List<String> dimensions;
    private final List<String> metrics;
    private final Injector injector;
    private final IndexIO indexIO;

    @JsonCreator
    public IngestSegmentFirehoseFactory(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="interval") Interval interval, @JsonProperty(value="filter") DimFilter dimFilter, @JsonProperty(value="dimensions") List<String> dimensions, @JsonProperty(value="metrics") List<String> metrics, @JacksonInject Injector injector, @JacksonInject IndexIO indexIO) {
        Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
        Preconditions.checkNotNull((Object)interval, (Object)"interval");
        this.dataSource = dataSource;
        this.interval = interval;
        this.dimFilter = dimFilter;
        this.dimensions = dimensions;
        this.metrics = metrics;
        this.injector = injector;
        this.indexIO = (IndexIO)Preconditions.checkNotNull((Object)indexIO, (Object)"null IndexIO");
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    @JsonProperty(value="filter")
    public DimFilter getDimensionsFilter() {
        return this.dimFilter;
    }

    @JsonProperty
    public List<String> getDimensions() {
        return this.dimensions;
    }

    @JsonProperty
    public List<String> getMetrics() {
        return this.metrics;
    }

    public Firehose connect(InputRowParser inputRowParser) throws IOException, ParseException {
        log.info("Connecting firehose: dataSource[%s], interval[%s]", new Object[]{this.dataSource, this.interval});
        TaskToolbox toolbox = ((TaskToolboxFactory)this.injector.getInstance(TaskToolboxFactory.class)).build(new NoopTask("reingest", 0L, 0L, null, null, null));
        try {
            ArrayList metricsList;
            List dims;
            List<DataSegment> usedSegments = toolbox.getTaskActionClient().submit(new SegmentListUsedAction(this.dataSource, this.interval, null));
            final Map<DataSegment, File> segmentFileMap = toolbox.fetchSegments(usedSegments);
            VersionedIntervalTimeline timeline = new VersionedIntervalTimeline((Comparator)Ordering.natural().nullsFirst());
            for (DataSegment segment : usedSegments) {
                timeline.add(segment.getInterval(), (Object)segment.getVersion(), segment.getShardSpec().createChunk((Object)segment));
            }
            List timeLineSegments = timeline.lookup(this.interval);
            if (this.dimensions != null) {
                dims = this.dimensions;
            } else if (inputRowParser.getParseSpec().getDimensionsSpec().hasCustomDimensions()) {
                dims = inputRowParser.getParseSpec().getDimensionsSpec().getDimensionNames();
            } else {
                HashSet dimSet = Sets.newHashSet((Iterable)Iterables.concat((Iterable)Iterables.transform((Iterable)timeLineSegments, (Function)new Function<TimelineObjectHolder<String, DataSegment>, Iterable<String>>(){

                    public Iterable<String> apply(TimelineObjectHolder<String, DataSegment> timelineObjectHolder) {
                        return Iterables.concat((Iterable)Iterables.transform((Iterable)timelineObjectHolder.getObject(), (Function)new Function<PartitionChunk<DataSegment>, Iterable<String>>(){

                            public Iterable<String> apply(PartitionChunk<DataSegment> input) {
                                return ((DataSegment)input.getObject()).getDimensions();
                            }
                        }));
                    }
                })));
                dims = Lists.newArrayList((Iterable)Sets.difference((Set)dimSet, (Set)inputRowParser.getParseSpec().getDimensionsSpec().getDimensionExclusions()));
            }
            if (this.metrics != null) {
                metricsList = this.metrics;
            } else {
                HashSet metricsSet = Sets.newHashSet((Iterable)Iterables.concat((Iterable)Iterables.transform((Iterable)timeLineSegments, (Function)new Function<TimelineObjectHolder<String, DataSegment>, Iterable<String>>(){

                    public Iterable<String> apply(TimelineObjectHolder<String, DataSegment> input) {
                        return Iterables.concat((Iterable)Iterables.transform((Iterable)input.getObject(), (Function)new Function<PartitionChunk<DataSegment>, Iterable<String>>(){

                            public Iterable<String> apply(PartitionChunk<DataSegment> input) {
                                return ((DataSegment)input.getObject()).getMetrics();
                            }
                        }));
                    }
                })));
                metricsList = Lists.newArrayList((Iterable)metricsSet);
            }
            ArrayList adapters = Lists.newArrayList((Iterable)Iterables.concat((Iterable)Iterables.transform((Iterable)timeLineSegments, (Function)new Function<TimelineObjectHolder<String, DataSegment>, Iterable<WindowedStorageAdapter>>(){

                public Iterable<WindowedStorageAdapter> apply(final TimelineObjectHolder<String, DataSegment> holder) {
                    return Iterables.transform((Iterable)holder.getObject(), (Function)new Function<PartitionChunk<DataSegment>, WindowedStorageAdapter>(){

                        public WindowedStorageAdapter apply(PartitionChunk<DataSegment> input) {
                            DataSegment segment = (DataSegment)input.getObject();
                            try {
                                return new WindowedStorageAdapter((StorageAdapter)new QueryableIndexStorageAdapter(IngestSegmentFirehoseFactory.this.indexIO.loadIndex((File)Preconditions.checkNotNull(segmentFileMap.get(segment), (String)"File for segment %s", (Object[])new Object[]{segment.getIdentifier()}))), holder.getInterval());
                            }
                            catch (IOException e) {
                                throw Throwables.propagate((Throwable)e);
                            }
                        }
                    });
                }
            })));
            return new IngestSegmentFirehose((List)adapters, dims, (List)metricsList, this.dimFilter, QueryGranularities.NONE);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (SegmentLoadingException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

