/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.inject.Inject;
import com.metamx.common.concurrent.ScheduledExecutorFactory;
import com.metamx.http.client.HttpClient;
import io.druid.curator.cache.PathChildrenCacheFactory;
import io.druid.curator.cache.SimplePathChildrenCacheFactory;
import io.druid.guice.annotations.Global;
import io.druid.indexing.overlord.RemoteTaskRunner;
import io.druid.indexing.overlord.TaskRunnerFactory;
import io.druid.indexing.overlord.autoscaling.NoopResourceManagementStrategy;
import io.druid.indexing.overlord.autoscaling.ResourceManagementSchedulerConfig;
import io.druid.indexing.overlord.autoscaling.ResourceManagementStrategy;
import io.druid.indexing.overlord.config.RemoteTaskRunnerConfig;
import io.druid.indexing.overlord.setup.WorkerBehaviorConfig;
import io.druid.server.initialization.IndexerZkConfig;
import org.apache.curator.framework.CuratorFramework;

public class RemoteTaskRunnerFactory
implements TaskRunnerFactory<RemoteTaskRunner> {
    public static final String TYPE_NAME = "remote";
    private final CuratorFramework curator;
    private final RemoteTaskRunnerConfig remoteTaskRunnerConfig;
    private final IndexerZkConfig zkPaths;
    private final ObjectMapper jsonMapper;
    private final HttpClient httpClient;
    private final Supplier<WorkerBehaviorConfig> workerConfigRef;
    private final ResourceManagementSchedulerConfig resourceManagementSchedulerConfig;
    private final ResourceManagementStrategy resourceManagementStrategy;
    private final ScheduledExecutorFactory factory;

    @Inject
    public RemoteTaskRunnerFactory(CuratorFramework curator, RemoteTaskRunnerConfig remoteTaskRunnerConfig, IndexerZkConfig zkPaths, ObjectMapper jsonMapper, @Global HttpClient httpClient, Supplier<WorkerBehaviorConfig> workerConfigRef, ScheduledExecutorFactory factory, ResourceManagementSchedulerConfig resourceManagementSchedulerConfig, ResourceManagementStrategy resourceManagementStrategy) {
        this.curator = curator;
        this.remoteTaskRunnerConfig = remoteTaskRunnerConfig;
        this.zkPaths = zkPaths;
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.workerConfigRef = workerConfigRef;
        this.resourceManagementSchedulerConfig = resourceManagementSchedulerConfig;
        this.resourceManagementStrategy = resourceManagementStrategy;
        this.factory = factory;
    }

    @Override
    public RemoteTaskRunner build() {
        return new RemoteTaskRunner(this.jsonMapper, this.remoteTaskRunnerConfig, this.zkPaths, this.curator, (PathChildrenCacheFactory)new SimplePathChildrenCacheFactory.Builder().withCompressed(true).build(), this.httpClient, this.workerConfigRef, this.factory.create(1, "RemoteTaskRunner-Scheduled-Cleanup--%d"), this.resourceManagementSchedulerConfig.isDoAutoscale() ? this.resourceManagementStrategy : new NoopResourceManagementStrategy());
    }
}

