/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.druid.indexing.common.TaskLocation;
import io.druid.indexing.common.TaskStatus;
import io.druid.indexing.overlord.TaskRunnerWorkItem;
import io.druid.indexing.worker.Worker;
import org.joda.time.DateTime;

public class RemoteTaskRunnerWorkItem
extends TaskRunnerWorkItem {
    private final SettableFuture<TaskStatus> result;
    private final Worker worker;
    private TaskLocation location;

    public RemoteTaskRunnerWorkItem(String taskId, Worker worker, TaskLocation location) {
        this(taskId, (SettableFuture<TaskStatus>)SettableFuture.create(), worker, location);
    }

    public RemoteTaskRunnerWorkItem(String taskId, DateTime createdTime, DateTime queueInsertionTime, Worker worker, TaskLocation location) {
        this(taskId, (SettableFuture<TaskStatus>)SettableFuture.create(), createdTime, queueInsertionTime, worker, location);
    }

    private RemoteTaskRunnerWorkItem(String taskId, SettableFuture<TaskStatus> result, Worker worker, TaskLocation location) {
        super(taskId, (ListenableFuture<TaskStatus>)result);
        this.result = result;
        this.worker = worker;
        this.location = location == null ? TaskLocation.unknown() : location;
    }

    private RemoteTaskRunnerWorkItem(String taskId, SettableFuture<TaskStatus> result, DateTime createdTime, DateTime queueInsertionTime, Worker worker, TaskLocation location) {
        super(taskId, (ListenableFuture<TaskStatus>)result, createdTime, queueInsertionTime);
        this.result = result;
        this.worker = worker;
        this.location = location == null ? TaskLocation.unknown() : location;
    }

    public void setLocation(TaskLocation location) {
        this.location = location;
    }

    @Override
    public TaskLocation getLocation() {
        return this.location;
    }

    public Worker getWorker() {
        return this.worker;
    }

    public void setResult(TaskStatus status) {
        this.result.set((Object)status);
    }

    public RemoteTaskRunnerWorkItem withQueueInsertionTime(DateTime time) {
        return new RemoteTaskRunnerWorkItem(this.getTaskId(), this.result, this.getCreatedTime(), time, this.worker, this.location);
    }

    public RemoteTaskRunnerWorkItem withWorker(Worker theWorker, TaskLocation location) {
        return new RemoteTaskRunnerWorkItem(this.getTaskId(), this.result, this.getCreatedTime(), this.getQueueInsertionTime(), theWorker, location);
    }
}

