/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord;

import com.metamx.common.Pair;
import com.metamx.emitter.EmittingLogger;
import io.druid.indexing.common.TaskLocation;
import io.druid.indexing.common.TaskStatus;
import io.druid.indexing.overlord.TaskRunnerListener;
import java.util.concurrent.Executor;

public class TaskRunnerUtils {
    private static final EmittingLogger log = new EmittingLogger(TaskRunnerUtils.class);

    public static void notifyLocationChanged(Iterable<Pair<TaskRunnerListener, Executor>> listeners, final String taskId, final TaskLocation location) {
        log.info("Task [%s] location changed to [%s].", new Object[]{taskId, location});
        for (final Pair<TaskRunnerListener, Executor> listener : listeners) {
            try {
                ((Executor)listener.rhs).execute(new Runnable(){

                    @Override
                    public void run() {
                        ((TaskRunnerListener)listener.lhs).locationChanged(taskId, location);
                    }
                });
            }
            catch (Exception e) {
                log.makeAlert((Throwable)e, "Unable to notify task listener", new Object[0]).addData("taskId", (Object)taskId).addData("taskLocation", (Object)location).addData("listener", (Object)listener.toString()).emit();
            }
        }
    }

    public static void notifyStatusChanged(Iterable<Pair<TaskRunnerListener, Executor>> listeners, final String taskId, final TaskStatus status) {
        log.info("Task [%s] status changed to [%s].", new Object[]{taskId, status.getStatusCode()});
        for (final Pair<TaskRunnerListener, Executor> listener : listeners) {
            try {
                ((Executor)listener.rhs).execute(new Runnable(){

                    @Override
                    public void run() {
                        ((TaskRunnerListener)listener.lhs).statusChanged(taskId, status);
                    }
                });
            }
            catch (Exception e) {
                log.makeAlert((Throwable)e, "Unable to notify task listener", new Object[0]).addData("taskId", (Object)taskId).addData("taskStatus", (Object)status.getStatusCode()).addData("listener", (Object)listener.toString()).emit();
            }
        }
    }
}

