/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord.autoscaling;

import com.metamx.common.concurrent.ScheduledExecutors;
import com.metamx.emitter.EmittingLogger;
import io.druid.granularity.PeriodGranularity;
import io.druid.indexing.overlord.WorkerTaskRunner;
import io.druid.indexing.overlord.autoscaling.ResourceManagementSchedulerConfig;
import io.druid.indexing.overlord.autoscaling.ResourceManagementStrategy;
import java.util.concurrent.ScheduledExecutorService;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Period;

public abstract class AbstractWorkerResourceManagementStrategy
implements ResourceManagementStrategy<WorkerTaskRunner> {
    private static final EmittingLogger log = new EmittingLogger(AbstractWorkerResourceManagementStrategy.class);
    private final ResourceManagementSchedulerConfig resourceManagementSchedulerConfig;
    private final ScheduledExecutorService exec;
    private final Object lock = new Object();
    private volatile boolean started = false;

    protected AbstractWorkerResourceManagementStrategy(ResourceManagementSchedulerConfig resourceManagementSchedulerConfig, ScheduledExecutorService exec) {
        this.resourceManagementSchedulerConfig = resourceManagementSchedulerConfig;
        this.exec = exec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startManagement(final WorkerTaskRunner runner) {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            log.info("Started Resource Management Scheduler", new Object[0]);
            ScheduledExecutors.scheduleAtFixedRate((ScheduledExecutorService)this.exec, (Duration)this.resourceManagementSchedulerConfig.getProvisionPeriod().toStandardDuration(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    AbstractWorkerResourceManagementStrategy.this.doProvision(runner);
                }
            });
            Period period = this.resourceManagementSchedulerConfig.getTerminatePeriod();
            PeriodGranularity granularity = new PeriodGranularity(period, this.resourceManagementSchedulerConfig.getOriginTime(), null);
            long startTime = granularity.next(granularity.truncate(new DateTime().getMillis()));
            ScheduledExecutors.scheduleAtFixedRate((ScheduledExecutorService)this.exec, (Duration)new Duration(System.currentTimeMillis(), startTime), (Duration)this.resourceManagementSchedulerConfig.getTerminatePeriod().toStandardDuration(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    AbstractWorkerResourceManagementStrategy.this.doTerminate(runner);
                }
            });
            this.started = true;
        }
    }

    abstract boolean doTerminate(WorkerTaskRunner var1);

    abstract boolean doProvision(WorkerTaskRunner var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopManagement() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            log.info("Stopping Resource Management Scheduler", new Object[0]);
            this.exec.shutdown();
            this.started = false;
        }
    }
}

