/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord.autoscaling;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.Lists;
import com.google.common.collect.MinMaxPriorityQueue;
import com.google.common.collect.Ordering;
import io.druid.indexing.overlord.autoscaling.AutoScalingData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class ScalingStats {
    private static final Comparator<ScalingEvent> COMPARATOR = new Ordering<ScalingEvent>(){

        public int compare(ScalingEvent s1, ScalingEvent s2) {
            return s2.getTimestamp().compareTo((ReadableInstant)s1.getTimestamp());
        }
    }.nullsLast();
    private final Object lock = new Object();
    private final MinMaxPriorityQueue<ScalingEvent> recentEvents;

    public ScalingStats(int capacity) {
        this.recentEvents = capacity == 0 ? MinMaxPriorityQueue.orderedBy(COMPARATOR).create() : MinMaxPriorityQueue.orderedBy(COMPARATOR).maximumSize(capacity).create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProvisionEvent(AutoScalingData data) {
        Object object = this.lock;
        synchronized (object) {
            this.recentEvents.add((Object)new ScalingEvent(data, new DateTime(), EVENT.PROVISION));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTerminateEvent(AutoScalingData data) {
        Object object = this.lock;
        synchronized (object) {
            this.recentEvents.add((Object)new ScalingEvent(data, new DateTime(), EVENT.TERMINATE));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonValue
    public List<ScalingEvent> toList() {
        Object object = this.lock;
        synchronized (object) {
            ArrayList retVal = Lists.newArrayList(this.recentEvents);
            Collections.sort(retVal, COMPARATOR);
            return retVal;
        }
    }

    public static class ScalingEvent {
        private final AutoScalingData data;
        private final DateTime timestamp;
        private final EVENT event;

        private ScalingEvent(AutoScalingData data, DateTime timestamp, EVENT event) {
            this.data = data;
            this.timestamp = timestamp;
            this.event = event;
        }

        @JsonProperty
        public AutoScalingData getData() {
            return this.data;
        }

        @JsonProperty
        public DateTime getTimestamp() {
            return this.timestamp;
        }

        @JsonProperty
        public EVENT getEvent() {
            return this.event;
        }

        public String toString() {
            return "ScalingEvent{data=" + this.data + ", timestamp=" + this.timestamp + ", event=" + (Object)((Object)this.event) + '}';
        }
    }

    public static enum EVENT {
        PROVISION,
        TERMINATE;

    }
}

