/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord.autoscaling.ec2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.metamx.common.StringUtils;
import io.druid.indexing.overlord.autoscaling.ec2.EC2UserData;
import org.apache.commons.codec.binary.Base64;

public class StringEC2UserData
implements EC2UserData<StringEC2UserData> {
    private final String data;
    private final String versionReplacementString;
    private final String version;

    @JsonCreator
    public StringEC2UserData(@JsonProperty(value="data") String data, @JsonProperty(value="versionReplacementString") String versionReplacementString, @JsonProperty(value="version") String version) {
        this.data = data;
        this.versionReplacementString = versionReplacementString;
        this.version = version;
    }

    @JsonProperty
    public String getData() {
        return this.data;
    }

    @JsonProperty
    public String getVersionReplacementString() {
        return this.versionReplacementString;
    }

    @JsonProperty
    public String getVersion() {
        return this.version;
    }

    public StringEC2UserData withVersion(String _version) {
        return new StringEC2UserData(this.data, this.versionReplacementString, _version);
    }

    @Override
    public String getUserDataBase64() {
        String finalData = this.versionReplacementString != null && this.version != null ? this.data.replace(this.versionReplacementString, this.version) : this.data;
        return Base64.encodeBase64String((byte[])StringUtils.toUtf8((String)finalData));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringEC2UserData that = (StringEC2UserData)o;
        if (this.data != null ? !this.data.equals(that.data) : that.data != null) {
            return false;
        }
        if (this.version != null ? !this.version.equals(that.version) : that.version != null) {
            return false;
        }
        return !(this.versionReplacementString != null ? !this.versionReplacementString.equals(that.versionReplacementString) : that.versionReplacementString != null);
    }

    public int hashCode() {
        int result = this.data != null ? this.data.hashCode() : 0;
        result = 31 * result + (this.versionReplacementString != null ? this.versionReplacementString.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "StringEC2UserData{data='" + this.data + '\'' + ", versionReplacementString='" + this.versionReplacementString + '\'' + ", version='" + this.version + '\'' + '}';
    }
}

