/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.indexing.overlord.config.WorkerTaskRunnerConfig;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.joda.time.Period;

public class RemoteTaskRunnerConfig
extends WorkerTaskRunnerConfig {
    @JsonProperty
    @NotNull
    private Period taskAssignmentTimeout = new Period((Object)"PT5M");
    @JsonProperty
    @NotNull
    private Period taskCleanupTimeout = new Period((Object)"PT15M");
    @JsonProperty
    @Min(value=10240L)
    private int maxZnodeBytes = 524288;
    @JsonProperty
    private Period taskShutdownLinkTimeout = new Period((Object)"PT1M");
    @JsonProperty
    @Min(value=1L)
    private int pendingTasksRunnerNumThreads = 1;

    public Period getTaskAssignmentTimeout() {
        return this.taskAssignmentTimeout;
    }

    @JsonProperty
    public Period getTaskCleanupTimeout() {
        return this.taskCleanupTimeout;
    }

    public int getMaxZnodeBytes() {
        return this.maxZnodeBytes;
    }

    public Period getTaskShutdownLinkTimeout() {
        return this.taskShutdownLinkTimeout;
    }

    public int getPendingTasksRunnerNumThreads() {
        return this.pendingTasksRunnerNumThreads;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteTaskRunnerConfig that = (RemoteTaskRunnerConfig)o;
        if (this.maxZnodeBytes != that.maxZnodeBytes) {
            return false;
        }
        if (this.pendingTasksRunnerNumThreads != that.pendingTasksRunnerNumThreads) {
            return false;
        }
        if (!this.taskAssignmentTimeout.equals((Object)that.taskAssignmentTimeout)) {
            return false;
        }
        if (!this.taskCleanupTimeout.equals((Object)that.taskCleanupTimeout)) {
            return false;
        }
        if (!this.getMinWorkerVersion().equals(that.getMinWorkerVersion())) {
            return false;
        }
        return this.taskShutdownLinkTimeout.equals((Object)that.taskShutdownLinkTimeout);
    }

    public int hashCode() {
        int result = this.taskAssignmentTimeout.hashCode();
        result = 31 * result + this.taskCleanupTimeout.hashCode();
        result = 31 * result + this.getMinWorkerVersion().hashCode();
        result = 31 * result + this.maxZnodeBytes;
        result = 31 * result + this.taskShutdownLinkTimeout.hashCode();
        result = 31 * result + this.pendingTasksRunnerNumThreads;
        return result;
    }

    public String toString() {
        return "RemoteTaskRunnerConfig{taskAssignmentTimeout=" + this.taskAssignmentTimeout + ", taskCleanupTimeout=" + this.taskCleanupTimeout + ", minWorkerVersion='" + this.getMinWorkerVersion() + '\'' + ", maxZnodeBytes=" + this.maxZnodeBytes + ", taskShutdownLinkTimeout=" + this.taskShutdownLinkTimeout + ", pendingTasksRunnerNumThreads=" + this.pendingTasksRunnerNumThreads + '}';
    }
}

