/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord.http.security;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.sun.jersey.spi.container.ContainerRequest;
import io.druid.indexing.common.task.Task;
import io.druid.indexing.overlord.TaskStorageQueryAdapter;
import io.druid.server.http.security.AbstractResourceFilter;
import io.druid.server.security.Access;
import io.druid.server.security.AuthConfig;
import io.druid.server.security.AuthorizationInfo;
import io.druid.server.security.Resource;
import io.druid.server.security.ResourceType;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;

public class TaskResourceFilter
extends AbstractResourceFilter {
    private final TaskStorageQueryAdapter taskStorageQueryAdapter;

    @Inject
    public TaskResourceFilter(TaskStorageQueryAdapter taskStorageQueryAdapter, AuthConfig authConfig) {
        super(authConfig);
        this.taskStorageQueryAdapter = taskStorageQueryAdapter;
    }

    public ContainerRequest filter(ContainerRequest request) {
        if (this.getAuthConfig().isEnabled()) {
            String taskId = (String)Preconditions.checkNotNull((Object)((PathSegment)request.getPathSegments().get(Iterables.indexOf((Iterable)request.getPathSegments(), (Predicate)new Predicate<PathSegment>(){

                public boolean apply(PathSegment input) {
                    return input.getPath().equals("task");
                }
            }) + 1)).getPath());
            Optional<Task> taskOptional = this.taskStorageQueryAdapter.getTask(taskId);
            if (!taskOptional.isPresent()) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)String.format("Cannot find any task with id: [%s]", taskId)).build());
            }
            String dataSourceName = (String)Preconditions.checkNotNull((Object)((Task)taskOptional.get()).getDataSource());
            AuthorizationInfo authorizationInfo = (AuthorizationInfo)this.getReq().getAttribute("Druid-Auth-Token");
            Preconditions.checkNotNull((Object)authorizationInfo, (Object)"Security is enabled but no authorization info found in the request");
            Access authResult = authorizationInfo.isAuthorized(new Resource(dataSourceName, ResourceType.DATASOURCE), this.getAction(request));
            if (!authResult.isAllowed()) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)String.format("Access-Check-Result: %s", authResult.toString())).build());
            }
        }
        return request;
    }

    public boolean isApplicable(String requestPath) {
        ImmutableList applicablePaths = ImmutableList.of((Object)"druid/indexer/v1/task/");
        for (String path : applicablePaths) {
            if (!requestPath.startsWith(path) || requestPath.equals(path)) continue;
            return true;
        }
        return false;
    }
}

