/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord.setup;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.indexing.overlord.autoscaling.AutoScaler;
import io.druid.indexing.overlord.autoscaling.NoopAutoScaler;
import io.druid.indexing.overlord.setup.FillCapacityWorkerSelectStrategy;
import io.druid.indexing.overlord.setup.WorkerSelectStrategy;

public class WorkerBehaviorConfig {
    public static final String CONFIG_KEY = "worker.config";
    public static WorkerSelectStrategy DEFAULT_STRATEGY = new FillCapacityWorkerSelectStrategy();
    public static AutoScaler DEFAULT_AUTOSCALER = new NoopAutoScaler();
    private final WorkerSelectStrategy selectStrategy;
    private final AutoScaler autoScaler;

    public static WorkerBehaviorConfig defaultConfig() {
        return new WorkerBehaviorConfig(DEFAULT_STRATEGY, DEFAULT_AUTOSCALER);
    }

    @JsonCreator
    public WorkerBehaviorConfig(@JsonProperty(value="selectStrategy") WorkerSelectStrategy selectStrategy, @JsonProperty(value="autoScaler") AutoScaler autoScaler) {
        this.selectStrategy = selectStrategy;
        this.autoScaler = autoScaler;
    }

    @JsonProperty
    public WorkerSelectStrategy getSelectStrategy() {
        return this.selectStrategy;
    }

    @JsonProperty
    public AutoScaler getAutoScaler() {
        return this.autoScaler;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkerBehaviorConfig that = (WorkerBehaviorConfig)o;
        if (this.autoScaler != null ? !this.autoScaler.equals(that.autoScaler) : that.autoScaler != null) {
            return false;
        }
        return !(this.selectStrategy != null ? !this.selectStrategy.equals(that.selectStrategy) : that.selectStrategy != null);
    }

    public int hashCode() {
        int result = this.selectStrategy != null ? this.selectStrategy.hashCode() : 0;
        result = 31 * result + (this.autoScaler != null ? this.autoScaler.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "WorkerConfiguration{selectStrategy=" + this.selectStrategy + ", autoScaler=" + this.autoScaler + '}';
    }
}

