/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexing.overlord.supervisor;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.druid.indexing.overlord.TaskMaster;
import io.druid.indexing.overlord.supervisor.SupervisorManager;
import io.druid.indexing.overlord.supervisor.SupervisorReport;
import io.druid.indexing.overlord.supervisor.SupervisorSpec;
import io.druid.indexing.overlord.supervisor.VersionedSupervisorSpec;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/druid/indexer/v1/supervisor")
public class SupervisorResource {
    private final TaskMaster taskMaster;

    @Inject
    public SupervisorResource(TaskMaster taskMaster) {
        this.taskMaster = taskMaster;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response specPost(final SupervisorSpec spec) {
        return this.asLeaderWithSupervisorManager(new Function<SupervisorManager, Response>(){

            public Response apply(SupervisorManager manager) {
                manager.createOrUpdateAndStartSupervisor(spec);
                return Response.ok((Object)ImmutableMap.of((Object)"id", (Object)spec.getId())).build();
            }
        });
    }

    @GET
    @Produces(value={"application/json"})
    public Response specGetAll() {
        return this.asLeaderWithSupervisorManager(new Function<SupervisorManager, Response>(){

            public Response apply(SupervisorManager manager) {
                return Response.ok(manager.getSupervisorIds()).build();
            }
        });
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response specGet(final @PathParam(value="id") String id) {
        return this.asLeaderWithSupervisorManager(new Function<SupervisorManager, Response>(){

            public Response apply(SupervisorManager manager) {
                Optional<SupervisorSpec> spec = manager.getSupervisorSpec(id);
                if (!spec.isPresent()) {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ImmutableMap.of((Object)"error", (Object)String.format("[%s] does not exist", id))).build();
                }
                return Response.ok((Object)spec.get()).build();
            }
        });
    }

    @GET
    @Path(value="/{id}/status")
    @Produces(value={"application/json"})
    public Response specGetStatus(final @PathParam(value="id") String id) {
        return this.asLeaderWithSupervisorManager(new Function<SupervisorManager, Response>(){

            public Response apply(SupervisorManager manager) {
                Optional<SupervisorReport> spec = manager.getSupervisorStatus(id);
                if (!spec.isPresent()) {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ImmutableMap.of((Object)"error", (Object)String.format("[%s] does not exist", id))).build();
                }
                return Response.ok((Object)spec.get()).build();
            }
        });
    }

    @POST
    @Path(value="/{id}/shutdown")
    @Produces(value={"application/json"})
    public Response shutdown(final @PathParam(value="id") String id) {
        return this.asLeaderWithSupervisorManager(new Function<SupervisorManager, Response>(){

            public Response apply(SupervisorManager manager) {
                if (manager.stopAndRemoveSupervisor(id)) {
                    return Response.ok((Object)ImmutableMap.of((Object)"id", (Object)id)).build();
                }
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ImmutableMap.of((Object)"error", (Object)String.format("[%s] does not exist", id))).build();
            }
        });
    }

    @GET
    @Path(value="/history")
    @Produces(value={"application/json"})
    public Response specGetAllHistory() {
        return this.asLeaderWithSupervisorManager(new Function<SupervisorManager, Response>(){

            public Response apply(SupervisorManager manager) {
                return Response.ok(manager.getSupervisorHistory()).build();
            }
        });
    }

    @GET
    @Path(value="/{id}/history")
    @Produces(value={"application/json"})
    public Response specGetHistory(final @PathParam(value="id") String id) {
        return this.asLeaderWithSupervisorManager(new Function<SupervisorManager, Response>(){

            public Response apply(SupervisorManager manager) {
                Map<String, List<VersionedSupervisorSpec>> history = manager.getSupervisorHistory();
                if (history.containsKey(id)) {
                    return Response.ok(history.get(id)).build();
                }
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ImmutableMap.of((Object)"error", (Object)String.format("No history for [%s] (history available for %s)", id, history.keySet()))).build();
            }
        });
    }

    private Response asLeaderWithSupervisorManager(Function<SupervisorManager, Response> f) {
        Optional<SupervisorManager> supervisorManager = this.taskMaster.getSupervisorManager();
        if (supervisorManager.isPresent()) {
            return (Response)f.apply(supervisorManager.get());
        }
        return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).build();
    }
}

