/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.lookup;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.metamx.common.IAE;
import com.metamx.common.ISE;
import com.metamx.common.StringUtils;
import com.metamx.common.logger.Logger;
import io.druid.concurrent.Execs;
import io.druid.query.extraction.MapLookupExtractor;
import io.druid.query.lookup.LookupExtractor;
import io.druid.query.lookup.LookupExtractorFactory;
import io.druid.query.lookup.LookupIntrospectHandler;
import io.druid.server.lookup.namespace.cache.NamespaceExtractionCacheManager;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.validation.constraints.Min;
import javax.ws.rs.GET;
import javax.ws.rs.core.Response;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.KafkaStream;
import kafka.consumer.TopicFilter;
import kafka.consumer.Whitelist;
import kafka.javaapi.consumer.ConsumerConnector;
import kafka.javaapi.consumer.ZookeeperConsumerConnector;
import kafka.message.MessageAndMetadata;
import kafka.serializer.Decoder;

@JsonTypeName(value="kafka")
public class KafkaLookupExtractorFactory
implements LookupExtractorFactory {
    private static final Logger LOG = new Logger(KafkaLookupExtractorFactory.class);
    static final Decoder<String> DEFAULT_STRING_DECODER = new Decoder<String>(){

        public String fromBytes(byte[] bytes) {
            return StringUtils.fromUtf8((byte[])bytes);
        }
    };
    private final ListeningExecutorService executorService;
    private final AtomicLong doubleEventCount = new AtomicLong(0L);
    private final NamespaceExtractionCacheManager cacheManager;
    private final String factoryId = UUID.randomUUID().toString();
    private final AtomicReference<Map<String, String>> mapRef = new AtomicReference<Object>(null);
    private final AtomicBoolean started = new AtomicBoolean(false);
    private volatile ListenableFuture<?> future = null;
    @JsonProperty
    private final String kafkaTopic;
    @JsonProperty
    private final Map<String, String> kafkaProperties;
    @JsonProperty
    private final long connectTimeout;
    @JsonProperty
    private final boolean injective;

    @JsonCreator
    public KafkaLookupExtractorFactory(@JacksonInject NamespaceExtractionCacheManager cacheManager, @JsonProperty(value="kafkaTopic") String kafkaTopic, @JsonProperty(value="kafkaProperties") Map<String, String> kafkaProperties, @JsonProperty(value="connectTimeout") @Min(value=0L) long connectTimeout, @JsonProperty(value="injective") boolean injective) {
        this.kafkaTopic = (String)Preconditions.checkNotNull((Object)kafkaTopic, (Object)"kafkaTopic required");
        this.kafkaProperties = (Map)Preconditions.checkNotNull(kafkaProperties, (Object)"kafkaProperties required");
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)Execs.singleThreaded((String)("kafka-factory-" + kafkaTopic + "-%s"), (Integer)1));
        this.cacheManager = cacheManager;
        this.connectTimeout = connectTimeout;
        this.injective = injective;
    }

    public KafkaLookupExtractorFactory(NamespaceExtractionCacheManager cacheManager, String kafkaTopic, Map<String, String> kafkaProperties) {
        this(cacheManager, kafkaTopic, kafkaProperties, 0L, false);
    }

    public String getKafkaTopic() {
        return this.kafkaTopic;
    }

    public Map<String, String> getKafkaProperties() {
        return this.kafkaProperties;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public boolean isInjective() {
        return this.injective;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start() {
        AtomicBoolean atomicBoolean = this.started;
        synchronized (atomicBoolean) {
            if (this.started.get()) {
                LOG.warn("Already started, not starting again", new Object[0]);
                return this.started.get();
            }
            if (this.executorService.isShutdown()) {
                LOG.warn("Already shut down, not starting again", new Object[0]);
                return false;
            }
            final Properties kafkaProperties = new Properties();
            kafkaProperties.putAll(this.getKafkaProperties());
            if (kafkaProperties.containsKey("group.id")) {
                throw new IAE("Cannot set kafka property [group.id]. Property is randomly generated for you. Found [%s]", new Object[]{kafkaProperties.getProperty("group.id")});
            }
            if (kafkaProperties.containsKey("auto.offset.reset")) {
                throw new IAE("Cannot set kafka property [auto.offset.reset]. Property will be forced to [smallest]. Found [%s]", new Object[]{kafkaProperties.getProperty("auto.offset.reset")});
            }
            Preconditions.checkNotNull((Object)kafkaProperties.getProperty("zookeeper.connect"), (Object)"zookeeper.connect required property");
            kafkaProperties.setProperty("group.id", this.factoryId);
            final String topic = this.getKafkaTopic();
            LOG.debug("About to listen to topic [%s] with group.id [%s]", new Object[]{topic, this.factoryId});
            final ConcurrentMap map = this.cacheManager.getCacheMap(this.factoryId);
            this.mapRef.set(map);
            kafkaProperties.setProperty("auto.offset.reset", "smallest");
            final CountDownLatch startingReads = new CountDownLatch(1);
            ListenableFuture future = this.executorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (!KafkaLookupExtractorFactory.this.executorService.isShutdown() && !Thread.currentThread().isInterrupted()) {
                        ConsumerConnector consumerConnector = KafkaLookupExtractorFactory.this.buildConnector(kafkaProperties);
                        try {
                            List streams = consumerConnector.createMessageStreamsByFilter((TopicFilter)new Whitelist(Pattern.quote(topic)), 1, DEFAULT_STRING_DECODER, DEFAULT_STRING_DECODER);
                            if (streams == null || streams.isEmpty()) {
                                throw new IAE("Topic [%s] had no streams", new Object[]{topic});
                            }
                            if (streams.size() > 1) {
                                throw new ISE("Topic [%s] has %d streams! expected 1", new Object[]{topic, streams.size()});
                            }
                            KafkaStream kafkaStream = (KafkaStream)streams.get(0);
                            startingReads.countDown();
                            for (MessageAndMetadata messageAndMetadata : kafkaStream) {
                                String key = (String)messageAndMetadata.key();
                                String message = (String)messageAndMetadata.message();
                                if (key == null || message == null) {
                                    LOG.error("Bad key/message from topic [%s]: [%s]", new Object[]{topic, messageAndMetadata});
                                    continue;
                                }
                                KafkaLookupExtractorFactory.this.doubleEventCount.incrementAndGet();
                                map.put(key, message);
                                KafkaLookupExtractorFactory.this.doubleEventCount.incrementAndGet();
                                LOG.trace("Placed key[%s] val[%s]", new Object[]{key, message});
                            }
                        }
                        catch (Exception e) {
                            LOG.error((Throwable)e, "Error reading stream for topic [%s]", new Object[]{topic});
                        }
                        finally {
                            consumerConnector.shutdown();
                        }
                    }
                }
            });
            Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<Object>(){

                public void onSuccess(Object result) {
                    LOG.debug("Success listening to [%s]", new Object[]{topic});
                }

                public void onFailure(Throwable t) {
                    if (t instanceof CancellationException) {
                        LOG.debug("Topic [%s] cancelled", new Object[]{topic});
                    } else {
                        LOG.error(t, "Error in listening to [%s]", new Object[]{topic});
                    }
                }
            }, (Executor)MoreExecutors.sameThreadExecutor());
            this.future = future;
            Stopwatch stopwatch = Stopwatch.createStarted();
            try {
                while (!startingReads.await(100L, TimeUnit.MILLISECONDS) && this.connectTimeout > 0L) {
                    if (future.isDone()) {
                        future.get();
                        continue;
                    }
                    if (stopwatch.elapsed(TimeUnit.MILLISECONDS) <= this.connectTimeout) continue;
                    throw new TimeoutException("Failed to connect to kafka in sufficient time");
                }
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                if (!(future.isDone() || future.cancel(true) || future.isDone())) {
                    LOG.warn("Could not cancel kafka listening thread", new Object[0]);
                }
                LOG.error((Throwable)e, "Failed to start kafka extraction factory", new Object[0]);
                this.cacheManager.delete(this.factoryId);
                return false;
            }
            this.started.set(true);
            return true;
        }
    }

    ConsumerConnector buildConnector(Properties properties) {
        return new ZookeeperConsumerConnector(new ConsumerConfig(properties));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close() {
        AtomicBoolean atomicBoolean = this.started;
        synchronized (atomicBoolean) {
            if (!this.started.get() || this.executorService.isShutdown()) {
                LOG.info("Already shutdown, ignoring", new Object[0]);
                return !this.started.get();
            }
            this.started.set(false);
            this.executorService.shutdownNow();
            ListenableFuture<?> future = this.future;
            if (!(future == null || future.isDone() || future.cancel(true) || future.isDone())) {
                LOG.error("Error cancelling future for topic [%s]", new Object[]{this.getKafkaTopic()});
                return false;
            }
            if (!this.cacheManager.delete(this.factoryId)) {
                LOG.error("Error removing [%s] for topic [%s] from cache", new Object[]{this.factoryId, this.getKafkaTopic()});
                return false;
            }
            return true;
        }
    }

    public boolean replaces(@Nullable LookupExtractorFactory other) {
        if (this == other) {
            return false;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return true;
        }
        KafkaLookupExtractorFactory that = (KafkaLookupExtractorFactory)other;
        return !this.getKafkaTopic().equals(that.getKafkaTopic()) || !this.getKafkaProperties().equals(that.getKafkaProperties()) || this.getConnectTimeout() != that.getConnectTimeout() || this.isInjective() != that.isInjective();
    }

    @Nullable
    public LookupIntrospectHandler getIntrospectHandler() {
        return new KafkaLookupExtractorIntrospectionHandler();
    }

    public LookupExtractor get() {
        Map map = (Map)Preconditions.checkNotNull(this.mapRef.get(), (Object)"Not started");
        final long startCount = this.doubleEventCount.get();
        return new MapLookupExtractor(map, this.isInjective()){

            public byte[] getCacheKey() {
                byte[] idutf8 = StringUtils.toUtf8((String)KafkaLookupExtractorFactory.this.factoryId);
                if (startCount == KafkaLookupExtractorFactory.this.doubleEventCount.get()) {
                    return ByteBuffer.allocate(idutf8.length + 1 + 8).put(idutf8).put((byte)-1).putLong(startCount).array();
                }
                byte[] scrambler = StringUtils.toUtf8((String)UUID.randomUUID().toString());
                return ByteBuffer.allocate(idutf8.length + 1 + scrambler.length + 1).put(idutf8).put((byte)-1).put(scrambler).put((byte)-1).array();
            }
        };
    }

    public long getCompletedEventCount() {
        return this.doubleEventCount.get() >> 1;
    }

    NamespaceExtractionCacheManager getCacheManager() {
        return this.cacheManager;
    }

    AtomicReference<Map<String, String>> getMapRef() {
        return this.mapRef;
    }

    AtomicLong getDoubleEventCount() {
        return this.doubleEventCount;
    }

    ListenableFuture<?> getFuture() {
        return this.future;
    }

    class KafkaLookupExtractorIntrospectionHandler
    implements LookupIntrospectHandler {
        KafkaLookupExtractorIntrospectionHandler() {
        }

        @GET
        public Response getActive() {
            ListenableFuture<?> future = KafkaLookupExtractorFactory.this.getFuture();
            if (future != null && !future.isDone()) {
                return Response.ok().build();
            }
            return Response.status((Response.Status)Response.Status.GONE).build();
        }
    }
}

