/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.extraction;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.inject.name.Named;
import com.metamx.common.StringUtils;
import io.druid.query.lookup.LookupExtractor;
import java.nio.ByteBuffer;
import java.util.List;
import javax.validation.constraints.NotNull;

@JsonTypeName(value="namespace")
public class NamespacedExtractor
extends LookupExtractor {
    private static final byte CACHE_TYPE_ID = 5;
    private final String namespace;
    private final Function<String, String> extractionFunction;
    private final Function<String, List<String>> reverseExtractionFunction;

    @JsonCreator
    public NamespacedExtractor(@NotNull @JacksonInject @Named(value="dimExtractionNamespace") Function<String, Function<String, String>> namespaces, @NotNull @JacksonInject @Named(value="dimReverseExtractionNamespace") Function<String, Function<String, List<String>>> reverseNamespaces, @NotNull @JsonProperty(value="namespace", required=true) String namespace) {
        this.namespace = (String)Preconditions.checkNotNull((Object)namespace, (Object)"namespace");
        this.extractionFunction = (Function)Preconditions.checkNotNull((Object)namespaces.apply((Object)namespace), (Object)"no namespace found");
        this.reverseExtractionFunction = (Function)Preconditions.checkNotNull((Object)reverseNamespaces.apply((Object)namespace), (Object)"can not found reverse extraction function");
    }

    @JsonProperty(value="namespace")
    public String getNamespace() {
        return this.namespace;
    }

    public byte[] getCacheKey() {
        byte[] nsBytes = StringUtils.toUtf8((String)this.namespace);
        return ByteBuffer.allocate(nsBytes.length + 1).put((byte)5).put(nsBytes).array();
    }

    public String apply(String value) {
        return (String)this.extractionFunction.apply((Object)value);
    }

    public List<String> unapply(@NotNull String value) {
        return (List)this.reverseExtractionFunction.apply((Object)value);
    }
}

