/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.extraction.namespace;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.metamx.common.IAE;
import com.metamx.common.UOE;
import com.metamx.common.parsers.CSVParser;
import com.metamx.common.parsers.DelimitedParser;
import com.metamx.common.parsers.JSONParser;
import com.metamx.common.parsers.Parser;
import io.druid.guice.annotations.Json;
import io.druid.query.extraction.namespace.ExtractionNamespace;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nullable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.joda.time.Period;

@JsonTypeName(value="uri")
public class URIExtractionNamespace
implements ExtractionNamespace {
    @JsonProperty
    private final String namespace;
    @JsonProperty
    private final URI uri;
    @JsonProperty
    private final FlatDataParser namespaceParseSpec;
    @JsonProperty
    private final Period pollPeriod;
    @JsonProperty
    private final String versionRegex;

    @JsonCreator
    public URIExtractionNamespace(@NotNull @JsonProperty(value="namespace", required=true) String namespace, @NotNull @JsonProperty(value="uri", required=true) URI uri, @JsonProperty(value="namespaceParseSpec", required=true) FlatDataParser namespaceParseSpec, @Min(value=0L) @Nullable @JsonProperty(value="pollPeriod", required=false) Period pollPeriod, @JsonProperty(value="versionRegex", required=false) String versionRegex) {
        if (versionRegex != null) {
            try {
                Pattern.compile(versionRegex);
            }
            catch (PatternSyntaxException ex) {
                throw new IAE((Throwable)ex, "Could not parse `versionRegex` [%s]", new Object[]{versionRegex});
            }
        }
        this.namespace = (String)Preconditions.checkNotNull((Object)namespace, (Object)"namespace");
        this.uri = (URI)Preconditions.checkNotNull((Object)uri, (Object)"uri");
        this.namespaceParseSpec = (FlatDataParser)Preconditions.checkNotNull((Object)namespaceParseSpec, (Object)"namespaceParseSpec");
        this.pollPeriod = pollPeriod == null ? Period.ZERO : pollPeriod;
        this.versionRegex = versionRegex;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public String getVersionRegex() {
        return this.versionRegex;
    }

    public FlatDataParser getNamespaceParseSpec() {
        return this.namespaceParseSpec;
    }

    public URI getUri() {
        return this.uri;
    }

    @Override
    public long getPollMs() {
        return this.pollPeriod.toStandardDuration().getMillis();
    }

    public String toString() {
        return String.format("URIExtractionNamespace = { namespace = %s, uri = %s, namespaceParseSpec = %s, pollPeriod = %s, versionRegex = %s }", this.namespace, this.uri.toString(), this.namespaceParseSpec.toString(), this.pollPeriod.toString(), this.versionRegex);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        URIExtractionNamespace namespace1 = (URIExtractionNamespace)o;
        return this.toString().equals(namespace1.toString());
    }

    public int hashCode() {
        int result = this.namespace.hashCode();
        result = 31 * result + this.uri.hashCode();
        result = 31 * result + this.namespaceParseSpec.hashCode();
        result = 31 * result + this.pollPeriod.hashCode();
        result = 31 * result + (this.versionRegex != null ? this.versionRegex.hashCode() : 0);
        return result;
    }

    @JsonTypeName(value="simpleJson")
    public static class ObjectMapperFlatDataParser
    implements FlatDataParser {
        private final Parser<String, String> parser;

        @JsonCreator
        public ObjectMapperFlatDataParser(final @JacksonInject @Json ObjectMapper jsonMapper) {
            this.parser = new Parser<String, String>(){

                public Map<String, String> parse(String input) {
                    try {
                        return (Map)jsonMapper.readValue(input, (TypeReference)new TypeReference<Map<String, String>>(){});
                    }
                    catch (IOException e) {
                        throw Throwables.propagate((Throwable)e);
                    }
                }

                public void setFieldNames(Iterable<String> fieldNames) {
                    throw new UOE("No field names available", new Object[0]);
                }

                public List<String> getFieldNames() {
                    throw new UOE("No field names available", new Object[0]);
                }
            };
        }

        @Override
        public Parser<String, String> getParser() {
            return this.parser;
        }

        public String toString() {
            return "ObjectMapperFlatDataParser = { }";
        }
    }

    @JsonTypeName(value="customJson")
    public static class JSONFlatDataParser
    implements FlatDataParser {
        private final Parser<String, String> parser;
        private final String keyFieldName;
        private final String valueFieldName;

        @JsonCreator
        public JSONFlatDataParser(@JacksonInject @Json ObjectMapper jsonMapper, @JsonProperty(value="keyFieldName") String keyFieldName, @JsonProperty(value="valueFieldName") String valueFieldName) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)keyFieldName) ? 1 : 0) != 0, (Object)"[keyFieldName] cannot be empty");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)valueFieldName) ? 1 : 0) != 0, (Object)"[valueFieldName] cannot be empty");
            this.keyFieldName = keyFieldName;
            this.valueFieldName = valueFieldName;
            this.parser = new DelegateParser((Parser)new JSONParser(jsonMapper, (Iterable)ImmutableList.of((Object)keyFieldName, (Object)valueFieldName)), keyFieldName, valueFieldName);
        }

        @JsonProperty
        public String getKeyFieldName() {
            return this.keyFieldName;
        }

        @JsonProperty
        public String getValueFieldName() {
            return this.valueFieldName;
        }

        @Override
        public Parser<String, String> getParser() {
            return this.parser;
        }

        public String toString() {
            return String.format("JSONFlatDataParser = { keyFieldName = %s, valueFieldName = %s }", this.keyFieldName, this.valueFieldName);
        }
    }

    @JsonTypeName(value="tsv")
    public static class TSVFlatDataParser
    implements FlatDataParser {
        private final Parser<String, String> parser;
        private final List<String> columns;
        private final String delimiter;
        private final String keyColumn;
        private final String valueColumn;

        @JsonCreator
        public TSVFlatDataParser(@JsonProperty(value="columns") List<String> columns, @JsonProperty(value="delimiter") String delimiter, @JsonProperty(value="keyColumn") String keyColumn, @JsonProperty(value="valueColumn") String valueColumn) {
            Preconditions.checkArgument((((List)Preconditions.checkNotNull(columns, (Object)"`columns` list required")).size() > 1 ? 1 : 0) != 0, (Object)"Must specify more than one column to have a key value pair");
            DelimitedParser delegate = new DelimitedParser(Optional.fromNullable((Object)(Strings.isNullOrEmpty((String)delimiter) ? null : delimiter)), Optional.absent());
            Preconditions.checkArgument((!(Strings.isNullOrEmpty((String)keyColumn) ^ Strings.isNullOrEmpty((String)valueColumn)) ? 1 : 0) != 0, (Object)"Must specify both `keyColumn` and `valueColumn` or neither `keyColumn` nor `valueColumn`");
            delegate.setFieldNames(columns);
            this.columns = columns;
            this.delimiter = delimiter;
            this.keyColumn = Strings.isNullOrEmpty((String)keyColumn) ? columns.get(0) : keyColumn;
            this.valueColumn = Strings.isNullOrEmpty((String)valueColumn) ? columns.get(1) : valueColumn;
            Preconditions.checkArgument((boolean)columns.contains(this.keyColumn), (String)"Column [%s] not found int columns: %s", (Object[])new Object[]{this.keyColumn, Arrays.toString(columns.toArray())});
            Preconditions.checkArgument((boolean)columns.contains(this.valueColumn), (String)"Column [%s] not found int columns: %s", (Object[])new Object[]{this.valueColumn, Arrays.toString(columns.toArray())});
            this.parser = new DelegateParser((Parser)delegate, this.keyColumn, this.valueColumn);
        }

        @JsonProperty
        public List<String> getColumns() {
            return this.columns;
        }

        @JsonProperty
        public String getKeyColumn() {
            return this.keyColumn;
        }

        @JsonProperty
        public String getValueColumn() {
            return this.valueColumn;
        }

        @JsonProperty
        public String getDelimiter() {
            return this.delimiter;
        }

        @Override
        public Parser<String, String> getParser() {
            return this.parser;
        }

        public String toString() {
            return String.format("TSVFlatDataParser = { columns = %s, delimiter = '%s', keyColumn = %s, valueColumn = %s }", Arrays.toString(this.columns.toArray()), this.delimiter, this.keyColumn, this.valueColumn);
        }
    }

    @JsonTypeName(value="csv")
    public static class CSVFlatDataParser
    implements FlatDataParser {
        private final Parser<String, String> parser;
        private final List<String> columns;
        private final String keyColumn;
        private final String valueColumn;

        @JsonCreator
        public CSVFlatDataParser(@JsonProperty(value="columns") List<String> columns, @JsonProperty(value="keyColumn") String keyColumn, @JsonProperty(value="valueColumn") String valueColumn) {
            Preconditions.checkArgument((((List)Preconditions.checkNotNull(columns, (Object)"`columns` list required")).size() > 1 ? 1 : 0) != 0, (Object)"Must specify more than one column to have a key value pair");
            Preconditions.checkArgument((!(Strings.isNullOrEmpty((String)keyColumn) ^ Strings.isNullOrEmpty((String)valueColumn)) ? 1 : 0) != 0, (Object)"Must specify both `keyColumn` and `valueColumn` or neither `keyColumn` nor `valueColumn`");
            this.columns = columns;
            this.keyColumn = Strings.isNullOrEmpty((String)keyColumn) ? columns.get(0) : keyColumn;
            this.valueColumn = Strings.isNullOrEmpty((String)valueColumn) ? columns.get(1) : valueColumn;
            Preconditions.checkArgument((boolean)columns.contains(this.keyColumn), (String)"Column [%s] not found int columns: %s", (Object[])new Object[]{this.keyColumn, Arrays.toString(columns.toArray())});
            Preconditions.checkArgument((boolean)columns.contains(this.valueColumn), (String)"Column [%s] not found int columns: %s", (Object[])new Object[]{this.valueColumn, Arrays.toString(columns.toArray())});
            this.parser = new DelegateParser((Parser)new CSVParser(Optional.absent(), columns), this.keyColumn, this.valueColumn);
        }

        @JsonProperty
        public List<String> getColumns() {
            return this.columns;
        }

        @JsonProperty
        public String getKeyColumn() {
            return this.keyColumn;
        }

        @JsonProperty
        public String getValueColumn() {
            return this.valueColumn;
        }

        @Override
        public Parser<String, String> getParser() {
            return this.parser;
        }

        public String toString() {
            return String.format("CSVFlatDataParser = { columns = %s, keyColumn = %s, valueColumn = %s }", Arrays.toString(this.columns.toArray()), this.keyColumn, this.valueColumn);
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="format")
    @JsonSubTypes(value={@JsonSubTypes.Type(name="csv", value=CSVFlatDataParser.class), @JsonSubTypes.Type(name="tsv", value=TSVFlatDataParser.class), @JsonSubTypes.Type(name="customJson", value=JSONFlatDataParser.class), @JsonSubTypes.Type(name="simpleJson", value=ObjectMapperFlatDataParser.class)})
    public static interface FlatDataParser {
        public Parser<String, String> getParser();
    }

    private static class DelegateParser
    implements Parser<String, String> {
        private final Parser<String, Object> delegate;
        private final String key;
        private final String value;

        private DelegateParser(Parser<String, Object> delegate, @NotNull String key, @NotNull String value) {
            this.delegate = delegate;
            this.key = key;
            this.value = value;
        }

        public Map<String, String> parse(String input) {
            Map inner = this.delegate.parse(input);
            String k = Preconditions.checkNotNull(inner.get(this.key), (String)"Key column [%s] missing data in line [%s]", (Object[])new Object[]{this.key, input}).toString();
            String val = Preconditions.checkNotNull(inner.get(this.value), (String)"Value column [%s] missing data in line [%s]", (Object[])new Object[]{this.value, input}).toString();
            return ImmutableMap.of((Object)k, (Object)val);
        }

        public void setFieldNames(Iterable<String> fieldNames) {
            this.delegate.setFieldNames(fieldNames);
        }

        public List<String> getFieldNames() {
            return this.delegate.getFieldNames();
        }
    }
}

