/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.namespace;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.metamx.common.Pair;
import io.druid.query.extraction.namespace.ExtractionNamespaceFunctionFactory;
import io.druid.query.extraction.namespace.JDBCExtractionNamespace;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.TimestampMapper;

public class JDBCExtractionNamespaceFunctionFactory
implements ExtractionNamespaceFunctionFactory<JDBCExtractionNamespace> {
    private final ConcurrentMap<String, DBI> dbiCache = new ConcurrentHashMap<String, DBI>();

    @Override
    public Function<String, String> buildFn(JDBCExtractionNamespace extractionNamespace, final Map<String, String> cache) {
        return new Function<String, String>(){

            @Nullable
            public String apply(String input) {
                if (Strings.isNullOrEmpty((String)input)) {
                    return null;
                }
                return Strings.emptyToNull((String)((String)cache.get(input)));
            }
        };
    }

    @Override
    public Function<String, List<String>> buildReverseFn(JDBCExtractionNamespace extractionNamespace, final Map<String, String> cache) {
        return new Function<String, List<String>>(){

            @Nullable
            public List<String> apply(final @Nullable String value) {
                return Lists.newArrayList(Maps.filterKeys((Map)cache, (Predicate)new Predicate<String>(){

                    public boolean apply(@Nullable String key) {
                        return ((String)cache.get(key)).equals(Strings.nullToEmpty((String)value));
                    }
                }).keySet());
            }
        };
    }

    @Override
    public Callable<String> getCachePopulator(final JDBCExtractionNamespace namespace, final String lastVersion, final Map<String, String> cache) {
        long lastCheck = lastVersion == null ? -4611686018427387904L : Long.parseLong(lastVersion);
        Long lastDBUpdate = this.lastUpdates(namespace);
        if (lastDBUpdate != null && lastDBUpdate <= lastCheck) {
            return new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return lastVersion;
                }
            };
        }
        return new Callable<String>(){

            @Override
            public String call() {
                DBI dbi = JDBCExtractionNamespaceFunctionFactory.this.ensureDBI(namespace);
                final String table = namespace.getTable();
                final String valueColumn = namespace.getValueColumn();
                final String keyColumn = namespace.getKeyColumn();
                List pairs = (List)dbi.withHandle((HandleCallback)new HandleCallback<List<Pair<String, String>>>(){

                    public List<Pair<String, String>> withHandle(Handle handle) throws Exception {
                        String query = String.format("SELECT %s, %s FROM %s", keyColumn, valueColumn, table);
                        return handle.createQuery(query).map((ResultSetMapper)new ResultSetMapper<Pair<String, String>>(){

                            public Pair<String, String> map(int index, ResultSet r, StatementContext ctx) throws SQLException {
                                return new Pair((Object)r.getString(keyColumn), (Object)r.getString(valueColumn));
                            }
                        }).list();
                    }
                });
                for (Pair pair : pairs) {
                    cache.put(pair.lhs, pair.rhs);
                }
                return String.format("%d", System.currentTimeMillis());
            }
        };
    }

    private DBI ensureDBI(JDBCExtractionNamespace namespace) {
        String key = namespace.getNamespace();
        DBI dbi = null;
        if (this.dbiCache.containsKey(key)) {
            dbi = (DBI)this.dbiCache.get(key);
        }
        if (dbi == null) {
            DBI newDbi = new DBI(namespace.getConnectorConfig().getConnectURI(), namespace.getConnectorConfig().getUser(), namespace.getConnectorConfig().getPassword());
            this.dbiCache.putIfAbsent(key, newDbi);
            dbi = (DBI)this.dbiCache.get(key);
        }
        return dbi;
    }

    private Long lastUpdates(JDBCExtractionNamespace namespace) {
        DBI dbi = this.ensureDBI(namespace);
        final String table = namespace.getTable();
        final String tsColumn = namespace.getTsColumn();
        if (tsColumn == null) {
            return null;
        }
        Timestamp update = (Timestamp)dbi.withHandle((HandleCallback)new HandleCallback<Timestamp>(){

            public Timestamp withHandle(Handle handle) throws Exception {
                String query = String.format("SELECT MAX(%s) FROM %s", tsColumn, table);
                return (Timestamp)handle.createQuery(query).map((ResultSetMapper)TimestampMapper.FIRST).first();
            }
        });
        return update.getTime();
    }
}

