/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.namespace;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.name.Named;
import com.metamx.common.IAE;
import com.metamx.common.lifecycle.LifecycleStart;
import com.metamx.common.lifecycle.LifecycleStop;
import com.metamx.common.logger.Logger;
import io.druid.guice.Jerseys;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.LazySingleton;
import io.druid.guice.LifecycleModule;
import io.druid.guice.ManageLifecycle;
import io.druid.guice.PolyBind;
import io.druid.initialization.DruidModule;
import io.druid.query.extraction.NamespacedExtractor;
import io.druid.query.extraction.namespace.ExtractionNamespace;
import io.druid.query.extraction.namespace.ExtractionNamespaceFunctionFactory;
import io.druid.query.extraction.namespace.JDBCExtractionNamespace;
import io.druid.query.extraction.namespace.URIExtractionNamespace;
import io.druid.server.initialization.NamespaceLookupStaticConfig;
import io.druid.server.namespace.JDBCExtractionNamespaceFunctionFactory;
import io.druid.server.namespace.URIExtractionNamespaceFunctionFactory;
import io.druid.server.namespace.cache.NamespaceExtractionCacheManager;
import io.druid.server.namespace.cache.OffHeapNamespaceExtractionCacheManager;
import io.druid.server.namespace.cache.OnHeapNamespaceExtractionCacheManager;
import io.druid.server.namespace.http.NamespacesCacheResource;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nullable;

public class NamespacedExtractionModule
implements DruidModule {
    private static final Logger log = new Logger(NamespacedExtractionModule.class);
    private static final String TYPE_PREFIX = "druid.query.extraction.namespace.cache.type";
    private static final String STATIC_CONFIG_PREFIX = "druid.query.extraction.namespace";
    private final ConcurrentMap<String, Function<String, String>> fnCache = new ConcurrentHashMap<String, Function<String, String>>();
    private final ConcurrentMap<String, Function<String, List<String>>> reverseFnCache = new ConcurrentHashMap<String, Function<String, List<String>>>();

    public List<? extends Module> getJacksonModules() {
        return ImmutableList.of((Object)new SimpleModule("DruidNamespacedExtractionModule"){

            public void setupModule(Module.SetupContext context) {
                context.registerSubtypes(new Class[]{NamespacedExtractor.class});
                context.registerSubtypes(new Class[]{ExtractionNamespace.class});
            }
        });
    }

    public static MapBinder<Class<? extends ExtractionNamespace>, ExtractionNamespaceFunctionFactory<?>> getNamespaceFactoryMapBinder(Binder binder) {
        return MapBinder.newMapBinder((Binder)binder, (TypeLiteral)new TypeLiteral<Class<? extends ExtractionNamespace>>(){}, (TypeLiteral)new TypeLiteral<ExtractionNamespaceFunctionFactory<?>>(){});
    }

    public void configure(Binder binder) {
        JsonConfigProvider.bind((Binder)binder, (String)STATIC_CONFIG_PREFIX, NamespaceLookupStaticConfig.class);
        PolyBind.createChoiceWithDefault((Binder)binder, (String)TYPE_PREFIX, (Key)Key.get(NamespaceExtractionCacheManager.class), (Key)Key.get(OnHeapNamespaceExtractionCacheManager.class), (String)"onheap").in(LazySingleton.class);
        PolyBind.optionBinder((Binder)binder, (Key)Key.get(NamespaceExtractionCacheManager.class)).addBinding((Object)"offheap").to(OffHeapNamespaceExtractionCacheManager.class).in(LazySingleton.class);
        NamespacedExtractionModule.getNamespaceFactoryMapBinder(binder).addBinding(JDBCExtractionNamespace.class).to(JDBCExtractionNamespaceFunctionFactory.class).in(LazySingleton.class);
        NamespacedExtractionModule.getNamespaceFactoryMapBinder(binder).addBinding(URIExtractionNamespace.class).to(URIExtractionNamespaceFunctionFactory.class).in(LazySingleton.class);
        LifecycleModule.register((Binder)binder, NamespaceStaticConfiguration.class);
        Jerseys.addResource((Binder)binder, NamespacesCacheResource.class);
    }

    @Provides
    @Named(value="namespaceVersionMap")
    @LazySingleton
    public ConcurrentMap<String, String> getVersionMap() {
        return new ConcurrentHashMap<String, String>();
    }

    @Provides
    @Named(value="namespaceExtractionFunctionCache")
    public ConcurrentMap<String, Function<String, String>> getFnCache() {
        return this.fnCache;
    }

    @Provides
    @Named(value="namespaceReverseExtractionFunctionCache")
    public ConcurrentMap<String, Function<String, List<String>>> getReverseFnCache() {
        return this.reverseFnCache;
    }

    @Provides
    @Named(value="dimExtractionNamespace")
    @LazySingleton
    public Function<String, Function<String, String>> getFunctionMaker(final @Named(value="namespaceExtractionFunctionCache") ConcurrentMap<String, Function<String, String>> fnCache) {
        return new Function<String, Function<String, String>>(){

            @Nullable
            public Function<String, String> apply(String namespace) {
                Function fn = (Function)fnCache.get(namespace);
                if (fn == null) {
                    throw new IAE("Namespace [%s] not found", new Object[]{namespace});
                }
                return fn;
            }
        };
    }

    @Provides
    @Named(value="dimReverseExtractionNamespace")
    @LazySingleton
    public Function<String, Function<String, List<String>>> getReverseFunctionMaker(final @Named(value="namespaceReverseExtractionFunctionCache") ConcurrentMap<String, Function<String, List<String>>> reverseFn) {
        return new Function<String, Function<String, List<String>>>(){

            @Nullable
            public Function<String, List<String>> apply(String namespace) {
                Function fn = (Function)reverseFn.get(namespace);
                if (fn == null) {
                    throw new IAE("Namespace reverse function [%s] not found", new Object[]{namespace});
                }
                return fn;
            }
        };
    }

    @ManageLifecycle
    public static class NamespaceStaticConfiguration {
        private NamespaceLookupStaticConfig configuration;
        private NamespaceExtractionCacheManager manager;

        @Inject
        NamespaceStaticConfiguration(NamespaceLookupStaticConfig configuration, NamespaceExtractionCacheManager manager) {
            this.configuration = configuration;
            this.manager = manager;
        }

        @LifecycleStart
        public void start() {
            log.info("Loading configuration as static configuration", new Object[0]);
            this.manager.scheduleOrUpdate(this.configuration.getNamespaces());
            log.info("Loaded %s namespace-lookup configuration", new Object[]{this.configuration.getNamespaces().size()});
        }

        @LifecycleStop
        public void stop() {
        }
    }
}

