/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.namespace;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.ByteSource;
import com.google.inject.Inject;
import com.metamx.common.CompressionUtils;
import com.metamx.common.IAE;
import com.metamx.common.RetryUtils;
import com.metamx.common.logger.Logger;
import io.druid.data.SearchableVersionedDataFinder;
import io.druid.data.input.MapPopulator;
import io.druid.query.extraction.namespace.ExtractionNamespaceFunctionFactory;
import io.druid.query.extraction.namespace.URIExtractionNamespace;
import io.druid.segment.loading.URIDataPuller;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class URIExtractionNamespaceFunctionFactory
implements ExtractionNamespaceFunctionFactory<URIExtractionNamespace> {
    private static final int DEFAULT_NUM_RETRIES = 3;
    private static final Logger log = new Logger(URIExtractionNamespaceFunctionFactory.class);
    private final Map<String, SearchableVersionedDataFinder> pullers;

    @Inject
    public URIExtractionNamespaceFunctionFactory(Map<String, SearchableVersionedDataFinder> pullers) {
        this.pullers = pullers;
    }

    @Override
    public Function<String, String> buildFn(URIExtractionNamespace extractionNamespace, final Map<String, String> cache) {
        return new Function<String, String>(){

            @Nullable
            public String apply(String input) {
                if (Strings.isNullOrEmpty((String)input)) {
                    return null;
                }
                return Strings.emptyToNull((String)((String)cache.get(input)));
            }
        };
    }

    @Override
    public Function<String, List<String>> buildReverseFn(URIExtractionNamespace extractionNamespace, final Map<String, String> cache) {
        return new Function<String, List<String>>(){

            @Nullable
            public List<String> apply(final @Nullable String value) {
                return Lists.newArrayList(Maps.filterKeys((Map)cache, (Predicate)new Predicate<String>(){

                    public boolean apply(@Nullable String key) {
                        return ((String)cache.get(key)).equals(Strings.nullToEmpty((String)value));
                    }
                }).keySet());
            }
        };
    }

    @Override
    public Callable<String> getCachePopulator(final URIExtractionNamespace extractionNamespace, String lastVersion, final Map<String, String> cache) {
        final long lastCached = lastVersion == null ? -4611686018427387904L : Long.parseLong(lastVersion);
        return new Callable<String>(){

            @Override
            public String call() {
                URI originalUri = extractionNamespace.getUri();
                SearchableVersionedDataFinder pullerRaw = (SearchableVersionedDataFinder)URIExtractionNamespaceFunctionFactory.this.pullers.get(originalUri.getScheme());
                if (pullerRaw == null) {
                    throw new IAE("Unknown loader type[%s].  Known types are %s", new Object[]{originalUri.getScheme(), URIExtractionNamespaceFunctionFactory.this.pullers.keySet()});
                }
                if (!(pullerRaw instanceof URIDataPuller)) {
                    throw new IAE("Cannot load data from location [%s]. Data pulling from [%s] not supported", new Object[]{originalUri.toString(), originalUri.getScheme()});
                }
                final URIDataPuller puller = (URIDataPuller)pullerRaw;
                String versionRegex = extractionNamespace.getVersionRegex();
                final URI uri = (URI)pullerRaw.getLatestVersion((Object)originalUri, versionRegex == null ? null : Pattern.compile(versionRegex));
                if (uri == null) {
                    throw new RuntimeException(new FileNotFoundException(String.format("Could not find match for pattern `%s` in [%s] for %s", versionRegex, originalUri, extractionNamespace)));
                }
                final String uriPath = uri.getPath();
                try {
                    return (String)RetryUtils.retry((Callable)new Callable<String>(){

                        @Override
                        public String call() throws Exception {
                            ByteSource source;
                            String version = puller.getVersion(uri);
                            try {
                                long lastModified = Long.parseLong(version);
                                if (lastModified <= lastCached) {
                                    DateTimeFormatter fmt = ISODateTimeFormat.dateTime();
                                    log.debug("URI [%s] for namespace [%s] was las modified [%s] but was last cached [%s]. Skipping ", new Object[]{uri.toString(), extractionNamespace.getNamespace(), fmt.print(lastModified), fmt.print(lastCached)});
                                    return version;
                                }
                            }
                            catch (NumberFormatException ex) {
                                log.debug((Throwable)ex, "Failed to get last modified timestamp. Assuming no timestamp", new Object[0]);
                            }
                            if (CompressionUtils.isGz((String)uriPath)) {
                                log.debug("Loading gz", new Object[0]);
                                source = new ByteSource(){

                                    public InputStream openStream() throws IOException {
                                        return CompressionUtils.gzipInputStream((InputStream)puller.getInputStream(uri));
                                    }
                                };
                            } else {
                                source = new ByteSource(){

                                    public InputStream openStream() throws IOException {
                                        return puller.getInputStream(uri);
                                    }
                                };
                            }
                            long lineCount = new MapPopulator<String, String>(extractionNamespace.getNamespaceParseSpec().getParser()).populate(source, cache);
                            log.info("Finished loading %d lines for namespace [%s]", new Object[]{lineCount, extractionNamespace.getNamespace()});
                            return version;
                        }
                    }, (Predicate)puller.shouldRetryPredicate(), (int)3);
                }
                catch (Exception e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        };
    }
}

