/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.namespace.cache;

import com.google.common.base.Function;
import com.google.common.util.concurrent.Striped;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.metamx.common.lifecycle.Lifecycle;
import com.metamx.emitter.service.ServiceEmitter;
import io.druid.query.extraction.namespace.ExtractionNamespace;
import io.druid.query.extraction.namespace.ExtractionNamespaceFunctionFactory;
import io.druid.server.namespace.cache.NamespaceExtractionCacheManager;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;

public class OnHeapNamespaceExtractionCacheManager
extends NamespaceExtractionCacheManager {
    private final ConcurrentMap<String, ConcurrentMap<String, String>> mapMap = new ConcurrentHashMap<String, ConcurrentMap<String, String>>();
    private final Striped<Lock> nsLocks = Striped.lock((int)32);

    @Inject
    public OnHeapNamespaceExtractionCacheManager(Lifecycle lifecycle, @Named(value="namespaceExtractionFunctionCache") ConcurrentMap<String, Function<String, String>> fnCache, @Named(value="namespaceReverseExtractionFunctionCache") ConcurrentMap<String, Function<String, List<String>>> reverseFnCache, ServiceEmitter emitter, Map<Class<? extends ExtractionNamespace>, ExtractionNamespaceFunctionFactory<?>> namespaceFunctionFactoryMap) {
        super(lifecycle, fnCache, reverseFnCache, emitter, namespaceFunctionFactoryMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean swapAndClearCache(String namespaceKey, String cacheKey) {
        Lock lock = (Lock)this.nsLocks.get((Object)namespaceKey);
        lock.lock();
        try {
            ConcurrentMap cacheMap = (ConcurrentMap)this.mapMap.get(cacheKey);
            if (cacheMap == null) {
                boolean bl = false;
                return bl;
            }
            this.dataSize.addAndGet(cacheMap.size());
            ConcurrentMap<String, String> prior = this.mapMap.put(namespaceKey, cacheMap);
            this.mapMap.remove(cacheKey);
            if (prior != null) {
                this.dataSize.addAndGet(-prior.size());
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public ConcurrentMap<String, String> getCacheMap(String namespaceOrCacheKey) {
        ConcurrentMap map = (ConcurrentMap)this.mapMap.get(namespaceOrCacheKey);
        if (map == null) {
            this.mapMap.putIfAbsent(namespaceOrCacheKey, new ConcurrentHashMap(32));
            map = (ConcurrentMap)this.mapMap.get(namespaceOrCacheKey);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(String namespaceKey) {
        Lock lock = (Lock)this.nsLocks.get((Object)namespaceKey);
        lock.lock();
        try {
            super.delete(namespaceKey);
            boolean bl = this.mapMap.remove(namespaceKey) != null;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }
}

