/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.namespace.http;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.metamx.common.logger.Logger;
import io.druid.server.namespace.cache.NamespaceExtractionCacheManager;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/druid/v1/namespaces")
public class NamespacesCacheResource {
    private static final Logger log = new Logger(NamespacesCacheResource.class);
    private final NamespaceExtractionCacheManager namespaceExtractionCacheManager;

    @Inject
    public NamespacesCacheResource(NamespaceExtractionCacheManager namespaceExtractionCacheManager) {
        this.namespaceExtractionCacheManager = namespaceExtractionCacheManager;
    }

    @GET
    @Produces(value={"application/json", "application/x-jackson-smile"})
    public Response getNamespaces() {
        try {
            return Response.ok().entity(this.namespaceExtractionCacheManager.getKnownNamespaces()).build();
        }
        catch (Exception ex) {
            log.error("Can not get the list of known namespaces", new Object[0]);
            return Response.serverError().entity((Object)Strings.nullToEmpty((String)ex.getMessage())).build();
        }
    }
}

