/*
 * Decompiled with CFR 0.152.
 */
package io.druid.examples.twitter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.metamx.common.logger.Logger;
import io.druid.data.input.Firehose;
import io.druid.data.input.FirehoseFactory;
import io.druid.data.input.InputRow;
import io.druid.data.input.MapBasedInputRow;
import io.druid.data.input.impl.InputRowParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import twitter4j.ConnectionLifeCycleListener;
import twitter4j.GeoLocation;
import twitter4j.HashtagEntity;
import twitter4j.StallWarning;
import twitter4j.Status;
import twitter4j.StatusDeletionNotice;
import twitter4j.StatusListener;
import twitter4j.TwitterStream;
import twitter4j.TwitterStreamFactory;
import twitter4j.User;

@JsonTypeName(value="twitzer")
public class TwitterSpritzerFirehoseFactory
implements FirehoseFactory<InputRowParser> {
    private static final Logger log = new Logger(TwitterSpritzerFirehoseFactory.class);
    private static final Pattern sourcePattern = Pattern.compile("<a[^>]*>(.*?)</a>", 2);
    private final int maxEventCount;
    private final int maxRunMinutes;

    @JsonCreator
    public TwitterSpritzerFirehoseFactory(@JsonProperty(value="maxEventCount") Integer maxEventCount, @JsonProperty(value="maxRunMinutes") Integer maxRunMinutes) {
        this.maxEventCount = maxEventCount;
        this.maxRunMinutes = maxRunMinutes;
        log.info("maxEventCount=" + (maxEventCount <= 0 ? "no limit" : maxEventCount), new Object[0]);
        log.info("maxRunMinutes=" + (maxRunMinutes <= 0 ? "no limit" : maxRunMinutes), new Object[0]);
    }

    public Firehose connect(InputRowParser parser) throws IOException {
        ConnectionLifeCycleListener connectionLifeCycleListener = new ConnectionLifeCycleListener(){

            public void onConnect() {
                log.info("Connected_to_Twitter", new Object[0]);
            }

            public void onDisconnect() {
                log.info("Disconnect_from_Twitter", new Object[0]);
            }

            public void onCleanUp() {
                log.info("Cleanup_twitter_stream", new Object[0]);
            }
        };
        int QUEUE_SIZE = 2000;
        final ArrayBlockingQueue queue = new ArrayBlockingQueue(2000);
        final long startMsec = System.currentTimeMillis();
        final TwitterStream twitterStream = new TwitterStreamFactory().getInstance();
        twitterStream.addConnectionLifeCycleListener(connectionLifeCycleListener);
        StatusListener statusListener = new StatusListener(){

            public void onStatus(Status status) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new RuntimeException("Interrupted, time to stop");
                }
                try {
                    boolean success = queue.offer(status, 15L, TimeUnit.SECONDS);
                    if (!success) {
                        log.warn("queue too slow!", new Object[0]);
                    }
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("InterruptedException", e);
                }
            }

            public void onDeletionNotice(StatusDeletionNotice statusDeletionNotice) {
            }

            public void onTrackLimitationNotice(int numberOfLimitedStatuses) {
                log.warn("Got track limitation notice:" + numberOfLimitedStatuses, new Object[0]);
            }

            public void onScrubGeo(long userId, long upToStatusId) {
            }

            public void onException(Exception ex) {
                ex.printStackTrace();
            }

            public void onStallWarning(StallWarning warning) {
                System.out.println("Got stall warning:" + warning);
            }
        };
        twitterStream.addListener(statusListener);
        twitterStream.sample();
        log.info("returned from sample()", new Object[0]);
        return new Firehose(){
            private final Runnable doNothingRunnable = new Runnable(){

                @Override
                public void run() {
                }
            };
            private long rowCount = 0L;
            private boolean waitIfmax = (long)TwitterSpritzerFirehoseFactory.this.getMaxEventCount() < 0L;
            private final Map<String, Object> theMap = new TreeMap<String, Object>();

            private boolean maxTimeReached() {
                if (TwitterSpritzerFirehoseFactory.this.getMaxRunMinutes() <= 0) {
                    return false;
                }
                return (System.currentTimeMillis() - startMsec) / 60000L >= (long)TwitterSpritzerFirehoseFactory.this.getMaxRunMinutes();
            }

            private boolean maxCountReached() {
                return TwitterSpritzerFirehoseFactory.this.getMaxEventCount() >= 0 && this.rowCount >= (long)TwitterSpritzerFirehoseFactory.this.getMaxEventCount();
            }

            public boolean hasMore() {
                if (this.maxCountReached() || this.maxTimeReached()) {
                    return this.waitIfmax;
                }
                return true;
            }

            public InputRow nextRow() {
                User user;
                Status status;
                if (Thread.currentThread().isInterrupted()) {
                    throw new RuntimeException("Interrupted, time to stop");
                }
                if ((this.maxCountReached() || this.maxTimeReached()) && this.waitIfmax) {
                    try {
                        log.info("reached limit, sleeping a long time...", new Object[0]);
                        Thread.sleep(2000000000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException("InterruptedException", e);
                    }
                }
                if (++this.rowCount % 1000L == 0L) {
                    log.info("nextRow() has returned %,d InputRows", new Object[]{this.rowCount});
                }
                try {
                    status = (Status)queue.take();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("InterruptedException", e);
                }
                this.theMap.clear();
                HashtagEntity[] hts = status.getHashtagEntities();
                String text = status.getText();
                this.theMap.put("text", null == text ? "" : text);
                this.theMap.put("htags", hts.length > 0 ? Lists.transform(Arrays.asList(hts), (Function)new Function<HashtagEntity, String>(){

                    @Nullable
                    public String apply(HashtagEntity input) {
                        return input.getText();
                    }
                }) : ImmutableList.of());
                long[] lcontrobutors = status.getContributors();
                ArrayList<String> contributors = new ArrayList<String>();
                for (long contrib : lcontrobutors) {
                    contributors.add(String.format("%d", contrib));
                }
                this.theMap.put("contributors", contributors);
                GeoLocation geoLocation = status.getGeoLocation();
                if (null != geoLocation) {
                    double lat = status.getGeoLocation().getLatitude();
                    double lon = status.getGeoLocation().getLongitude();
                    this.theMap.put("lat", lat);
                    this.theMap.put("lon", lon);
                } else {
                    this.theMap.put("lat", null);
                    this.theMap.put("lon", null);
                }
                if (status.getSource() != null) {
                    Matcher m = sourcePattern.matcher(status.getSource());
                    this.theMap.put("source", m.find() ? m.group(1) : status.getSource());
                }
                this.theMap.put("retweet", status.isRetweet());
                if (status.isRetweet()) {
                    Status original = status.getRetweetedStatus();
                    this.theMap.put("retweet_count", original.getRetweetCount());
                    User originator = original.getUser();
                    this.theMap.put("originator_screen_name", originator != null ? originator.getScreenName() : "");
                    this.theMap.put("originator_follower_count", originator != null ? Integer.valueOf(originator.getFollowersCount()) : "");
                    this.theMap.put("originator_friends_count", originator != null ? Integer.valueOf(originator.getFriendsCount()) : "");
                    this.theMap.put("originator_verified", originator != null ? Boolean.valueOf(originator.isVerified()) : "");
                }
                boolean hasUser = null != (user = status.getUser());
                this.theMap.put("follower_count", hasUser ? user.getFollowersCount() : 0);
                this.theMap.put("friends_count", hasUser ? user.getFriendsCount() : 0);
                this.theMap.put("lang", hasUser ? user.getLang() : "");
                this.theMap.put("utc_offset", hasUser ? user.getUtcOffset() : -1);
                this.theMap.put("statuses_count", hasUser ? user.getStatusesCount() : 0);
                this.theMap.put("user_id", hasUser ? String.format("%d", user.getId()) : "");
                this.theMap.put("screen_name", hasUser ? user.getScreenName() : "");
                this.theMap.put("location", hasUser ? user.getLocation() : "");
                this.theMap.put("verified", hasUser ? Boolean.valueOf(user.isVerified()) : "");
                this.theMap.put("ts", status.getCreatedAt().getTime());
                ArrayList dimensions = Lists.newArrayList(this.theMap.keySet());
                return new MapBasedInputRow(status.getCreatedAt().getTime(), (List)dimensions, this.theMap);
            }

            public Runnable commit() {
                return this.doNothingRunnable;
            }

            public void close() throws IOException {
                log.info("CLOSE twitterstream", new Object[0]);
                twitterStream.shutdown();
            }
        };
    }

    @JsonProperty
    public int getMaxEventCount() {
        return this.maxEventCount;
    }

    @JsonProperty
    public int getMaxRunMinutes() {
        return this.maxRunMinutes;
    }
}

