/*
 * Decompiled with CFR 0.152.
 */
package io.druid.query.lookup.namespace;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import io.druid.metadata.MetadataStorageConnectorConfig;
import io.druid.query.lookup.namespace.ExtractionNamespace;
import javax.annotation.Nullable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.joda.time.Period;

@JsonTypeName(value="jdbc")
public class JDBCExtractionNamespace
implements ExtractionNamespace {
    @JsonProperty
    private final MetadataStorageConnectorConfig connectorConfig;
    @JsonProperty
    private final String table;
    @JsonProperty
    private final String keyColumn;
    @JsonProperty
    private final String valueColumn;
    @JsonProperty
    private final String tsColumn;
    @JsonProperty
    private final Period pollPeriod;

    @JsonCreator
    public JDBCExtractionNamespace(@NotNull @JsonProperty(value="connectorConfig", required=true) MetadataStorageConnectorConfig connectorConfig, @NotNull @JsonProperty(value="table", required=true) String table, @NotNull @JsonProperty(value="keyColumn", required=true) String keyColumn, @NotNull @JsonProperty(value="valueColumn", required=true) String valueColumn, @Nullable @JsonProperty(value="tsColumn", required=false) String tsColumn, @Min(value=0L) @Nullable @JsonProperty(value="pollPeriod", required=false) Period pollPeriod) {
        this.connectorConfig = (MetadataStorageConnectorConfig)Preconditions.checkNotNull((Object)connectorConfig, (Object)"connectorConfig");
        Preconditions.checkNotNull((Object)connectorConfig.getConnectURI(), (Object)"connectorConfig.connectURI");
        this.table = (String)Preconditions.checkNotNull((Object)table, (Object)"table");
        this.keyColumn = (String)Preconditions.checkNotNull((Object)keyColumn, (Object)"keyColumn");
        this.valueColumn = (String)Preconditions.checkNotNull((Object)valueColumn, (Object)"valueColumn");
        this.tsColumn = tsColumn;
        this.pollPeriod = pollPeriod == null ? new Period(0L) : pollPeriod;
    }

    public MetadataStorageConnectorConfig getConnectorConfig() {
        return this.connectorConfig;
    }

    public String getTable() {
        return this.table;
    }

    public String getKeyColumn() {
        return this.keyColumn;
    }

    public String getValueColumn() {
        return this.valueColumn;
    }

    public String getTsColumn() {
        return this.tsColumn;
    }

    @Override
    public long getPollMs() {
        return this.pollPeriod.toStandardDuration().getMillis();
    }

    public String toString() {
        return String.format("JDBCExtractionNamespace = { connectorConfig = { %s }, table = %s, keyColumn = %s, valueColumn = %s, tsColumn = %s, pollPeriod = %s}", this.connectorConfig.toString(), this.table, this.keyColumn, this.valueColumn, this.tsColumn, this.pollPeriod);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JDBCExtractionNamespace that = (JDBCExtractionNamespace)o;
        if (!this.connectorConfig.equals(that.connectorConfig)) {
            return false;
        }
        if (!this.table.equals(that.table)) {
            return false;
        }
        if (!this.keyColumn.equals(that.keyColumn)) {
            return false;
        }
        if (!this.valueColumn.equals(that.valueColumn)) {
            return false;
        }
        if (this.tsColumn != null ? !this.tsColumn.equals(that.tsColumn) : that.tsColumn != null) {
            return false;
        }
        return this.pollPeriod.equals((Object)that.pollPeriod);
    }

    public int hashCode() {
        int result = this.connectorConfig.hashCode();
        result = 31 * result + this.table.hashCode();
        result = 31 * result + this.keyColumn.hashCode();
        result = 31 * result + this.valueColumn.hashCode();
        result = 31 * result + (this.tsColumn != null ? this.tsColumn.hashCode() : 0);
        result = 31 * result + this.pollPeriod.hashCode();
        return result;
    }
}

