/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.lookup.namespace;

import com.metamx.common.Pair;
import com.metamx.common.logger.Logger;
import io.druid.query.lookup.namespace.ExtractionNamespaceCacheFactory;
import io.druid.query.lookup.namespace.JDBCExtractionNamespace;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.TimestampMapper;

public class JDBCExtractionNamespaceCacheFactory
implements ExtractionNamespaceCacheFactory<JDBCExtractionNamespace> {
    private static final Logger LOG = new Logger(JDBCExtractionNamespaceCacheFactory.class);
    private final ConcurrentMap<String, DBI> dbiCache = new ConcurrentHashMap<String, DBI>();

    @Override
    public Callable<String> getCachePopulator(final String id, final JDBCExtractionNamespace namespace, final String lastVersion, final Map<String, String> cache) {
        long lastCheck = lastVersion == null ? -4611686018427387904L : Long.parseLong(lastVersion);
        Long lastDBUpdate = this.lastUpdates(id, namespace);
        if (lastDBUpdate != null && lastDBUpdate <= lastCheck) {
            return new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return lastVersion;
                }
            };
        }
        return new Callable<String>(){

            @Override
            public String call() {
                DBI dbi = JDBCExtractionNamespaceCacheFactory.this.ensureDBI(id, namespace);
                final String table = namespace.getTable();
                final String valueColumn = namespace.getValueColumn();
                final String keyColumn = namespace.getKeyColumn();
                LOG.debug("Updating [%s]", new Object[]{id});
                List pairs = (List)dbi.withHandle((HandleCallback)new HandleCallback<List<Pair<String, String>>>(){

                    public List<Pair<String, String>> withHandle(Handle handle) throws Exception {
                        String query = String.format("SELECT %s, %s FROM %s", keyColumn, valueColumn, table);
                        return handle.createQuery(query).map((ResultSetMapper)new ResultSetMapper<Pair<String, String>>(){

                            public Pair<String, String> map(int index, ResultSet r, StatementContext ctx) throws SQLException {
                                return new Pair((Object)r.getString(keyColumn), (Object)r.getString(valueColumn));
                            }
                        }).list();
                    }
                });
                for (Pair pair : pairs) {
                    cache.put(pair.lhs, pair.rhs);
                }
                LOG.info("Finished loading %d values for namespace[%s]", new Object[]{cache.size(), id});
                return String.format("%d", System.currentTimeMillis());
            }
        };
    }

    private DBI ensureDBI(String id, JDBCExtractionNamespace namespace) {
        String key = id;
        DBI dbi = null;
        if (this.dbiCache.containsKey(key)) {
            dbi = (DBI)this.dbiCache.get(key);
        }
        if (dbi == null) {
            DBI newDbi = new DBI(namespace.getConnectorConfig().getConnectURI(), namespace.getConnectorConfig().getUser(), namespace.getConnectorConfig().getPassword());
            this.dbiCache.putIfAbsent(key, newDbi);
            dbi = (DBI)this.dbiCache.get(key);
        }
        return dbi;
    }

    private Long lastUpdates(String id, JDBCExtractionNamespace namespace) {
        DBI dbi = this.ensureDBI(id, namespace);
        final String table = namespace.getTable();
        final String tsColumn = namespace.getTsColumn();
        if (tsColumn == null) {
            return null;
        }
        Timestamp update = (Timestamp)dbi.withHandle((HandleCallback)new HandleCallback<Timestamp>(){

            public Timestamp withHandle(Handle handle) throws Exception {
                String query = String.format("SELECT MAX(%s) FROM %s", tsColumn, table);
                return (Timestamp)handle.createQuery(query).map((ResultSetMapper)TimestampMapper.FIRST).first();
            }
        });
        return update.getTime();
    }
}

