/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.lookup.namespace.cache;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Striped;
import com.google.inject.Inject;
import com.metamx.common.lifecycle.Lifecycle;
import com.metamx.common.logger.Logger;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.emitter.service.ServiceMetricEvent;
import io.druid.query.lookup.namespace.ExtractionNamespace;
import io.druid.query.lookup.namespace.ExtractionNamespaceCacheFactory;
import io.druid.server.lookup.namespace.cache.NamespaceExtractionCacheManager;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;

public class OffHeapNamespaceExtractionCacheManager
extends NamespaceExtractionCacheManager {
    private static final Logger log = new Logger(OffHeapNamespaceExtractionCacheManager.class);
    private final DB mmapDB;
    private ConcurrentMap<String, String> currentNamespaceCache = new ConcurrentHashMap<String, String>();
    private Striped<Lock> nsLocks = Striped.lock((int)32);
    private final File tmpFile;

    @Inject
    public OffHeapNamespaceExtractionCacheManager(Lifecycle lifecycle, ServiceEmitter emitter, Map<Class<? extends ExtractionNamespace>, ExtractionNamespaceCacheFactory<?>> namespaceFunctionFactoryMap) {
        super(lifecycle, emitter, namespaceFunctionFactoryMap);
        try {
            this.tmpFile = File.createTempFile("druidMapDB", this.getClass().getCanonicalName());
            log.info("Using file [%s] for mapDB off heap namespace cache", new Object[]{this.tmpFile.getAbsolutePath()});
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        this.mmapDB = DBMaker.newFileDB((File)this.tmpFile).closeOnJvmShutdown().transactionDisable().deleteFilesAfterClose().strictDBGet().asyncWriteEnable().mmapFileEnable().commitFileSyncDisable().cacheSize(10000000).make();
        try {
            lifecycle.addMaybeStartHandler(new Lifecycle.Handler(){

                public void start() throws Exception {
                }

                public synchronized void stop() {
                    if (!OffHeapNamespaceExtractionCacheManager.this.mmapDB.isClosed()) {
                        OffHeapNamespaceExtractionCacheManager.this.mmapDB.close();
                        if (!OffHeapNamespaceExtractionCacheManager.this.tmpFile.delete()) {
                            log.warn("Unable to delete file at [%s]", new Object[]{OffHeapNamespaceExtractionCacheManager.this.tmpFile.getAbsolutePath()});
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean swapAndClearCache(String namespaceKey, String cacheKey) {
        Lock lock = (Lock)this.nsLocks.get((Object)namespaceKey);
        lock.lock();
        try {
            Preconditions.checkArgument((boolean)this.mmapDB.exists(cacheKey), (String)"Namespace [%s] does not exist", (Object[])new Object[]{cacheKey});
            String swapCacheKey = UUID.randomUUID().toString();
            this.mmapDB.rename(cacheKey, swapCacheKey);
            String priorCache = this.currentNamespaceCache.put(namespaceKey, swapCacheKey);
            if (priorCache != null) {
                this.mmapDB.delete(priorCache);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(String namespaceKey) {
        Lock lock = (Lock)this.nsLocks.get((Object)namespaceKey);
        lock.lock();
        try {
            if (super.delete(namespaceKey)) {
                String mmapDBkey = (String)this.currentNamespaceCache.get(namespaceKey);
                if (mmapDBkey != null) {
                    long pre = this.tmpFile.length();
                    this.mmapDB.delete(mmapDBkey);
                    log.debug("MapDB file size: pre %d  post %d", new Object[]{pre, this.tmpFile.length()});
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConcurrentMap<String, String> getCacheMap(String namespaceOrCacheKey) {
        Lock lock = (Lock)this.nsLocks.get((Object)namespaceOrCacheKey);
        lock.lock();
        try {
            Lock nsLock;
            String realKey = (String)this.currentNamespaceCache.get(namespaceOrCacheKey);
            if (realKey == null) {
                realKey = namespaceOrCacheKey;
            }
            if (lock != (nsLock = (Lock)this.nsLocks.get((Object)realKey))) {
                nsLock.lock();
            }
            try {
                HTreeMap hTreeMap = this.mmapDB.createHashMap(realKey).makeOrGet();
                if (lock != nsLock) {
                    nsLock.unlock();
                }
                return hTreeMap;
            }
            catch (Throwable throwable) {
                if (lock != nsLock) {
                    nsLock.unlock();
                }
                throw throwable;
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    protected void monitor(ServiceEmitter serviceEmitter) {
        serviceEmitter.emit(ServiceMetricEvent.builder().build("namespace/cache/diskSize", (Number)this.tmpFile.length()));
    }
}

