/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexer;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Closeables;
import com.metamx.common.ISE;
import com.metamx.common.logger.Logger;
import io.druid.data.input.InputRow;
import io.druid.data.input.Rows;
import io.druid.granularity.QueryGranularity;
import io.druid.indexer.HadoopDruidIndexerConfig;
import io.druid.indexer.HadoopDruidIndexerMapper;
import io.druid.indexer.HadoopyShardSpec;
import io.druid.indexer.JobHelper;
import io.druid.indexer.Jobby;
import io.druid.indexer.Utils;
import io.druid.query.aggregation.hyperloglog.HyperLogLogCollector;
import io.druid.segment.indexing.granularity.GranularitySpec;
import io.druid.segment.indexing.granularity.UniformGranularitySpec;
import io.druid.timeline.partition.HashBasedNumberedShardSpec;
import io.druid.timeline.partition.NoneShardSpec;
import io.druid.timeline.partition.ShardSpec;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.joda.time.DateTime;
import org.joda.time.DateTimeComparator;
import org.joda.time.Interval;

public class DetermineHashedPartitionsJob
implements Jobby {
    private static final Logger log = new Logger(DetermineHashedPartitionsJob.class);
    private final HadoopDruidIndexerConfig config;

    public DetermineHashedPartitionsJob(HadoopDruidIndexerConfig config) {
        this.config = config;
    }

    public boolean run() {
        try {
            long startTime = System.currentTimeMillis();
            Job groupByJob = Job.getInstance((Configuration)new Configuration(), (String)String.format("%s-determine_partitions_hashed-%s", this.config.getDataSource(), this.config.getIntervals()));
            JobHelper.injectSystemProperties(groupByJob);
            this.config.addJobProperties(groupByJob);
            groupByJob.setMapperClass(DetermineCardinalityMapper.class);
            groupByJob.setMapOutputKeyClass(LongWritable.class);
            groupByJob.setMapOutputValueClass(BytesWritable.class);
            groupByJob.setReducerClass(DetermineCardinalityReducer.class);
            groupByJob.setOutputKeyClass(NullWritable.class);
            groupByJob.setOutputValueClass(NullWritable.class);
            groupByJob.setOutputFormatClass(SequenceFileOutputFormat.class);
            groupByJob.setPartitionerClass(DetermineHashedPartitionsPartitioner.class);
            if (!this.config.getSegmentGranularIntervals().isPresent()) {
                groupByJob.setNumReduceTasks(1);
            } else {
                groupByJob.setNumReduceTasks(((Set)this.config.getSegmentGranularIntervals().get()).size());
            }
            JobHelper.setupClasspath(JobHelper.distributedClassPath(this.config.getWorkingPath()), JobHelper.distributedClassPath(this.config.makeIntermediatePath()), groupByJob);
            this.config.addInputPaths(groupByJob);
            this.config.intoConfiguration(groupByJob);
            FileOutputFormat.setOutputPath((Job)groupByJob, (Path)this.config.makeGroupedDataDir());
            groupByJob.submit();
            log.info("Job %s submitted, status available at: %s", new Object[]{groupByJob.getJobName(), groupByJob.getTrackingURL()});
            if (!groupByJob.waitForCompletion(true)) {
                log.error("Job failed: %s", new Object[]{groupByJob.getJobID()});
                return false;
            }
            log.info("Job completed, loading up partitions for intervals[%s].", new Object[]{this.config.getSegmentGranularIntervals()});
            FileSystem fileSystem = null;
            if (!this.config.getSegmentGranularIntervals().isPresent()) {
                Path intervalInfoPath = this.config.makeIntervalInfoPath();
                fileSystem = intervalInfoPath.getFileSystem(groupByJob.getConfiguration());
                if (!Utils.exists((JobContext)groupByJob, fileSystem, intervalInfoPath)) {
                    throw new ISE("Path[%s] didn't exist!?", new Object[]{intervalInfoPath});
                }
                List intervals = (List)HadoopDruidIndexerConfig.JSON_MAPPER.readValue(Utils.openInputStream((JobContext)groupByJob, intervalInfoPath), (TypeReference)new TypeReference<List<Interval>>(){});
                this.config.setGranularitySpec((GranularitySpec)new UniformGranularitySpec(this.config.getGranularitySpec().getSegmentGranularity(), this.config.getGranularitySpec().getQueryGranularity(), intervals));
                log.info("Determined Intervals for Job [%s]" + this.config.getSegmentGranularIntervals(), new Object[0]);
            }
            TreeMap shardSpecs = Maps.newTreeMap((Comparator)DateTimeComparator.getInstance());
            int shardCount = 0;
            for (Interval segmentGranularity : (Set)this.config.getSegmentGranularIntervals().get()) {
                DateTime bucket = segmentGranularity.getStart();
                Path partitionInfoPath = this.config.makeSegmentPartitionInfoPath(segmentGranularity);
                if (fileSystem == null) {
                    fileSystem = partitionInfoPath.getFileSystem(groupByJob.getConfiguration());
                }
                if (Utils.exists((JobContext)groupByJob, fileSystem, partitionInfoPath)) {
                    Long numRows = (Long)HadoopDruidIndexerConfig.JSON_MAPPER.readValue(Utils.openInputStream((JobContext)groupByJob, partitionInfoPath), (TypeReference)new TypeReference<Long>(){});
                    log.info("Found approximately [%,d] rows in data.", new Object[]{numRows});
                    int numberOfShards = (int)Math.ceil((double)numRows.longValue() / (double)this.config.getTargetPartitionSize().longValue());
                    log.info("Creating [%,d] shards", new Object[]{numberOfShards});
                    ArrayList actualSpecs = Lists.newArrayListWithExpectedSize((int)numberOfShards);
                    if (numberOfShards == 1) {
                        actualSpecs.add(new HadoopyShardSpec((ShardSpec)new NoneShardSpec(), shardCount++));
                    } else {
                        for (int i = 0; i < numberOfShards; ++i) {
                            actualSpecs.add(new HadoopyShardSpec((ShardSpec)new HashBasedNumberedShardSpec(i, numberOfShards, null, HadoopDruidIndexerConfig.JSON_MAPPER), shardCount++));
                            log.info("DateTime[%s], partition[%d], spec[%s]", new Object[]{bucket, i, actualSpecs.get(i)});
                        }
                    }
                    shardSpecs.put(bucket, actualSpecs);
                    continue;
                }
                log.info("Path[%s] didn't exist!?", new Object[]{partitionInfoPath});
            }
            this.config.setShardSpecs(shardSpecs);
            log.info("DetermineHashedPartitionsJob took %d millis", new Object[]{System.currentTimeMillis() - startTime});
            return true;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static class DetermineHashedPartitionsPartitioner
    extends Partitioner<LongWritable, BytesWritable>
    implements Configurable {
        private Configuration config;
        private boolean determineIntervals;
        private Map<LongWritable, Integer> reducerLookup;

        public int getPartition(LongWritable interval, BytesWritable text, int numPartitions) {
            if (this.config.get("mapred.job.tracker").equals("local") || this.determineIntervals) {
                return 0;
            }
            return this.reducerLookup.get(interval);
        }

        public Configuration getConf() {
            return this.config;
        }

        public void setConf(Configuration config) {
            this.config = config;
            HadoopDruidIndexerConfig hadoopConfig = HadoopDruidIndexerConfig.fromConfiguration(config);
            if (hadoopConfig.getSegmentGranularIntervals().isPresent()) {
                this.determineIntervals = false;
                int reducerNumber = 0;
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (Interval interval : (Set)hadoopConfig.getSegmentGranularIntervals().get()) {
                    builder.put((Object)new LongWritable(interval.getStartMillis()), (Object)reducerNumber++);
                }
                this.reducerLookup = builder.build();
            } else {
                this.determineIntervals = true;
            }
        }
    }

    public static class DetermineCardinalityReducer
    extends Reducer<LongWritable, BytesWritable, NullWritable, NullWritable> {
        private final List<Interval> intervals = Lists.newArrayList();
        protected HadoopDruidIndexerConfig config = null;

        protected void setup(Reducer.Context context) throws IOException, InterruptedException {
            this.config = HadoopDruidIndexerConfig.fromConfiguration(context.getConfiguration());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void reduce(LongWritable key, Iterable<BytesWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            HyperLogLogCollector aggregate = HyperLogLogCollector.makeLatestCollector();
            for (BytesWritable value : values) {
                aggregate.fold(ByteBuffer.wrap(value.getBytes(), 0, value.getLength()));
            }
            Interval interval = this.config.getGranularitySpec().getSegmentGranularity().bucket(new DateTime(key.get()));
            this.intervals.add(interval);
            Path outPath = this.config.makeSegmentPartitionInfoPath(interval);
            OutputStream out = Utils.makePathAndOutputStream((JobContext)context, outPath, this.config.isOverwriteFiles());
            try {
                HadoopDruidIndexerConfig.JSON_MAPPER.writerWithType((TypeReference)new TypeReference<Long>(){}).writeValue(out, (Object)new Double(aggregate.estimateCardinality()).longValue());
            }
            finally {
                Closeables.close((Closeable)out, (boolean)false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(Reducer.Context context) throws IOException, InterruptedException {
            super.run(context);
            if (!this.config.getSegmentGranularIntervals().isPresent()) {
                Path outPath = this.config.makeIntervalInfoPath();
                OutputStream out = Utils.makePathAndOutputStream((JobContext)context, outPath, this.config.isOverwriteFiles());
                try {
                    HadoopDruidIndexerConfig.JSON_MAPPER.writerWithType((TypeReference)new TypeReference<List<Interval>>(){}).writeValue(out, this.intervals);
                }
                finally {
                    Closeables.close((Closeable)out, (boolean)false);
                }
            }
        }
    }

    public static class DetermineCardinalityMapper
    extends HadoopDruidIndexerMapper<LongWritable, BytesWritable> {
        private static HashFunction hashFunction = Hashing.murmur3_128();
        private QueryGranularity rollupGranularity = null;
        private Map<Interval, HyperLogLogCollector> hyperLogLogs;
        private HadoopDruidIndexerConfig config;
        private boolean determineIntervals;

        @Override
        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            super.setup(context);
            this.rollupGranularity = this.getConfig().getGranularitySpec().getQueryGranularity();
            this.config = HadoopDruidIndexerConfig.fromConfiguration(context.getConfiguration());
            Optional<Set<Interval>> intervals = this.config.getSegmentGranularIntervals();
            if (intervals.isPresent()) {
                this.determineIntervals = false;
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (Interval bucketInterval : (Set)intervals.get()) {
                    builder.put((Object)bucketInterval, (Object)HyperLogLogCollector.makeLatestCollector());
                }
                this.hyperLogLogs = builder.build();
            } else {
                this.determineIntervals = true;
                this.hyperLogLogs = Maps.newHashMap();
            }
        }

        @Override
        protected void innerMap(InputRow inputRow, Object value, Mapper.Context context) throws IOException, InterruptedException {
            Interval interval;
            List groupKey = Rows.toGroupKey((long)this.rollupGranularity.truncate(inputRow.getTimestampFromEpoch()), (InputRow)inputRow);
            if (this.determineIntervals) {
                interval = this.config.getGranularitySpec().getSegmentGranularity().bucket(new DateTime(inputRow.getTimestampFromEpoch()));
                if (!this.hyperLogLogs.containsKey(interval)) {
                    this.hyperLogLogs.put(interval, HyperLogLogCollector.makeLatestCollector());
                }
            } else {
                Optional maybeInterval = this.config.getGranularitySpec().bucketInterval(new DateTime(inputRow.getTimestampFromEpoch()));
                if (!maybeInterval.isPresent()) {
                    throw new ISE("WTF?! No bucket found for timestamp: %s", new Object[]{inputRow.getTimestampFromEpoch()});
                }
                interval = (Interval)maybeInterval.get();
            }
            this.hyperLogLogs.get(interval).add(hashFunction.hashBytes(HadoopDruidIndexerConfig.JSON_MAPPER.writeValueAsBytes((Object)groupKey)).asBytes());
        }

        public void run(Mapper.Context context) throws IOException, InterruptedException {
            this.setup(context);
            while (context.nextKeyValue()) {
                this.map(context.getCurrentKey(), context.getCurrentValue(), context);
            }
            for (Map.Entry<Interval, HyperLogLogCollector> entry : this.hyperLogLogs.entrySet()) {
                context.write((Object)new LongWritable(entry.getKey().getStartMillis()), (Object)new BytesWritable(entry.getValue().toByteArray()));
            }
            this.cleanup(context);
        }
    }
}

