/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.metamx.common.logger.Logger;
import io.druid.indexer.HadoopDruidIndexerConfig;
import io.druid.indexer.HadoopyShardSpec;
import io.druid.indexer.JobHelper;
import io.druid.indexer.Jobby;
import io.druid.timeline.partition.HashBasedNumberedShardSpec;
import io.druid.timeline.partition.NoneShardSpec;
import io.druid.timeline.partition.ShardSpec;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeMap;
import org.joda.time.DateTime;
import org.joda.time.DateTimeComparator;
import org.joda.time.Interval;

public class HadoopDruidDetermineConfigurationJob
implements Jobby {
    private static final Logger log = new Logger(HadoopDruidDetermineConfigurationJob.class);
    private final HadoopDruidIndexerConfig config;

    @Inject
    public HadoopDruidDetermineConfigurationJob(HadoopDruidIndexerConfig config) {
        this.config = config;
    }

    public boolean run() {
        ArrayList jobs = Lists.newArrayList();
        JobHelper.ensurePaths(this.config);
        if (this.config.isDeterminingPartitions()) {
            jobs.add(this.config.getPartitionsSpec().getPartitionJob(this.config));
        } else {
            int shardsPerInterval = this.config.getPartitionsSpec().getNumShards();
            TreeMap shardSpecs = Maps.newTreeMap((Comparator)DateTimeComparator.getInstance());
            int shardCount = 0;
            for (Interval segmentGranularity : (Set)this.config.getSegmentGranularIntervals().get()) {
                DateTime bucket = segmentGranularity.getStart();
                if (shardsPerInterval > 0) {
                    ArrayList specs = Lists.newArrayListWithCapacity((int)shardsPerInterval);
                    for (int i = 0; i < shardsPerInterval; ++i) {
                        specs.add(new HadoopyShardSpec((ShardSpec)new HashBasedNumberedShardSpec(i, shardsPerInterval, this.config.getPartitionsSpec().getPartitionDimensions(), HadoopDruidIndexerConfig.JSON_MAPPER), shardCount++));
                    }
                    shardSpecs.put(bucket, specs);
                    log.info("DateTime[%s], spec[%s]", new Object[]{bucket, specs});
                    continue;
                }
                HadoopyShardSpec spec = new HadoopyShardSpec((ShardSpec)new NoneShardSpec(), shardCount++);
                shardSpecs.put(bucket, Lists.newArrayList((Object[])new HadoopyShardSpec[]{spec}));
                log.info("DateTime[%s], spec[%s]", new Object[]{bucket, spec});
            }
            this.config.setShardSpecs(shardSpecs);
        }
        return JobHelper.runJobs(jobs, this.config);
    }
}

