/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexer;

import com.google.common.base.Charsets;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.metamx.common.IAE;
import com.metamx.common.logger.Logger;
import io.druid.data.input.InputRow;
import io.druid.data.input.MapBasedInputRow;
import io.druid.query.aggregation.Aggregator;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.serde.ComplexMetricSerde;
import io.druid.segment.serde.ComplexMetrics;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.io.WritableUtils;

public class InputRowSerde {
    private static final Logger log = new Logger(InputRowSerde.class);

    public static final byte[] toBytes(final InputRow row, AggregatorFactory[] aggs) {
        try {
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            out.writeLong(row.getTimestampFromEpoch());
            List dimList = row.getDimensions();
            WritableUtils.writeVInt((DataOutput)out, (int)dimList.size());
            if (dimList != null) {
                for (String dim : dimList) {
                    List dimValues = row.getDimension(dim);
                    InputRowSerde.writeString(dim, out);
                    InputRowSerde.writeStringArray(dimValues, out);
                }
            }
            Supplier<InputRow> supplier = new Supplier<InputRow>(){

                public InputRow get() {
                    return row;
                }
            };
            WritableUtils.writeVInt((DataOutput)out, (int)aggs.length);
            for (AggregatorFactory aggFactory : aggs) {
                String k = aggFactory.getName();
                InputRowSerde.writeString(k, out);
                Aggregator agg = aggFactory.factorize(IncrementalIndex.makeColumnSelectorFactory((AggregatorFactory)aggFactory, (Supplier)supplier, (boolean)true));
                agg.aggregate();
                String t = aggFactory.getTypeName();
                if (t.equals("float")) {
                    out.writeFloat(agg.getFloat());
                    continue;
                }
                if (t.equals("long")) {
                    WritableUtils.writeVLong((DataOutput)out, (long)agg.getLong());
                    continue;
                }
                Object val = agg.get();
                ComplexMetricSerde serde = InputRowSerde.getComplexMetricSerde(t);
                InputRowSerde.writeBytes(serde.toBytes(val), out);
            }
            return out.toByteArray();
        }
        catch (IOException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    private static void writeBytes(byte[] value, ByteArrayDataOutput out) throws IOException {
        WritableUtils.writeVInt((DataOutput)out, (int)value.length);
        out.write(value, 0, value.length);
    }

    private static void writeString(String value, ByteArrayDataOutput out) throws IOException {
        InputRowSerde.writeBytes(value.getBytes(Charsets.UTF_8), out);
    }

    private static void writeStringArray(List<String> values, ByteArrayDataOutput out) throws IOException {
        if (values == null || values.size() == 0) {
            WritableUtils.writeVInt((DataOutput)out, (int)0);
            return;
        }
        WritableUtils.writeVInt((DataOutput)out, (int)values.size());
        for (String value : values) {
            InputRowSerde.writeString(value, out);
        }
    }

    private static String readString(DataInput in) throws IOException {
        byte[] result = InputRowSerde.readBytes(in);
        return new String(result, Charsets.UTF_8);
    }

    private static byte[] readBytes(DataInput in) throws IOException {
        int size = WritableUtils.readVInt((DataInput)in);
        byte[] result = new byte[size];
        in.readFully(result, 0, size);
        return result;
    }

    private static List<String> readStringArray(DataInput in) throws IOException {
        int count = WritableUtils.readVInt((DataInput)in);
        if (count == 0) {
            return null;
        }
        ArrayList values = Lists.newArrayListWithCapacity((int)count);
        for (int i = 0; i < count; ++i) {
            values.add(InputRowSerde.readString(in));
        }
        return values;
    }

    public static final InputRow fromBytes(byte[] data, AggregatorFactory[] aggs) {
        try {
            ByteArrayDataInput in = ByteStreams.newDataInput((byte[])data);
            long timestamp = in.readLong();
            HashMap event = Maps.newHashMap();
            ArrayList dimensions = Lists.newArrayList();
            int dimNum = WritableUtils.readVInt((DataInput)in);
            for (int i = 0; i < dimNum; ++i) {
                String dimension = InputRowSerde.readString((DataInput)in);
                dimensions.add(dimension);
                List<String> dimensionValues = InputRowSerde.readStringArray((DataInput)in);
                if (dimensionValues == null) continue;
                if (dimensionValues.size() == 1) {
                    event.put(dimension, dimensionValues.get(0));
                    continue;
                }
                event.put(dimension, dimensionValues);
            }
            int metricSize = WritableUtils.readVInt((DataInput)in);
            for (int i = 0; i < metricSize; ++i) {
                String metric = InputRowSerde.readString((DataInput)in);
                String type = InputRowSerde.getType(metric, aggs, i);
                if (type.equals("float")) {
                    event.put(metric, Float.valueOf(in.readFloat()));
                    continue;
                }
                if (type.equals("long")) {
                    event.put(metric, WritableUtils.readVLong((DataInput)in));
                    continue;
                }
                ComplexMetricSerde serde = InputRowSerde.getComplexMetricSerde(type);
                byte[] value = InputRowSerde.readBytes((DataInput)in);
                event.put(metric, serde.fromBytes(value, 0, value.length));
            }
            return new MapBasedInputRow(timestamp, (List)dimensions, (Map)event);
        }
        catch (IOException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    private static String getType(String metric, AggregatorFactory[] aggs, int i) {
        if (aggs[i].getName().equals(metric)) {
            return aggs[i].getTypeName();
        }
        log.warn("Aggs disordered, fall backs to loop.", new Object[0]);
        for (AggregatorFactory agg : aggs) {
            if (!agg.getName().equals(metric)) continue;
            return agg.getTypeName();
        }
        return null;
    }

    private static ComplexMetricSerde getComplexMetricSerde(String type) {
        ComplexMetricSerde serde = ComplexMetrics.getSerdeForType((String)type);
        if (serde == null) {
            throw new IAE("Unknown type[%s]", new Object[]{type});
        }
        return serde;
    }
}

